/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.tamg.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.equipment.armor.BaseArmorItem;
import com.simibubi.create.foundation.item.LayeredArmorItem;
import com.simibubi.create.foundation.mixin.accessor.HumanoidArmorLayerAccessor;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import java.util.Locale;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.patryk3211.tamg.Tamg;
import org.patryk3211.tamg.armor.AdvancedArmorMaterial;
import org.patryk3211.tamg.collections.TamgRenderTypes;

@ParametersAreNonnullByDefault
public class AdvancedArmor
extends BaseArmorItem
implements LayeredArmorItem {
    public static final ResourceLocation TEXTURE = Tamg.asResource("advanced_armor");

    public static NonNullFunction<Item.Properties, AdvancedArmor> of(ArmorItem.Type type) {
        return p -> new AdvancedArmor(type, (Item.Properties)p);
    }

    public AdvancedArmor(ArmorItem.Type type, Item.Properties properties) {
        super((ArmorMaterial)AdvancedArmorMaterial.INSTANCE, type, properties, TEXTURE);
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        int base = super.getEnchantmentLevel(stack, enchantment);
        if (enchantment == Enchantments.f_44969_ || enchantment == Enchantments.f_44965_) {
            return Math.max(base, 1);
        }
        return base;
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        Map map = super.getAllEnchantments(stack);
        map.compute(Enchantments.f_44969_, (e, c) -> c == null ? 1 : Math.max(c, 1));
        map.compute(Enchantments.f_44965_, (e, c) -> c == null ? 1 : Math.max(c, 1));
        return map;
    }

    public String getArmorTextureLocation(LivingEntity entity, EquipmentSlot slot, ItemStack stack, int layer) {
        return String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d.png", TEXTURE.m_135827_(), TEXTURE.m_135815_(), layer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderArmorPiece(HumanoidArmorLayer<?, ?, ?> layer, PoseStack poseStack, MultiBufferSource bufferSource, LivingEntity entity, EquipmentSlot slot, int light, HumanoidModel<?> originalModel, ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof ArmorItem)) {
            return;
        }
        ArmorItem item2 = (ArmorItem)item;
        if (!item2.canEquip(stack, slot, (Entity)entity)) {
            return;
        }
        HumanoidArmorLayerAccessor accessor = (HumanoidArmorLayerAccessor)layer;
        Map locationCache = HumanoidArmorLayerAccessor.create$getArmorLocationCache();
        boolean glint = stack.m_41790_();
        HumanoidModel innerModel = accessor.create$getInnerModel();
        ((HumanoidModel)layer.m_117386_()).m_102872_(innerModel);
        accessor.create$callSetPartVisibility(innerModel, slot);
        String locationStr2 = this.getArmorTextureLocation(entity, slot, stack, 2);
        ResourceLocation location2 = locationCache.computeIfAbsent(locationStr2, ResourceLocation::new);
        this.renderModel(poseStack, bufferSource, light, item2, (Model)innerModel, glint, 1.0f, 1.0f, 1.0f, location2);
        HumanoidModel outerModel = accessor.create$getOuterModel();
        ((HumanoidModel)layer.m_117386_()).m_102872_(outerModel);
        accessor.create$callSetPartVisibility(outerModel, slot);
        String locationStr1 = this.getArmorTextureLocation(entity, slot, stack, 1);
        ResourceLocation location1 = locationCache.computeIfAbsent(locationStr1, ResourceLocation::new);
        this.renderModel(poseStack, bufferSource, light, item2, (Model)outerModel, glint, 1.0f, 1.0f, 1.0f, location1);
    }

    private void renderModel(PoseStack poseStack, MultiBufferSource bufferSource, int light, ArmorItem item, Model model, boolean glint, float red, float green, float blue, ResourceLocation armorResource) {
        VertexConsumer vertexconsumer = bufferSource.m_6299_(TamgRenderTypes.ARMOR_TRANSLUCENT_NO_CULL.apply(armorResource));
        model.m_7695_(poseStack, vertexconsumer, light, OverlayTexture.f_118083_, red, green, blue, 1.0f);
    }
}

