/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.tamg.collections;

import com.simibubi.create.foundation.particle.ICustomParticleData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class TamgParticles {
    private static final List<ParticleEntry<?>> all = new ArrayList();
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"tamg");

    private static <T extends ParticleOptions> ParticleType<T> register(String name, Supplier<? extends ICustomParticleData<T>> typeFactory) {
        ParticleType type = typeFactory.get().createType();
        PARTICLE_TYPES.register(name, () -> type);
        TamgParticles.addEntry(type, typeFactory);
        return type;
    }

    public static <T extends ParticleOptions> void addEntry(ParticleType<T> type, Supplier<? extends ICustomParticleData<T>> typeFactory) {
        all.add(new ParticleEntry<T>(type, typeFactory));
    }

    public static void register() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerFactories(RegisterParticleProvidersEvent event) {
        for (ParticleEntry<?> entry : all) {
            entry.registerFactory(event);
        }
    }

    private record ParticleEntry<T extends ParticleOptions>(ParticleType<T> type, Supplier<? extends ICustomParticleData<T>> typeFactory) {
        @OnlyIn(value=Dist.CLIENT)
        public void registerFactory(RegisterParticleProvidersEvent event) {
            this.typeFactory.get().register(this.type, event);
        }
    }
}

