/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.tamg.collections;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.AllSoundEvents;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.tamg.Tamg;

public class TamgSoundEvents {
    public static final Map<ResourceLocation, AllSoundEvents.SoundEntry> ALL = new HashMap<ResourceLocation, AllSoundEvents.SoundEntry>();
    public static final AllSoundEvents.SoundEntry GUN_SHOT = TamgSoundEvents.create("gun_shot").subtitle("Gun Shot").category(SoundSource.PLAYERS).build();

    private static SoundEntryBuilder create(String name) {
        return TamgSoundEvents.create(Tamg.asResource(name));
    }

    public static SoundEntryBuilder create(ResourceLocation id) {
        return new SoundEntryBuilder(id);
    }

    public static void prepare() {
        for (AllSoundEvents.SoundEntry entry : ALL.values()) {
            entry.prepare();
        }
    }

    public static void register(RegisterEvent event) {
        event.register(Registries.f_256840_, helper -> {
            for (AllSoundEvents.SoundEntry entry : ALL.values()) {
                entry.register(helper);
            }
        });
    }

    public static void provideLang(BiConsumer<String, String> consumer) {
        for (AllSoundEvents.SoundEntry entry : ALL.values()) {
            if (!entry.hasSubtitle()) continue;
            consumer.accept(entry.getSubtitleKey(), entry.getSubtitle());
        }
    }

    public static DataProvider provider(PackOutput output) {
        return new SoundEntryProvider(output);
    }

    public static class SoundEntryBuilder
    extends AllSoundEvents.SoundEntryBuilder {
        public SoundEntryBuilder(ResourceLocation id) {
            super(id);
        }

        public AllSoundEvents.SoundEntryBuilder addVariant(String name) {
            return this.addVariant(Tamg.asResource(name));
        }

        public AllSoundEvents.SoundEntry build() {
            AllSoundEvents.SoundEntry entry = super.build();
            ALL.put(entry.getId(), entry);
            return entry;
        }
    }

    private static class SoundEntryProvider
    implements DataProvider {
        private final PackOutput output;

        public SoundEntryProvider(PackOutput output) {
            this.output = output;
        }

        @NotNull
        public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) {
            return this.generate(this.output.m_245114_(), cache);
        }

        @NotNull
        public String m_6055_() {
            return "TAMG's Custom Sounds";
        }

        public CompletableFuture<?> generate(Path path, CachedOutput cache) {
            path = path.resolve("assets/tamg");
            JsonObject json = new JsonObject();
            ALL.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> ((AllSoundEvents.SoundEntry)entry.getValue()).write(json));
            return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)path.resolve("sounds.json"));
        }
    }
}

