/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.tamg.config;

import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.createmod.catnip.config.ConfigBase;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import org.patryk3211.tamg.Tamg;
import org.patryk3211.tamg.gun.GunItem;

public class CGuns
extends ConfigBase {
    private static final int VERSION = 1;
    private static final Object2DoubleMap<ResourceLocation> DEFAULT_DOUBLES = new Object2DoubleOpenHashMap();
    private static final Object2IntMap<ResourceLocation> DEFAULT_INTS = new Object2IntOpenHashMap();
    protected final Map<ResourceLocation, ForgeConfigSpec.ConfigValue<?>> values = new HashMap();

    public void registerAll(ForgeConfigSpec.Builder builder) {
        builder.comment(".").push("guns");
        DEFAULT_DOUBLES.forEach((id, value) -> this.values.put((ResourceLocation)id, (ForgeConfigSpec.ConfigValue<?>)builder.define(id.m_135815_(), value)));
        DEFAULT_INTS.forEach((id, value) -> this.values.put((ResourceLocation)id, (ForgeConfigSpec.ConfigValue<?>)builder.define(id.m_135815_(), value)));
        builder.pop();
    }

    public String getName() {
        return "guns-v1";
    }

    public double getDouble(GunItem item, GunProperties property) {
        return ((Number)this.values.get(property.makeKey(item)).get()).doubleValue();
    }

    public int getInt(GunItem item, GunProperties property) {
        return ((Number)this.values.get(property.makeKey(item)).get()).intValue();
    }

    public static <T extends GunItem, P> NonNullUnaryOperator<ItemBuilder<T, P>> base(double damage, double knockback, double heatCapacity, double heatPerShot, double heatDissipation, double selfKnockback, int useCooldown) {
        return b -> {
            ResourceLocation id = Tamg.asResource(b.getName());
            DEFAULT_DOUBLES.put((Object)GunProperties.DAMAGE.makeKey(id), damage);
            DEFAULT_DOUBLES.put((Object)GunProperties.KNOCKBACK.makeKey(id), knockback);
            DEFAULT_DOUBLES.put((Object)GunProperties.HEAT_CAPACITY.makeKey(id), heatCapacity);
            DEFAULT_DOUBLES.put((Object)GunProperties.HEAT_PER_SHOT.makeKey(id), heatPerShot);
            DEFAULT_DOUBLES.put((Object)GunProperties.HEAT_DISSIPATION.makeKey(id), heatDissipation);
            DEFAULT_DOUBLES.put((Object)GunProperties.SELF_KNOCKBACK.makeKey(id), selfKnockback);
            DEFAULT_INTS.put((Object)GunProperties.USE_COOLDOWN.makeKey(id), useCooldown);
            return b;
        };
    }

    public static enum GunProperties {
        DAMAGE("damage"),
        KNOCKBACK("knockback"),
        HEAT_CAPACITY("heat_capacity"),
        HEAT_PER_SHOT("heat_per_shot"),
        HEAT_DISSIPATION("heat_dissipation"),
        SELF_KNOCKBACK("self_knockback"),
        USE_COOLDOWN("use_cooldown");

        public final String key;

        private GunProperties(String key) {
            this.key = key;
        }

        public ResourceLocation makeKey(GunItem forItem) {
            ResourceLocation itemId = CatnipServices.REGISTRIES.getKeyOrThrow((Item)forItem);
            return this.makeKey(itemId);
        }

        public ResourceLocation makeKey(ResourceLocation id) {
            return id.m_266382_("." + this.key);
        }
    }
}

