/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.tamg.gun;

import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.patryk3211.tamg.collections.TamgDamageTypes;
import org.patryk3211.tamg.collections.TamgEntities;
import org.patryk3211.tamg.collections.TamgSoundEvents;
import org.patryk3211.tamg.config.CGuns;
import org.patryk3211.tamg.gun.GunItem;

public class BulletEntity
extends Projectile {
    private static final EntityDataAccessor<Byte> FLAGS = SynchedEntityData.m_135353_(BulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private float damage;
    private float knockback;

    public BulletEntity(EntityType<? extends Projectile> type, Level world) {
        super(type, world);
    }

    public static BulletEntity create(Level world, Vec3 position, Vec3 velocity, GunItem source) {
        BulletEntity entity = new BulletEntity((EntityType<? extends Projectile>)((EntityType)TamgEntities.BULLET.get()), world);
        entity.m_20343_(position.f_82479_, position.f_82480_, position.f_82481_);
        entity.m_20256_(velocity);
        ProjectileUtil.m_37284_((Entity)entity, (float)1.0f);
        entity.m_146867_();
        entity.m_20090_();
        entity.damage = source.configF(CGuns.GunProperties.DAMAGE);
        entity.knockback = source.configF(CGuns.GunProperties.KNOCKBACK);
        entity.getPersistentData().m_128405_("TTL", 100);
        return entity;
    }

    public BulletEntity withTTL(int ttl) {
        this.getPersistentData().m_128405_("TTL", ttl);
        return this;
    }

    public void small() {
        this.f_19804_.m_135381_(FLAGS, (Object)((byte)((Byte)this.f_19804_.m_135370_(FLAGS) | 1)));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(FLAGS, (Object)0);
    }

    public boolean isSmall() {
        return ((Byte)this.f_19804_.m_135370_(FLAGS) & 1) != 0;
    }

    public static void playLaunchSound(Level world, Vec3 location, float pitch) {
        TamgSoundEvents.GUN_SHOT.playAt(world, location, 1.0f, pitch, true);
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            int ttl = this.getPersistentData().m_128451_("TTL");
            if (ttl-- <= 0) {
                this.m_146870_();
                return;
            }
            this.getPersistentData().m_128405_("TTL", ttl);
        }
        super.m_8119_();
        HitResult hit = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        if (hit.m_6662_() != HitResult.Type.MISS) {
            this.m_6532_(hit);
        }
        this.m_20101_();
        Vec3 velocity = this.m_20184_();
        double x = this.m_20185_() + velocity.f_82479_;
        double y = this.m_20186_() + velocity.f_82480_;
        double z = this.m_20189_() + velocity.f_82481_;
        ProjectileUtil.m_37284_((Entity)this, (float)1.0f);
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.05, 0.0));
        }
        this.m_6034_(x, y, z);
    }

    private DamageSource causeDamage() {
        Registry registry = this.m_9236_().m_9598_().m_175515_(Registries.f_268580_);
        return new DamageSource((Holder)registry.m_203636_(TamgDamageTypes.GUN_SHOT).get(), (Entity)this, this.m_19749_());
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
    }

    protected void m_5790_(EntityHitResult hit) {
        Vec3 appliedMotion;
        boolean onServer;
        WitherBoss wither;
        Entity owner = this.m_19749_();
        Entity target = hit.m_82443_();
        if (!target.m_6084_()) {
            return;
        }
        if (owner instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)owner;
            living.m_21335_(target);
        }
        if (target instanceof WitherBoss && (wither = (WitherBoss)target).m_7090_()) {
            return;
        }
        float damage = this.damage;
        float knockback = this.knockback;
        Level world = this.m_9236_();
        DamageSource source = this.causeDamage();
        boolean bl = onServer = !world.f_46443_;
        if (onServer && !target.m_6469_(source, damage)) {
            this.m_6074_();
            return;
        }
        if (target.m_6095_() == EntityType.f_20566_) {
            return;
        }
        if (!(target instanceof LivingEntity)) {
            this.m_6074_();
            return;
        }
        LivingEntity livingTarget = (LivingEntity)target;
        if (onServer && knockback > 0.0f && (appliedMotion = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)knockback * 0.6)).m_82556_() > 0.0) {
            livingTarget.m_246865_(new Vec3(appliedMotion.f_82479_, 0.05, appliedMotion.f_82481_));
        }
        if (onServer && owner instanceof LivingEntity) {
            LivingEntity livingOwner = (LivingEntity)owner;
            EnchantmentHelper.m_44823_((LivingEntity)livingTarget, (Entity)livingOwner);
            EnchantmentHelper.m_44896_((LivingEntity)livingOwner, (Entity)livingTarget);
        }
        if (livingTarget != owner && livingTarget instanceof Player && owner instanceof ServerPlayer) {
            ServerPlayer ownerPlayer = (ServerPlayer)owner;
            if (!this.m_20067_()) {
                ownerPlayer.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
            }
        }
        if (onServer && owner instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)owner;
        }
        this.m_6074_();
    }

    protected void m_8060_(BlockHitResult hit) {
        super.m_8060_(hit);
        Level level = this.m_9236_();
        if (!level.f_46443_) {
            BlockState state = level.m_8055_(hit.m_82425_());
            SoundEvent sound = state.m_60827_().m_56778_();
            level.m_5594_(null, this.m_20183_(), sound, SoundSource.BLOCKS, 1.0f, 1.5f + this.f_19796_.m_188501_() * 0.1f);
        }
        this.m_6074_();
    }
}

