/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.tamg.gun;

import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public abstract class GunAnimationData {
    private static final RandomSource r = RandomSource.m_216327_();
    public final Player player;
    public final InteractionHand hand;
    private ItemStack old;
    private float prevFlash;
    private float flash;
    public float flashAngle;

    public GunAnimationData(Player player, InteractionHand hand) {
        this.player = player;
        this.hand = hand;
        this.old = player.m_21120_(hand);
        this.reset();
    }

    public boolean isFor(ItemStack stack) {
        if (this.old == stack) {
            return true;
        }
        ItemStack newStack = this.player.m_21120_(this.hand);
        if (!newStack.m_150930_(this.old.m_41720_())) {
            return false;
        }
        this.old = newStack;
        return newStack == stack;
    }

    public void reset() {
        this.flash = 1.0f;
        this.prevFlash = 1.0f;
        this.flashAngle = (float)((double)r.m_188501_() * Math.PI * 2.0);
    }

    public void tick() {
        this.prevFlash = this.flash;
        this.flash *= 0.5f;
    }

    public float flash(float pt) {
        return Mth.m_14179_((float)pt, (float)this.prevFlash, (float)this.flash);
    }

    public boolean isDone() {
        return this.flash < 0.05f;
    }

    public static float peakAt(float peak, float value) {
        if (value < peak) {
            return value / peak;
        }
        return (1.0f - value) / (1.0f - peak);
    }
}

