/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.tamg.gun;

import com.simibubi.create.content.equipment.zapper.ShootableGadgetItemMethods;
import com.simibubi.create.foundation.item.CustomArmPoseItem;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.theme.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.tamg.Lang;
import org.patryk3211.tamg.Networking;
import org.patryk3211.tamg.TamgClient;
import org.patryk3211.tamg.config.CGuns;
import org.patryk3211.tamg.config.TamgConfigs;
import org.patryk3211.tamg.gun.BulletEntity;
import org.patryk3211.tamg.gun.GunS2CPacket;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GunItem
extends ProjectileWeaponItem
implements CustomArmPoseItem {
    protected TagKey<Item> bulletTag = null;
    protected Vec3 flashOffset = Vec3.f_82478_;
    protected Vec3 barrel = Vec3.f_82478_;
    protected Vec3 correction = Vec3.f_82478_;
    public static final int COLOR_BAR_EMPTY = -235773;
    public static final int COLOR_BAR_FULL = -253949;
    private final boolean automatic;

    public GunItem(Item.Properties settings) {
        this(settings, false);
    }

    public GunItem(Item.Properties settings, boolean automatic) {
        super(settings.m_41487_(1));
        this.automatic = automatic;
    }

    public float configF(CGuns.GunProperties property) {
        return (float)TamgConfigs.server().guns.getDouble(this, property);
    }

    public int configI(CGuns.GunProperties property) {
        return TamgConfigs.server().guns.getInt(this, property);
    }

    public Predicate<ItemStack> m_6437_() {
        return stack -> stack.m_204117_(this.bulletTag);
    }

    public boolean isGun(ItemStack stack) {
        return stack.m_41720_() instanceof GunItem;
    }

    public int m_6615_() {
        return 15;
    }

    public boolean m_6777_(BlockState state, Level world, BlockPos pos, Player miner) {
        return false;
    }

    public static float getHeatAmount(ItemStack stack) {
        if (!stack.m_41782_()) {
            return 0.0f;
        }
        return stack.m_41783_().m_128457_("Heat");
    }

    public static float getHeatPercent(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof GunItem)) {
            return 0.0f;
        }
        GunItem gun = (GunItem)item;
        return GunItem.getHeatAmount(stack) / gun.configF(CGuns.GunProperties.HEAT_CAPACITY);
    }

    public boolean m_142522_(ItemStack stack) {
        return GunItem.getHeatAmount(stack) > 0.0f;
    }

    public int m_142158_(ItemStack stack) {
        return Mth.m_14143_((float)(GunItem.getHeatPercent(stack) * 13.0f));
    }

    public int m_142159_(ItemStack stack) {
        return Color.mixColors((int)-235773, (int)-253949, (float)GunItem.getHeatPercent(stack));
    }

    public Vec3 getBarrel(ItemStack stack) {
        return this.barrel;
    }

    public Vec3 getCorrection(ItemStack stack) {
        return this.correction;
    }

    public boolean applyHeat(ItemStack stack) {
        if (stack.m_41720_() != this) {
            throw new IllegalArgumentException("Stack must be of the correct item");
        }
        float current = GunItem.getHeatAmount(stack);
        if ((current += this.configF(CGuns.GunProperties.HEAT_PER_SHOT)) >= this.configF(CGuns.GunProperties.HEAT_CAPACITY)) {
            current = this.configF(CGuns.GunProperties.HEAT_CAPACITY);
        }
        stack.m_41784_().m_128350_("Heat", current);
        return current >= this.configF(CGuns.GunProperties.HEAT_CAPACITY);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        CompoundTag tag = stack.m_41784_();
        float current = GunItem.getHeatAmount(stack);
        if (current <= 0.0f) {
            return;
        }
        tag.m_128350_("Heat", Math.max(current - this.configF(CGuns.GunProperties.HEAT_DISSIPATION), 0.0f));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_() == null) {
            return InteractionResult.FAIL;
        }
        return this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
    }

    public void cooldownIfNotCoolingDown(Player player, int ticks) {
        if (player.m_36335_().m_41519_((Item)this)) {
            return;
        }
        player.m_36335_().m_41524_((Item)this, ticks);
    }

    protected void spawnProjectile(Level world, Vec3 barrelPos, Vec3 motion, Player user, ItemStack stack) {
        BulletEntity projectileEntity = BulletEntity.create(world, barrelPos, motion, this);
        projectileEntity.m_5602_((Entity)user);
        world.m_7967_((Entity)projectileEntity);
    }

    protected InteractionResult shoot(Level world, Player user, ItemStack stack, InteractionHand hand) {
        int cooldown;
        ItemStack projectile = user.m_6298_(stack);
        if (projectile.m_41619_()) {
            return InteractionResult.FAIL;
        }
        if (!user.m_7500_()) {
            projectile.m_41774_(1);
        }
        Vec3 barrelPos = ShootableGadgetItemMethods.getGunBarrelVec((Player)user, (hand == InteractionHand.MAIN_HAND ? 1 : 0) != 0, (Vec3)this.getBarrel(stack));
        Vec3 correction = ShootableGadgetItemMethods.getGunBarrelVec((Player)user, (hand == InteractionHand.MAIN_HAND ? 1 : 0) != 0, (Vec3)this.getCorrection(stack)).m_82546_(user.m_20182_().m_82520_(0.0, (double)user.m_20192_(), 0.0));
        Vec3 lookVec = user.m_20154_();
        Vec3 motion = lookVec.m_82549_(correction).m_82541_().m_82490_(4.0);
        this.spawnProjectile(world, barrelPos, motion, user, stack);
        if (this.applyHeat(stack)) {
            ShootableGadgetItemMethods.applyCooldown((Player)user, (ItemStack)stack, (InteractionHand)hand, this::isGun, (int)100);
            if (this.automatic) {
                user.m_5810_();
            }
        }
        Function<Boolean, GunS2CPacket> factory = b -> new GunS2CPacket(barrelPos, hand, (boolean)b, user);
        float selfKnockback = this.configF(CGuns.GunProperties.SELF_KNOCKBACK);
        if (selfKnockback > 0.0f) {
            Vec3 selfMotion = lookVec.m_82541_().m_82490_((double)(-selfKnockback));
            user.m_246865_(selfMotion);
            user.f_19864_ = true;
        }
        if ((cooldown = this.configI(CGuns.GunProperties.USE_COOLDOWN)) > 0) {
            this.cooldownIfNotCoolingDown(user, cooldown);
        }
        PacketDistributor.PacketTarget trackingUser = PacketDistributor.TRACKING_ENTITY.with(() -> user);
        PacketDistributor.PacketTarget userDist = PacketDistributor.PLAYER.with(() -> (ServerPlayer)user);
        Networking.getChannel().send(trackingUser, (Object)factory.apply(false));
        Networking.getChannel().send(userDist, (Object)factory.apply(true));
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.m_21120_(hand);
        if (world.f_46443_) {
            TamgClient.GUN_RENDER_HANDLER.dontAnimateItem(hand);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (this.automatic) {
            user.m_6672_(hand);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return new InteractionResultHolder(this.shoot(world, user, stack, hand), (Object)stack);
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int pRemainingUseDuration) {
        if (world.f_46443_ || !this.automatic) {
            return;
        }
        if (!(user instanceof Player)) {
            return;
        }
        Player player = (Player)user;
        if (pRemainingUseDuration % 2 == 0) {
            InteractionHand hand = user.m_21205_() == stack ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            this.shoot(world, player, stack, hand);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        float knockbackF;
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237115_((String)"tamg.gun.bullet").m_7220_((Component)Component.m_237113_((String)":")).m_130940_(ChatFormatting.GRAY));
        MutableComponent spacing = Component.m_237113_((String)" ");
        float damageF = this.configF(CGuns.GunProperties.DAMAGE);
        if (damageF > 0.0f) {
            MutableComponent damage = Component.m_237113_((String)(damageF == (float)Mth.m_14143_((float)damageF) ? "" + Mth.m_14143_((float)damageF) : "" + damageF));
            tooltip.add((Component)spacing.m_6879_().m_7220_((Component)Lang.translateDirect("gun.bullet.damage", damage).m_130940_(ChatFormatting.DARK_GREEN)));
        }
        if ((knockbackF = this.configF(CGuns.GunProperties.KNOCKBACK)) > 0.0f) {
            MutableComponent knockback = Component.m_237113_((String)(knockbackF == (float)Mth.m_14143_((float)knockbackF) ? "" + Mth.m_14143_((float)knockbackF) : "" + knockbackF));
            tooltip.add((Component)spacing.m_6879_().m_7220_((Component)Lang.translateDirect("gun.bullet.knockback", knockback).m_130940_(ChatFormatting.DARK_GREEN)));
        }
        super.m_7373_(stack, world, tooltip, context);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable HumanoidModel.ArmPose getArmPose(ItemStack stack, AbstractClientPlayer player, InteractionHand hand) {
        if (!player.f_20911_) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return null;
    }

    public boolean onEntitySwing(ItemStack itemStack, LivingEntity livingEntity) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || newStack.m_41720_() != oldStack.m_41720_();
    }

    public boolean hasZoom() {
        return false;
    }
}

