/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.tamg.gun;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.equipment.zapper.ShootableGadgetRenderHandler;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.tamg.gun.BulletEntity;
import org.patryk3211.tamg.gun.GunAnimationData;
import org.patryk3211.tamg.gun.GunItem;

@OnlyIn(value=Dist.CLIENT)
public class GunRenderHandler
extends ShootableGadgetRenderHandler {
    private final List<GunAnimationData> animationProgress = new ArrayList<GunAnimationData>();
    public static final Map<GunItem, BiFunction<Player, InteractionHand, GunAnimationData>> animationConstructors = new HashMap<GunItem, BiFunction<Player, InteractionHand, GunAnimationData>>();

    protected void beforeShoot(Player shooter, InteractionHand hand) {
        BiFunction<Player, InteractionHand, GunAnimationData> constructor;
        boolean reset = false;
        for (GunAnimationData data : this.animationProgress) {
            if (data.player != shooter || data.hand != hand) continue;
            data.reset();
            reset = true;
            break;
        }
        if (!reset && (constructor = animationConstructors.get(shooter.m_21120_(hand).m_41720_())) != null) {
            this.animationProgress.add(constructor.apply(shooter, hand));
        }
    }

    public void tick() {
        super.tick();
        this.animationProgress.removeIf(data -> {
            data.tick();
            return data.isDone();
        });
    }

    protected void playSound(InteractionHand hand, Vec3 position) {
        BulletEntity.playLaunchSound((Level)Minecraft.m_91087_().f_91073_, position, 1.0f);
    }

    protected boolean appliesTo(ItemStack stack) {
        return stack.m_41720_() instanceof GunItem;
    }

    protected void transformTool(PoseStack ms, float flip, float equipProgress, float recoil, float pt) {
        ms.m_252880_(flip * -0.1f, 0.0f, 0.14f);
        ms.m_85841_(0.75f, 0.75f, 0.75f);
        TransformStack.of((PoseStack)ms).rotateXDegrees(recoil * 80.0f);
    }

    protected void transformHand(PoseStack ms, float flip, float equipProgress, float recoil, float pt) {
        ms.m_85837_((double)flip * -0.09, -0.275, -0.25);
        TransformStack.of((PoseStack)ms).rotateZDegrees(flip * -10.0f);
    }

    @Nullable
    public GunAnimationData getAnimation(ItemStack stack) {
        for (GunAnimationData data : this.animationProgress) {
            if (!data.isFor(stack)) continue;
            return data;
        }
        return null;
    }
}

