/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.tamg.gun.revolver;

import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import org.patryk3211.tamg.gun.GunAnimationData;

public class RevolverAnimationData
extends GunAnimationData {
    private static final RandomSource r = RandomSource.m_216327_();
    private LerpedFloat hammer;
    private LerpedFloat drum;

    public RevolverAnimationData(Player player, InteractionHand hand) {
        super(player, hand);
    }

    @Override
    public void reset() {
        super.reset();
        if (this.hammer == null) {
            this.hammer = LerpedFloat.linear();
            this.drum = LerpedFloat.linear();
        }
        this.hammer.setValue(0.0);
        this.hammer.chaseTimed(1.0, 4);
        this.drum.setValue(0.0);
        this.drum.chaseTimed(1.0, 6);
    }

    @Override
    public void tick() {
        super.tick();
        this.hammer.tickChaser();
        this.drum.tickChaser();
    }

    public float hammer(float pt) {
        float value = this.hammer.getValue(pt);
        return RevolverAnimationData.peakAt(0.125f, value) * (float)Math.PI * -0.2f;
    }

    public float drum(float pt) {
        return this.drum.getValue(pt) * (float)Math.PI * 0.5f;
    }

    @Override
    public boolean isDone() {
        return super.isDone() && this.hammer.settled() && this.drum.settled();
    }
}

