/*
 * Decompiled with CFR 0.152.
 */
package me.demstudios;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import me.demstudios.BLAuction;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Auction {
    private final UUID id;
    private final UUID sellerId;
    private final String sellerName;
    private Player seller;
    private final ItemStack itemStack;
    private final double price;
    private final int amount;
    private int timeRemaining;
    private final Economy economy;
    private final BLAuction plugin;
    private final String auctionType;
    private long createdAt;
    private UUID buyerId;
    private String buyerName;
    private double finalPrice;

    public Auction(UUID id, Player seller, ItemStack itemStack, double price, int amount, Economy economy, BLAuction plugin) {
        this(id, seller.getUniqueId(), seller.getName(), itemStack, price, amount, economy, plugin, "normal");
        this.seller = seller;
    }

    public Auction(UUID id, Player seller, ItemStack itemStack, double price, int amount, Economy economy, BLAuction plugin, String auctionType) {
        this(id, seller.getUniqueId(), seller.getName(), itemStack, price, amount, economy, plugin, auctionType);
        this.seller = seller;
    }

    public Auction(UUID id, UUID sellerId, String sellerName, ItemStack itemStack, double price, int amount, Economy economy, BLAuction plugin) {
        this(id, sellerId, sellerName, itemStack, price, amount, economy, plugin, "normal");
    }

    public Auction(UUID id, UUID sellerId, String sellerName, ItemStack itemStack, double price, int amount, Economy economy, BLAuction plugin, String auctionType) {
        this.id = id;
        this.sellerId = sellerId;
        this.sellerName = sellerName;
        this.itemStack = itemStack.clone();
        this.price = price;
        this.amount = amount;
        this.economy = economy;
        this.plugin = plugin;
        this.auctionType = auctionType;
        this.timeRemaining = plugin.getAuctionDuration();
        this.createdAt = System.currentTimeMillis() / 1000L;
    }

    public ItemStack getItem() {
        return this.itemStack.clone();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void buyItem(Player buyer) {
        if (!this.isActive()) {
            return;
        }
        if (buyer.getUniqueId().equals(this.sellerId)) {
            buyer.sendMessage(this.plugin.getMessageManager().getAuctionMessage("cannot-buy-own"));
            return;
        }
        this.buyerId = buyer.getUniqueId();
        this.buyerName = buyer.getName();
        this.finalPrice = this.price;
        this.plugin.getPlayerDataManager().getPlayerStats(buyer.getUniqueId()).addAuctionWon(this.finalPrice);
        this.plugin.getPlayerDataManager().getPlayerStats(this.sellerId).addRevenue(this.finalPrice);
        if ("donor".equals(this.auctionType)) {
            Object playerPointsAPI = this.plugin.getPlayerPointsAPI();
            if (playerPointsAPI == null) {
                buyer.sendMessage(this.plugin.getMessageManager().getGeneralMessage("economy-disabled"));
                return;
            }
            try {
                int currentBalance = (Integer)playerPointsAPI.getClass().getMethod("look", String.class).invoke(playerPointsAPI, buyer.getName());
                if (!((double)currentBalance >= this.price)) {
                    buyer.sendMessage(this.plugin.getMessageManager().getAuctionMessage("not-enough-money"));
                    return;
                }
                playerPointsAPI.getClass().getMethod("take", String.class, Integer.TYPE).invoke(playerPointsAPI, buyer.getName(), (int)this.price);
                playerPointsAPI.getClass().getMethod("give", String.class, Integer.TYPE).invoke(playerPointsAPI, Bukkit.getOfflinePlayer((UUID)this.sellerId).getName(), (int)this.price);
            }
            catch (Exception e) {
                buyer.sendMessage(this.plugin.getMessageManager().getGeneralMessage("economy-disabled"));
                return;
            }
        } else {
            if (this.economy == null) {
                buyer.sendMessage(this.plugin.getMessageManager().getGeneralMessage("economy-disabled"));
                return;
            }
            this.economy.withdrawPlayer((OfflinePlayer)buyer, this.finalPrice);
            this.economy.depositPlayer(Bukkit.getOfflinePlayer((UUID)this.sellerId), this.finalPrice);
        }
        ItemStack itemToGive = this.itemStack.clone();
        itemToGive.setAmount(this.amount);
        HashMap leftover = buyer.getInventory().addItem(new ItemStack[]{itemToGive});
        if (!leftover.isEmpty()) {
            for (ItemStack item : leftover.values()) {
                buyer.getWorld().dropItem(buyer.getLocation(), item);
            }
        }
        this.plugin.getAuctionManager().removeAuction(this.sellerId, this.id);
    }

    private void expireAuction() {
        this.plugin.getPlayerDataManager().addToStorage(this.sellerId, this.itemStack.clone(), this.price, null);
        this.plugin.getAuctionManager().removeAuction(this.sellerId, this.id);
        Player sellerPlayer = Bukkit.getPlayer((UUID)this.sellerId);
        if (sellerPlayer != null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("item", this.itemStack.getType().toString());
            placeholders.put("amount", String.valueOf(this.amount));
            sellerPlayer.sendMessage(this.plugin.getMessageManager().getAuctionMessage("expired", placeholders));
        }
    }

    public ItemStack createAuctionItem() {
        ItemStack displayItem = this.itemStack.clone();
        ItemMeta meta = displayItem.getItemMeta();
        if (meta != null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("seller", this.sellerName);
            placeholders.put("price", this.economy != null ? this.economy.format(this.price) : String.format("%.2f", this.price));
            placeholders.put("amount", String.valueOf(this.amount));
            placeholders.put("time", this.formatTime(this.timeRemaining));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(this.plugin.getMessageManager().getAuctionItemMessage("seller", placeholders));
            lore.add(this.plugin.getMessageManager().getAuctionItemMessage("price", placeholders));
            lore.add(this.plugin.getMessageManager().getAuctionItemMessage("amount", placeholders));
            lore.add(this.plugin.getMessageManager().getAuctionItemMessage("time-left", placeholders));
            lore.add("");
            lore.add(this.plugin.getMessageManager().getAuctionItemMessage("buy-action"));
            if (this.seller != null && this.seller.getUniqueId().equals(this.sellerId)) {
                lore.add(this.plugin.getMessageManager().getAuctionItemMessage("cancel-action"));
            }
            meta.setLore(lore);
            displayItem.setItemMeta(meta);
        }
        return displayItem;
    }

    private String formatTime(int seconds) {
        int hours = seconds / 3600;
        int minutes = seconds % 3600 / 60;
        int secs = seconds % 60;
        return String.format("%02d:%02d:%02d", hours, minutes, secs);
    }

    public void setSeller(Player player) {
        if (player != null && player.getUniqueId().equals(this.sellerId)) {
            this.seller = player;
        }
    }

    public void setBuyer(UUID buyerId, String buyerName) {
        this.buyerId = buyerId;
        this.buyerName = buyerName;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getSellerId() {
        return this.sellerId;
    }

    public String getSellerName() {
        return this.sellerName;
    }

    public Player getSeller() {
        return this.seller;
    }

    public ItemStack getItemStack() {
        return this.itemStack.clone();
    }

    public double getPrice() {
        return this.price;
    }

    public int getAmount() {
        return this.amount;
    }

    public int getTimeRemaining() {
        return this.timeRemaining;
    }

    public void setTimeRemaining(int timeRemaining) {
        this.timeRemaining = Math.max(0, timeRemaining);
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public boolean isActive() {
        return this.timeRemaining > 0;
    }

    public UUID getBuyerId() {
        return this.buyerId;
    }

    public String getBuyerName() {
        return this.buyerName;
    }

    public String getAuctionType() {
        return this.auctionType;
    }
}

