/*
 * Decompiled with CFR 0.152.
 */
package me.demstudios;

import java.util.Objects;
import me.demstudios.commands.AuctionCommand;
import me.demstudios.commands.TraderCommand;
import me.demstudios.database.AuctionDatabase;
import me.demstudios.expansion.AuctionPlaceholders;
import me.demstudios.managers.AuctionGUI;
import me.demstudios.managers.AuctionListener;
import me.demstudios.managers.AuctionManager;
import me.demstudios.managers.MessageManager;
import me.demstudios.managers.PlayerDataManager;
import me.demstudios.managers.TraderGUI;
import me.demstudios.managers.TraderManager;
import me.demstudios.utils.ItemNameUtils;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class BLAuction
extends JavaPlugin {
    private Economy economy;
    private Object playerPointsAPI;
    private AuctionDatabase database;
    private AuctionManager auctionManager;
    private PlayerDataManager playerDataManager;
    private AuctionGUI auctionGUI;
    private TraderManager traderManager;
    private TraderGUI traderGUI;
    private MessageManager messageManager;
    private String currentAuctionType = "normal";

    public void onEnable() {
        this.getLogger().info("\u041f\u043b\u0430\u0433\u0438\u043d BLAuction-v" + this.getDescription().getVersion() + " \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u043f\u0443\u0449\u0435\u043d. \u041f\u0440\u0438\u044f\u0442\u043d\u043e\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f!");
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new AuctionPlaceholders(this).register();
            this.getLogger().info("PlaceholderAPI \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043e!");
        }
        this.saveDefaultConfig();
        this.reloadConfig();
        System.setProperty("sun.net.client.defaultConnectTimeout", "5000");
        System.setProperty("sun.net.client.defaultReadTimeout", "5000");
        this.setupEconomy();
        this.setupPlayerPoints();
        try {
            this.database = new AuctionDatabase(this);
            this.database.connect();
            this.getLogger().info("\u0411\u0430\u0437\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0430");
        }
        catch (Exception e) {
            this.getLogger().warning("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a \u0411\u0414: " + e.getMessage());
            this.getLogger().warning("\u041f\u043b\u0430\u0433\u0438\u043d \u0431\u0443\u0434\u0435\u0442 \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u0431\u0435\u0437 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445");
            this.database = null;
        }
        this.messageManager = new MessageManager(this);
        ItemNameUtils.loadCustomNamesFromConfig(this.messageManager);
        this.playerDataManager = new PlayerDataManager(this);
        this.auctionManager = new AuctionManager(this);
        this.auctionGUI = new AuctionGUI(this);
        this.traderManager = new TraderManager(this);
        this.traderGUI = new TraderGUI(this);
        this.getServer().getPluginManager().registerEvents((Listener)new AuctionListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.traderGUI, (Plugin)this);
        Objects.requireNonNull(this.getCommand("auc")).setExecutor((CommandExecutor)new AuctionCommand(this));
        Objects.requireNonNull(this.getCommand("trader")).setExecutor((CommandExecutor)new TraderCommand(this));
        this.getLogger().info("BLAuction \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d!");
    }

    public void onDisable() {
        try {
            if (this.auctionManager != null) {
                this.auctionManager.saveAllData();
            }
            if (this.database != null) {
                this.database.close();
            }
        }
        catch (Exception e) {
            this.getLogger().warning("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438: " + e.getMessage());
        }
        this.getLogger().info("BLAuction \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d");
    }

    public int getAuctionDuration() {
        return this.getConfig().getInt("settings.auction-duration", 86400);
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.getLogger().warning("Vault \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d! \u041f\u043b\u0430\u0433\u0438\u043d \u0431\u0443\u0434\u0435\u0442 \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u0431\u0435\u0437 \u044d\u043a\u043e\u043d\u043e\u043c\u0438\u043a\u0438.");
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            this.getLogger().warning("\u042d\u043a\u043e\u043d\u043e\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043f\u043b\u0430\u0433\u0438\u043d \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        if (this.economy == null) {
            this.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u044d\u043a\u043e\u043d\u043e\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440!");
            return false;
        }
        this.getLogger().info("\u042d\u043a\u043e\u043d\u043e\u043c\u0438\u043a\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0430: " + this.economy.getName());
        return true;
    }

    private boolean setupPlayerPoints() {
        if (this.getServer().getPluginManager().getPlugin("PlayerPoints") == null) {
            this.getLogger().warning("PlayerPoints \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d! \u0414\u043e\u043d\u0430\u0442 \u0430\u0443\u043a\u0446\u0438\u043e\u043d \u0431\u0443\u0434\u0435\u0442 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d.");
            return false;
        }
        try {
            Class<?> playerPointsClass = Class.forName("org.black_ixx.playerpoints.PlayerPoints");
            Object playerPointsInstance = playerPointsClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            this.playerPointsAPI = playerPointsInstance.getClass().getMethod("getAPI", new Class[0]).invoke(playerPointsInstance, new Object[0]);
            this.getLogger().info("PlayerPoints \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d!");
            return true;
        }
        catch (Exception e) {
            this.getLogger().warning("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438 PlayerPoints: " + e.getMessage());
            return false;
        }
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public Object getPlayerPointsAPI() {
        return this.playerPointsAPI;
    }

    public String getCurrentAuctionType() {
        return this.currentAuctionType;
    }

    public void setCurrentAuctionType(String type) {
        this.currentAuctionType = type;
    }

    public AuctionDatabase getDatabase() {
        return this.database;
    }

    public AuctionManager getAuctionManager() {
        return this.auctionManager;
    }

    public PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }

    public AuctionGUI getAuctionGUI() {
        return this.auctionGUI;
    }

    public TraderManager getTraderManager() {
        return this.traderManager;
    }

    public TraderGUI getTraderGUI() {
        return this.traderGUI;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }
}

