/*
 * Decompiled with CFR 0.152.
 */
package me.demstudios.commands;

import me.demstudios.BLAuction;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AuctionCommand
implements CommandExecutor {
    private final BLAuction plugin;

    public AuctionCommand(BLAuction plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessageManager().getCommandsMessage("player-only"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.plugin.getAuctionGUI().openAuctionMenu(player, 0);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "sell": {
                this.handleSellCommand(player, args, "normal");
                break;
            }
            case "dsell": {
                this.handleSellCommand(player, args, "donor");
                break;
            }
            case "storage": {
                this.plugin.getAuctionGUI().openStorageMenu(player);
                break;
            }
            default: {
                this.sendHelpMessage(player);
            }
        }
        return true;
    }

    private void handleSellCommand(Player player, String[] args, String auctionType) {
        if (args.length < 2) {
            String usage = auctionType.equals("donor") ? "/auc dsell <\u0446\u0435\u043d\u0430 \u0437\u0430 \u0432\u0435\u0441\u044c \u0441\u0442\u0430\u043a>" : "/auc sell <\u0446\u0435\u043d\u0430 \u0437\u0430 \u0432\u0435\u0441\u044c \u0441\u0442\u0430\u043a>";
            player.sendMessage(this.plugin.getMessageManager().getCommandsMessage("usage").replace("{usage}", usage));
            return;
        }
        try {
            double price = Double.parseDouble(args[1]);
            if (price < this.plugin.getConfig().getDouble("settings.minimum-price", 10.0)) {
                player.sendMessage(this.plugin.getMessageManager().getCommandsMessage("minimum-price").replace("{price}", String.valueOf(this.plugin.getConfig().getDouble("settings.minimum-price", 10.0))));
                return;
            }
            ItemStack item = player.getInventory().getItemInMainHand();
            if (item == null || item.getType().isAir()) {
                player.sendMessage(this.plugin.getMessageManager().getCommandsMessage("no-item-in-hand"));
                return;
            }
            player.getInventory().setItemInMainHand(null);
            this.plugin.getAuctionManager().startAuction(player, item, price, auctionType);
            this.plugin.getAuctionManager().saveAllData();
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.plugin.getMessageManager().getCommandsMessage("invalid-price"));
        }
    }

    private void sendHelpMessage(Player player) {
        String[] helpMessages = new String[]{this.plugin.getMessageManager().getCommandsMessage("auction-command-help-header"), this.plugin.getMessageManager().getCommandsMessage("auction-command-help-main"), this.plugin.getMessageManager().getCommandsMessage("auction-command-help-sell"), this.plugin.getMessageManager().getCommandsMessage("auction-command-help-dsell"), this.plugin.getMessageManager().getCommandsMessage("auction-command-help-storage"), this.plugin.getMessageManager().getCommandsMessage("auction-command-help-categories"), this.plugin.getMessageManager().getCommandsMessage("auction-command-help-profile")};
        player.sendMessage(helpMessages);
    }
}

