/*
 * Decompiled with CFR 0.152.
 */
package me.demstudios.compatibility;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;

public class MaterialCompat {
    private static final Map<String, Material> materialAliases = new HashMap<String, Material>();

    public static Material getMaterial(String ... names) {
        for (String name : names) {
            try {
                Material mat;
                if (materialAliases.containsKey(name) && (mat = materialAliases.get(name)) != null) {
                    return mat;
                }
                Material material = Material.valueOf((String)name);
                if (material == null) continue;
                return material;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Material.AIR;
    }

    private static Material getModernMaterial(String ... names) {
        for (String name : names) {
            try {
                return Material.valueOf((String)name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return Material.AIR;
    }

    static {
        materialAliases.put("STAINED_GLASS_PANE", MaterialCompat.getModernMaterial("BLACK_STAINED_GLASS_PANE", "STAINED_GLASS_PANE"));
        materialAliases.put("SIGN", MaterialCompat.getModernMaterial("OAK_SIGN", "SIGN"));
        materialAliases.put("WOOD_DOOR", MaterialCompat.getModernMaterial("OAK_DOOR", "WOODEN_DOOR", "WOOD_DOOR"));
        materialAliases.put("WOOD_STAIRS", MaterialCompat.getModernMaterial("OAK_STAIRS", "WOOD_STAIRS"));
        materialAliases.put("WORKBENCH", MaterialCompat.getModernMaterial("CRAFTING_TABLE", "WORKBENCH"));
        materialAliases.put("EXP_BOTTLE", MaterialCompat.getModernMaterial("EXPERIENCE_BOTTLE", "EXP_BOTTLE"));
        materialAliases.put("MOB_SPAWNER", MaterialCompat.getModernMaterial("SPAWNER", "MOB_SPAWNER"));
        materialAliases.put("SKULL_ITEM", MaterialCompat.getModernMaterial("PLAYER_HEAD", "SKULL_ITEM"));
        materialAliases.put("INK_SACK", MaterialCompat.getModernMaterial("INK_SAC", "INK_SACK"));
        materialAliases.put("GOLD_RECORD", MaterialCompat.getModernMaterial("MUSIC_DISC_13", "GOLD_RECORD"));
    }
}

