/*
 * Decompiled with CFR 0.152.
 */
package me.demstudios.compatibility;

import org.bukkit.Bukkit;

public class VersionChecker {
    private static String serverVersion;

    public static String getServerVersion() {
        return serverVersion;
    }

    public static boolean isVersion(String version) {
        return serverVersion.contains(version);
    }

    public static boolean isVersionOrNewer(String version) {
        String[] currentParts = serverVersion.split("_");
        String[] targetParts = version.split("_");
        try {
            int currentMajor = Integer.parseInt(currentParts[1]);
            int targetMajor = Integer.parseInt(targetParts[1]);
            if (currentMajor > targetMajor) {
                return true;
            }
            if (currentMajor < targetMajor) {
                return false;
            }
            if (targetParts.length > 2) {
                int targetMinor;
                int currentMinor = Integer.parseInt(currentParts[2].replaceAll("[^0-9]", ""));
                return currentMinor >= (targetMinor = Integer.parseInt(targetParts[2].replaceAll("[^0-9]", "")));
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isVersionBetween(String minVersion, String maxVersion) {
        return VersionChecker.isVersionOrNewer(minVersion) && !VersionChecker.isVersionOrNewer(maxVersion);
    }

    static {
        String packageName = Bukkit.getServer().getClass().getPackage().getName();
        serverVersion = packageName.substring(packageName.lastIndexOf(46) + 1);
    }
}

