/*
 * Decompiled with CFR 0.152.
 */
package me.demstudios.expansion;

import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.demstudios.BLAuction;
import me.demstudios.stats.PlayerStats;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class AuctionPlaceholders
extends PlaceholderExpansion {
    private final BLAuction plugin;

    public AuctionPlaceholders(BLAuction plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "blauction";
    }

    @NotNull
    public String getAuthor() {
        return "BLStudios";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public String onRequest(OfflinePlayer player, @NotNull String params) {
        if (player == null) {
            return "";
        }
        PlayerStats stats = this.plugin.getPlayerDataManager().getPlayerStats(player.getUniqueId());
        switch (params.toLowerCase()) {
            case "sold": {
                return String.valueOf(stats.getAuctionsCreated());
            }
            case "bought": {
                return String.valueOf(stats.getAuctionsWon());
            }
            case "revenue": {
                return String.format("%.2f", stats.getTotalRevenue());
            }
            case "spent": {
                return String.format("%.2f", stats.getTotalSpent());
            }
            case "profit": {
                return String.format("%.2f", stats.getProfit());
            }
            case "active_lots": {
                return String.valueOf(this.plugin.getAuctionManager().getActiveAuctions().stream().filter(a -> a.getSellerId().equals(player.getUniqueId())).count());
            }
            case "storage_items": {
                return String.valueOf(this.plugin.getPlayerDataManager().getPlayerStorage(player.getUniqueId()).size());
            }
        }
        return null;
    }
}

