/*
 * Decompiled with CFR 0.152.
 */
package me.demstudios.libs.org.json;

public class JSONMLParserConfiguration {
    public static final int UNDEFINED_MAXIMUM_NESTING_DEPTH = -1;
    public static final int DEFAULT_MAXIMUM_NESTING_DEPTH = 512;
    public static final JSONMLParserConfiguration ORIGINAL = new JSONMLParserConfiguration();
    public static final JSONMLParserConfiguration KEEP_STRINGS = new JSONMLParserConfiguration().withKeepStrings(true);
    private boolean keepStrings;
    private int maxNestingDepth = 512;

    public JSONMLParserConfiguration() {
        this.keepStrings = false;
    }

    private JSONMLParserConfiguration(boolean keepStrings, int maxNestingDepth) {
        this.keepStrings = keepStrings;
        this.maxNestingDepth = maxNestingDepth;
    }

    protected JSONMLParserConfiguration clone() {
        return new JSONMLParserConfiguration(this.keepStrings, this.maxNestingDepth);
    }

    public boolean isKeepStrings() {
        return this.keepStrings;
    }

    public JSONMLParserConfiguration withKeepStrings(boolean newVal) {
        JSONMLParserConfiguration newConfig = this.clone();
        newConfig.keepStrings = newVal;
        return newConfig;
    }

    public int getMaxNestingDepth() {
        return this.maxNestingDepth;
    }

    public JSONMLParserConfiguration withMaxNestingDepth(int maxNestingDepth) {
        JSONMLParserConfiguration newConfig = this.clone();
        newConfig.maxNestingDepth = maxNestingDepth > -1 ? maxNestingDepth : -1;
        return newConfig;
    }
}

