/*
 * Decompiled with CFR 0.152.
 */
package me.demstudios.managers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.demstudios.Auction;
import me.demstudios.BLAuction;
import me.demstudios.managers.AuctionManager;
import me.demstudios.managers.PlayerDataManager;
import me.demstudios.stats.PlayerStats;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class AuctionGUI {
    private final BLAuction plugin;
    private final AuctionManager auctionManager;
    private final PlayerDataManager playerDataManager;
    private static final Map<UUID, ItemStack> PLAYER_HEAD_CACHE = new ConcurrentHashMap<UUID, ItemStack>();

    public AuctionGUI(BLAuction plugin) {
        this.plugin = plugin;
        this.auctionManager = plugin.getAuctionManager();
        this.playerDataManager = plugin.getPlayerDataManager();
    }

    public String getMessage(String key) {
        return this.plugin.getMessageManager().getMessage(key);
    }

    public String getAuctionTitle() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("gui-settings.auction-title", "\u00a76\u0410\u0443\u043a\u0446\u0438\u043e\u043d"));
    }

    public String getStorageTitle() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("gui-settings.storage-title", "\u00a76\u0421\u043a\u043b\u0430\u0434 \u0430\u0443\u043a\u0446\u0438\u043e\u043d\u0430"));
    }

    public String getProfileTitle() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("gui-settings.profile-title", "\u00a7a\u0412\u0430\u0448 \u043f\u0440\u043e\u0444\u0438\u043b\u044c"));
    }

    public void openAuctionMenu(Player player, int page) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            Inventory menu = Bukkit.createInventory(null, (int)54, (String)(this.getAuctionTitle() + " \u00a77(\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430 " + (page + 1) + "/" + this.auctionManager.getTotalPages() + ")"));
            List<Auction> auctions = this.auctionManager.getFilteredAuctions(page);
            int i = 0;
            while (i < Math.min(auctions.size(), 45)) {
                ItemStack auctionItem = auctions.get(i).createAuctionItem();
                int finalI = i++;
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> menu.setItem(finalI, auctionItem));
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                this.addInterfaceButtons(menu, player, page);
                player.openInventory(menu);
            });
        });
    }

    private void addInterfaceButtons(Inventory menu, Player player, int page) {
        menu.setItem(47, this.createCategoriesButton());
        menu.setItem(49, this.createStorageButton(player));
        menu.setItem(51, this.createAuctionSwitchButton());
        if (this.auctionManager.getCurrentFilter() != null) {
            menu.setItem(53, this.createBackButton());
        }
        if (page > 0) {
            menu.setItem(52, this.createNavigationButton("prev"));
        }
        if (page < this.auctionManager.getTotalPages() - 1) {
            menu.setItem(54, this.createNavigationButton("next"));
        }
    }

    private ItemStack createStorageButton(Player player) {
        ItemStack button = new ItemStack(Material.CHEST);
        ItemMeta meta = button.getItemMeta();
        meta.setDisplayName(this.plugin.getMessageManager().getGuiMessage("storage-button"));
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(this.plugin.getMessageManager().getGuiMessage("storage-lore"));
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("count", String.valueOf(this.playerDataManager.getPlayerStorage(player.getUniqueId()).size()));
        lore.add(this.plugin.getMessageManager().getGuiMessage("storage-items-count", placeholders));
        meta.setLore(lore);
        button.setItemMeta(meta);
        return button;
    }

    private ItemStack createCategoriesButton() {
        Map<String, String> categories;
        String categoryName;
        ItemStack button = new ItemStack(Material.HOPPER);
        ItemMeta meta = button.getItemMeta();
        String currentFilter = this.auctionManager.getCurrentFilter();
        if (currentFilter != null) {
            button = this.getCategoryIcon(currentFilter);
            meta = button.getItemMeta();
            meta.setDisplayName("\u00a76\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438");
            meta.addEnchant(Enchantment.DURABILITY, 1, true);
        } else {
            meta.setDisplayName(this.plugin.getMessageManager().getGuiMessage("categories-button"));
        }
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(this.plugin.getMessageManager().getGuiMessage("categories-lore"));
        if (currentFilter != null && (categoryName = (categories = this.auctionManager.getAvailableCategories()).get(currentFilter)) != null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("category", categoryName);
            lore.add(this.plugin.getMessageManager().getGuiMessage("categories-selected", placeholders));
            lore.add(this.plugin.getMessageManager().getGuiMessage("categories-selected-mark"));
        }
        meta.setLore(lore);
        button.setItemMeta(meta);
        return button;
    }

    private ItemStack createNavigationButton(String type) {
        ItemStack button = new ItemStack(Material.ARROW);
        ItemMeta meta = button.getItemMeta();
        meta.setDisplayName(type.equals("prev") ? this.plugin.getMessageManager().getGuiMessage("prev-page") : this.plugin.getMessageManager().getGuiMessage("next-page"));
        button.setItemMeta(meta);
        return button;
    }

    private ItemStack createAuctionSwitchButton() {
        String currentType = this.plugin.getCurrentAuctionType();
        ItemStack button = "donor".equals(currentType) ? new ItemStack(Material.GOLD_INGOT) : new ItemStack(Material.EMERALD);
        ItemMeta meta = button.getItemMeta();
        meta.setDisplayName(this.plugin.getMessageManager().getGuiMessage("auction-switch-button"));
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(this.plugin.getMessageManager().getGuiMessage("auction-switch-lore"));
        lore.add("");
        if ("donor".equals(currentType)) {
            lore.add(this.plugin.getMessageManager().getGuiMessage("donor-auction"));
        } else {
            lore.add(this.plugin.getMessageManager().getGuiMessage("normal-auction"));
        }
        meta.setLore(lore);
        button.setItemMeta(meta);
        return button;
    }

    private ItemStack updateProfileLore(ItemStack head, Player player) {
        PlayerStats stats = this.playerDataManager.getPlayerStats(player.getUniqueId());
        ItemMeta meta = head.getItemMeta();
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("count", String.valueOf(stats.getAuctionsCreated()));
        placeholders.put("amount", String.format("%.2f", stats.getProfit()));
        placeholders.put("active", String.valueOf(this.auctionManager.getActiveAuctions().stream().filter(a -> a.getSellerId().equals(player.getUniqueId())).count()));
        List<String> lore = Arrays.asList(this.plugin.getMessageManager().getProfileMessage("auctions-created", placeholders), this.plugin.getMessageManager().getProfileMessage("profit", placeholders), this.plugin.getMessageManager().getProfileMessage("active-lots", placeholders));
        meta.setLore(lore);
        head.setItemMeta(meta);
        return head;
    }

    public void handleAuctionMenuClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        int slot = event.getSlot();
        if (slot >= 45 && slot <= 53) {
            event.setCancelled(true);
            this.handleInterfaceClick(player, slot, this.extractCurrentPage(event.getView().getTitle()));
            return;
        }
        if (slot >= 0 && slot < 45) {
            this.handleAuctionClick(player, slot, event.getCurrentItem(), event.isLeftClick(), event.isRightClick());
        }
    }

    private void handleInterfaceClick(Player player, int slot, int currentPage) {
        if (slot == 47) {
            this.openCategoriesMenu(player);
        } else if (slot == 49) {
            this.openStorageMenu(player);
        } else if (slot == 51) {
            String currentType = this.plugin.getCurrentAuctionType();
            if ("donor".equals(currentType)) {
                this.plugin.setCurrentAuctionType("normal");
            } else {
                this.plugin.setCurrentAuctionType("donor");
            }
            this.openAuctionMenu(player, currentPage);
        } else if (slot == 52) {
            if (currentPage > 0) {
                this.openAuctionMenu(player, currentPage - 1);
            }
        } else if (slot == 53) {
            this.auctionManager.setFilter(null);
            this.openAuctionMenu(player, currentPage);
        } else if (slot == 54 && currentPage < this.auctionManager.getTotalPages() - 1) {
            this.openAuctionMenu(player, currentPage + 1);
        }
    }

    public void openCategoriesMenu(Player player) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            Inventory categoriesMenu = Bukkit.createInventory(null, (int)54, (String)"\u00a76\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e");
            this.addCategoryButtonsToMenu(categoriesMenu);
            categoriesMenu.setItem(53, this.createBackButton());
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.openInventory(categoriesMenu));
        });
    }

    private void addCategoryButtonsToMenu(Inventory menu) {
        Map<String, String> categories = this.auctionManager.getAvailableCategories();
        String currentFilter = this.auctionManager.getCurrentFilter();
        int categoryIndex = 0;
        for (Map.Entry<String, String> entry : categories.entrySet()) {
            if (categoryIndex >= 7) break;
            String categoryKey = entry.getKey();
            String categoryName = entry.getValue();
            ItemStack button = this.createCategoryButton(categoryKey, categoryName, categoryKey.equals(currentFilter));
            menu.setItem(45 + categoryIndex, button);
            ++categoryIndex;
        }
    }

    private ItemStack createCategoryButton(String categoryKey, String categoryName, boolean isSelected) {
        ItemStack button = this.getCategoryIcon(categoryKey);
        ItemMeta meta = button.getItemMeta();
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("name", categoryName);
        if (isSelected) {
            meta.setDisplayName(this.plugin.getMessageManager().getCategoriesMessage("selected", placeholders));
            meta.addEnchant(Enchantment.DURABILITY, 1, true);
        } else {
            meta.setDisplayName(this.plugin.getMessageManager().getCategoriesMessage("not-selected", placeholders));
        }
        ArrayList<String> lore = new ArrayList<String>();
        if (isSelected) {
            lore.add(this.plugin.getMessageManager().getCategoriesMessage("deselect"));
            lore.add(this.plugin.getMessageManager().getGuiMessage("categories-selected-mark"));
        } else {
            lore.add(this.plugin.getMessageManager().getCategoriesMessage("select"));
        }
        meta.setLore(lore);
        button.setItemMeta(meta);
        return button;
    }

    private ItemStack getCategoryIcon(String categoryKey) {
        switch (categoryKey) {
            case "gems": {
                return new ItemStack(Material.DIAMOND);
            }
            case "tools": {
                return new ItemStack(Material.DIAMOND_PICKAXE);
            }
            case "weapons": {
                return new ItemStack(Material.DIAMOND_SWORD);
            }
            case "armor": {
                return new ItemStack(Material.DIAMOND_CHESTPLATE);
            }
            case "blocks": {
                return new ItemStack(Material.STONE);
            }
            case "food": {
                return new ItemStack(Material.BREAD);
            }
        }
        return new ItemStack(Material.PAPER);
    }

    public void handleCategoriesClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        int slot = event.getSlot();
        if (slot == 53) {
            event.setCancelled(true);
            this.openAuctionMenu(player, 0);
            return;
        }
        if (slot >= 45 && slot <= 51) {
            event.setCancelled(true);
            this.handleCategoryClick(player, slot - 45);
        }
    }

    private void handleCategoryClick(Player player, int categoryIndex) {
        Map<String, String> categories = this.auctionManager.getAvailableCategories();
        String currentFilter = this.auctionManager.getCurrentFilter();
        int index = 0;
        for (Map.Entry<String, String> entry : categories.entrySet()) {
            if (index == categoryIndex) {
                String categoryKey = entry.getKey();
                if (categoryKey.equals(currentFilter)) {
                    this.auctionManager.setFilter(null);
                } else {
                    this.auctionManager.setFilter(categoryKey);
                }
                this.openCategoriesMenu(player);
                return;
            }
            ++index;
        }
    }

    private int extractCurrentPage(String title) {
        try {
            if (title.contains("(\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430")) {
                String pageStr = title.split("\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430 ")[1].split("/")[0];
                return Integer.parseInt(pageStr) - 1;
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b: " + e.getMessage());
        }
        return 0;
    }

    public void openStorageMenu(Player player) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            Inventory storage = Bukkit.createInventory(null, (int)54, (String)this.getStorageTitle());
            List<ItemStack> items = this.playerDataManager.getPlayerStorage(player.getUniqueId());
            int i = 0;
            while (i < Math.min(items.size(), 45)) {
                ItemStack displayItem = this.createStorageItem(items.get(i));
                int finalI = i++;
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> storage.setItem(finalI, displayItem));
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                storage.setItem(53, this.createBackButton());
                player.openInventory(storage);
            });
        });
    }

    private ItemStack createStorageItem(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return new ItemStack(Material.BARRIER);
        }
        ItemStack displayItem = item.clone();
        ItemMeta meta = displayItem.getItemMeta();
        List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
        lore.add(0, this.plugin.getMessageManager().getStorageItemMessage("stored"));
        lore.add(1, "");
        lore.add(2, this.plugin.getMessageManager().getStorageItemMessage("re-auction"));
        lore.add(3, this.plugin.getMessageManager().getStorageItemMessage("take"));
        meta.setLore(lore);
        displayItem.setItemMeta(meta);
        return displayItem;
    }

    private ItemStack createBackButton() {
        ItemStack button = new ItemStack(Material.ARROW);
        ItemMeta meta = button.getItemMeta();
        meta.setDisplayName(this.plugin.getMessageManager().getGuiMessage("back-button"));
        button.setItemMeta(meta);
        return button;
    }

    public void handleStorageClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        int slot = event.getSlot();
        if (slot == 53) {
            event.setCancelled(true);
            this.openAuctionMenu(player, 0);
            return;
        }
        if (slot >= 0 && slot < 45) {
            this.handleStorageItemClick(player, slot, event.isLeftClick(), event.isRightClick());
            event.setCancelled(true);
        }
    }

    private void handleStorageItemClick(Player player, int slot, boolean leftClick, boolean rightClick) {
        List<ItemStack> storage = this.playerDataManager.getPlayerStorage(player.getUniqueId());
        if (slot >= storage.size()) {
            return;
        }
        ItemStack item = storage.get(slot);
        if (item == null) {
            return;
        }
        if (leftClick) {
            double price = this.extractPriceFromItem(item);
            String auctionType = this.extractAuctionTypeFromItem(item);
            this.playerDataManager.removeFromStorage(player.getUniqueId(), slot);
            this.auctionManager.startAuction(player, item, price, auctionType);
            this.openStorageMenu(player);
        } else if (rightClick) {
            if (player.getInventory().addItem(new ItemStack[]{item}).isEmpty()) {
                this.playerDataManager.removeFromStorage(player.getUniqueId(), slot);
                this.openStorageMenu(player);
            } else {
                player.sendMessage(this.plugin.getMessageManager().getStorageMessage("inventory-full"));
            }
        }
    }

    private double extractPriceFromItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return 0.0;
        }
        List lore = item.getItemMeta().getLore();
        if (lore == null) {
            return 0.0;
        }
        for (String line : lore) {
            if (!line.contains("AuctionPrice:")) continue;
            try {
                return Double.parseDouble(line.replace("\u00a77AuctionPrice:", "").replaceAll("[^0-9.]", ""));
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    private String extractAuctionTypeFromItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return "normal";
        }
        List lore = item.getItemMeta().getLore();
        if (lore == null) {
            return "normal";
        }
        for (String line : lore) {
            if (!line.contains("AuctionType:")) continue;
            return line.replace("\u00a77AuctionType:", "").trim();
        }
        return "normal";
    }

    public void handleProfileClick(InventoryClickEvent event) {
        if (event.getSlot() == 26) {
            event.setCancelled(true);
            this.openAuctionMenu((Player)event.getWhoClicked(), 0);
        }
    }

    private void handleAuctionClick(Player player, int slot, ItemStack clickedItem, boolean leftClick, boolean rightClick) {
        if (clickedItem == null) {
            return;
        }
        List<Auction> auctions = this.auctionManager.getFilteredAuctions(this.extractCurrentPage(player.getOpenInventory().getTitle()));
        if (slot >= auctions.size()) {
            return;
        }
        Auction auction = auctions.get(slot);
        if (leftClick) {
            auction.buyItem(player);
        } else if (rightClick && auction.getSellerId().equals(player.getUniqueId())) {
            ItemStack item = auction.getItemStack().clone();
            item.setAmount(auction.getAmount());
            this.plugin.getPlayerDataManager().addToStorage(player.getUniqueId(), item, auction.getPrice(), null, auction.getAuctionType());
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("item", auction.getItemStack().getType().toString());
            placeholders.put("amount", String.valueOf(auction.getAmount()));
            player.sendMessage(this.plugin.getMessageManager().getAuctionMessage("cancelled-to-storage", placeholders));
            this.auctionManager.removeAuction(player.getUniqueId(), auction.getId());
        }
        this.openAuctionMenu(player, this.extractCurrentPage(player.getOpenInventory().getTitle()));
    }
}

