/*
 * Decompiled with CFR 0.152.
 */
package me.demstudios.managers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import me.demstudios.Auction;
import me.demstudios.BLAuction;
import me.demstudios.database.AuctionDatabase;
import me.demstudios.managers.PlayerDataManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class AuctionManager {
    private final BLAuction plugin;
    private final AuctionDatabase database;
    private final ConcurrentHashMap<UUID, PlayerAuctions> activeAuctions = new ConcurrentHashMap();
    private final PlayerDataManager playerDataManager;
    private final Map<String, Set<Material>> categories = new HashMap<String, Set<Material>>();
    private String currentFilter = null;

    public AuctionManager(BLAuction plugin) {
        this.plugin = plugin;
        this.database = plugin.getDatabase();
        this.playerDataManager = plugin.getPlayerDataManager();
        this.loadCategories();
        this.loadActiveAuctions();
        this.startAuctionTimer();
    }

    private void loadCategories() {
        if (this.plugin.getConfig().contains("categories")) {
            for (String categoryKey : this.plugin.getConfig().getConfigurationSection("categories").getKeys(false)) {
                HashSet<Material> materials = new HashSet<Material>();
                List itemNames = this.plugin.getConfig().getStringList("categories." + categoryKey + ".items");
                for (String itemName : itemNames) {
                    try {
                        materials.add(Material.valueOf((String)itemName.toUpperCase()));
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.getLogger().warning("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b \u0432 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 " + categoryKey + ": " + itemName);
                    }
                }
                this.categories.put(categoryKey, materials);
            }
        }
    }

    public void setFilter(String filter) {
        this.currentFilter = filter;
    }

    public String getCurrentFilter() {
        return this.currentFilter;
    }

    public Map<String, String> getAvailableCategories() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (this.plugin.getConfig().contains("categories")) {
            for (String categoryKey : this.plugin.getConfig().getConfigurationSection("categories").getKeys(false)) {
                String displayName = this.plugin.getConfig().getString("categories." + categoryKey + ".name", categoryKey);
                result.put(categoryKey, ChatColor.translateAlternateColorCodes((char)'&', (String)displayName));
            }
        }
        return result;
    }

    private void loadActiveAuctions() {
        List<Auction> auctions;
        if (this.database != null && (auctions = this.database.loadActiveAuctions()) != null) {
            auctions.forEach(this::addAuction);
        }
    }

    public void addAuction(Auction auction) {
        this.activeAuctions.computeIfAbsent(auction.getSellerId(), k -> new PlayerAuctions()).addAuction(auction);
    }

    public List<Auction> getActiveAuctions() {
        return this.activeAuctions.values().stream().flatMap(pa -> pa.getAllAuctions().stream()).collect(Collectors.toList());
    }

    public List<Auction> getFilteredAuctions(int page) {
        List<Auction> filtered = this.getActiveAuctions();
        String currentAuctionType = this.plugin.getCurrentAuctionType();
        filtered = filtered.stream().filter(auction -> currentAuctionType.equals(auction.getAuctionType())).collect(Collectors.toList());
        if (this.currentFilter != null && this.categories.containsKey(this.currentFilter)) {
            Set<Material> categoryMaterials = this.categories.get(this.currentFilter);
            filtered = filtered.stream().filter(auction -> categoryMaterials.contains(auction.getItemStack().getType())).collect(Collectors.toList());
        }
        int itemsPerPage = this.plugin.getConfig().getInt("settings.items-per-page", 45);
        int start = page * itemsPerPage;
        int end = Math.min(start + itemsPerPage, filtered.size());
        return filtered.subList(start, end);
    }

    public int getTotalPages() {
        List<Auction> filtered = this.getActiveAuctions();
        if (this.currentFilter != null && this.categories.containsKey(this.currentFilter)) {
            Set<Material> categoryMaterials = this.categories.get(this.currentFilter);
            filtered = filtered.stream().filter(auction -> categoryMaterials.contains(auction.getItemStack().getType())).collect(Collectors.toList());
        }
        int itemsPerPage = this.plugin.getConfig().getInt("settings.items-per-page", 45);
        return (int)Math.ceil((double)filtered.size() / (double)itemsPerPage);
    }

    public void startAuction(Player seller, ItemStack item, double price) {
        this.startAuction(seller, item, price, "normal");
    }

    public void startAuction(Player seller, ItemStack item, double price, String auctionType) {
        if (this.playerDataManager.isOnCooldown(seller.getUniqueId())) {
            seller.sendMessage(this.plugin.getMessageManager().getAuctionMessage("cooldown"));
            return;
        }
        Auction auction = new Auction(UUID.randomUUID(), seller, item, price, item.getAmount(), this.plugin.getEconomy(), this.plugin, auctionType);
        this.addAuction(auction);
        this.playerDataManager.getPlayerStats(seller.getUniqueId()).addAuctionCreated(price);
        this.playerDataManager.setCooldown(seller.getUniqueId(), this.plugin.getConfig().getInt("settings.cooldown-seconds", 5));
        if (this.database != null) {
            this.database.saveAuction(auction);
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("item", item.getType().toString());
        placeholders.put("amount", String.valueOf(item.getAmount()));
        placeholders.put("price", String.format("%.2f", price));
        seller.sendMessage(this.plugin.getMessageManager().getAuctionMessage("created", placeholders));
    }

    public void removeAuction(UUID sellerId, UUID auctionId) {
        PlayerAuctions pa = this.activeAuctions.get(sellerId);
        if (pa != null) {
            pa.removeAuction(auctionId);
            if (pa.getAllAuctions().isEmpty()) {
                this.activeAuctions.remove(sellerId);
            }
        }
        if (this.database != null) {
            this.database.removeAuction(auctionId);
        }
    }

    public void saveAllData() {
        if (this.database != null) {
            this.database.saveActiveAuctions(this.getActiveAuctions());
        }
        this.playerDataManager.saveAllStats();
    }

    private void startAuctionTimer() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            ArrayList<Auction> expiredAuctions = new ArrayList<Auction>();
            for (Auction auction : this.getActiveAuctions()) {
                auction.setTimeRemaining(auction.getTimeRemaining() - 1);
                if (auction.getTimeRemaining() > 0) continue;
                expiredAuctions.add(auction);
            }
            for (Auction auction : expiredAuctions) {
                this.handleExpiredAuction(auction);
            }
        }, 20L, 20L);
    }

    private void handleExpiredAuction(Auction auction) {
        ItemStack item = auction.getItemStack().clone();
        item.setAmount(auction.getAmount());
        this.playerDataManager.addToStorage(auction.getSellerId(), item, auction.getPrice(), null, auction.getAuctionType());
        this.removeAuction(auction.getSellerId(), auction.getId());
        Player seller = Bukkit.getPlayer((UUID)auction.getSellerId());
        if (seller != null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("item", auction.getItemStack().getType().toString());
            placeholders.put("amount", String.valueOf(auction.getAmount()));
            seller.sendMessage(this.plugin.getMessageManager().getAuctionMessage("expired", placeholders));
        }
    }

    private static class PlayerAuctions {
        private final Map<UUID, Auction> auctions = new HashMap<UUID, Auction>();

        private PlayerAuctions() {
        }

        public void addAuction(Auction auction) {
            this.auctions.put(auction.getId(), auction);
        }

        public void removeAuction(UUID auctionId) {
            this.auctions.remove(auctionId);
        }

        public List<Auction> getAllAuctions() {
            return new ArrayList<Auction>(this.auctions.values());
        }
    }
}

