/*
 * Decompiled with CFR 0.152.
 */
package me.demstudios.managers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import me.demstudios.BLAuction;
import org.bukkit.ChatColor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageManager {
    private final BLAuction plugin;
    private FileConfiguration messagesConfig;
    private File messagesFile;
    private final Map<String, String> messageCache = new HashMap<String, String>();

    public MessageManager(BLAuction plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    public void loadMessages() {
        if (this.messagesFile == null) {
            this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        }
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        InputStream defConfigStream = this.plugin.getResource("messages.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream, StandardCharsets.UTF_8));
            this.messagesConfig.setDefaults((Configuration)defConfig);
        }
        this.messageCache.clear();
    }

    public String getMessage(String path) {
        return this.getMessage(path, new HashMap<String, String>());
    }

    public String getMessage(String path, Map<String, String> placeholders) {
        String cacheKey = path + "_" + placeholders.hashCode();
        if (this.messageCache.containsKey(cacheKey)) {
            return this.messageCache.get(cacheKey);
        }
        String message = this.messagesConfig.getString(path, "&cMessage not found: " + path);
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            message = message.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        this.messageCache.put(cacheKey, message);
        return message;
    }

    public String getMessage(String path, String ... placeholders) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < placeholders.length; i += 2) {
            if (i + 1 >= placeholders.length) continue;
            map.put(placeholders[i], placeholders[i + 1]);
        }
        return this.getMessage(path, map);
    }

    public String getAuctionMessage(String key) {
        return this.getMessage("auction." + key);
    }

    public String getAuctionMessage(String key, Map<String, String> placeholders) {
        return this.getMessage("auction." + key, placeholders);
    }

    public String getStorageMessage(String key) {
        return this.getMessage("storage." + key);
    }

    public String getStorageMessage(String key, Map<String, String> placeholders) {
        return this.getMessage("storage." + key, placeholders);
    }

    public String getGuiMessage(String key) {
        return this.getMessage("gui." + key);
    }

    public String getGuiMessage(String key, Map<String, String> placeholders) {
        return this.getMessage("gui." + key, placeholders);
    }

    public String getCategoriesMessage(String key) {
        return this.getMessage("categories." + key);
    }

    public String getCategoriesMessage(String key, Map<String, String> placeholders) {
        return this.getMessage("categories." + key, placeholders);
    }

    public String getAuctionItemMessage(String key) {
        return this.getMessage("auction-item." + key);
    }

    public String getAuctionItemMessage(String key, Map<String, String> placeholders) {
        return this.getMessage("auction-item." + key, placeholders);
    }

    public String getStorageItemMessage(String key) {
        return this.getMessage("storage-item." + key);
    }

    public String getStorageItemMessage(String key, Map<String, String> placeholders) {
        return this.getMessage("storage-item." + key, placeholders);
    }

    public String getCommandsMessage(String key) {
        return this.getMessage("commands." + key);
    }

    public String getCommandsMessage(String key, Map<String, String> placeholders) {
        return this.getMessage("commands." + key, placeholders);
    }

    public String getErrorsMessage(String key) {
        return this.getMessage("errors." + key);
    }

    public String getErrorsMessage(String key, Map<String, String> placeholders) {
        return this.getMessage("errors." + key, placeholders);
    }

    public String getNotificationsMessage(String key) {
        return this.getMessage("notifications." + key);
    }

    public String getNotificationsMessage(String key, Map<String, String> placeholders) {
        return this.getMessage("notifications." + key, placeholders);
    }

    public String getStatsMessage(String key) {
        return this.getMessage("stats." + key);
    }

    public String getStatsMessage(String key, Map<String, String> placeholders) {
        return this.getMessage("stats." + key, placeholders);
    }

    public String getProfileMessage(String key) {
        return this.getMessage("profile." + key);
    }

    public String getProfileMessage(String key, Map<String, String> placeholders) {
        return this.getMessage("profile." + key, placeholders);
    }

    public String getCategoryMessage(String key) {
        return this.getMessage("category." + key);
    }

    public String getCategoryMessage(String key, Map<String, String> placeholders) {
        return this.getMessage("category." + key, placeholders);
    }

    public String getTimeMessage(String key) {
        return this.getMessage("time." + key);
    }

    public String getTimeMessage(String key, Map<String, String> placeholders) {
        return this.getMessage("time." + key, placeholders);
    }

    public String getPriceMessage(String key) {
        return this.getMessage("price." + key);
    }

    public String getPriceMessage(String key, Map<String, String> placeholders) {
        return this.getMessage("price." + key, placeholders);
    }

    public String getAmountMessage(String key) {
        return this.getMessage("amount." + key);
    }

    public String getAmountMessage(String key, Map<String, String> placeholders) {
        return this.getMessage("amount." + key, placeholders);
    }

    public String getItemMessage(String key) {
        return this.getMessage("item." + key);
    }

    public String getItemMessage(String key, Map<String, String> placeholders) {
        return this.getMessage("item." + key, placeholders);
    }

    public String getSuccessMessage(String key) {
        return this.getMessage("success." + key);
    }

    public String getSuccessMessage(String key, Map<String, String> placeholders) {
        return this.getMessage("success." + key, placeholders);
    }

    public String getWarningMessage(String key) {
        return this.getMessage("warning." + key);
    }

    public String getWarningMessage(String key, Map<String, String> placeholders) {
        return this.getMessage("warning." + key, placeholders);
    }

    public String getErrorMessage(String key) {
        return this.getMessage("error." + key);
    }

    public String getErrorMessage(String key, Map<String, String> placeholders) {
        return this.getMessage("error." + key, placeholders);
    }

    public String getGeneralMessage(String key) {
        return this.getMessage("general." + key);
    }

    public String getGeneralMessage(String key, Map<String, String> placeholders) {
        return this.getMessage("general." + key, placeholders);
    }

    public String getTraderMessage(String key) {
        return this.getMessage("trader." + key);
    }

    public String getTraderMessage(String key, Map<String, String> placeholders) {
        return this.getMessage("trader." + key, placeholders);
    }

    public String getItemCustomName(String materialName) {
        return this.messagesConfig.getString("item-custom-names." + materialName);
    }

    public void reloadMessages() {
        this.loadMessages();
    }

    public void saveMessages() {
        try {
            this.messagesConfig.save(this.messagesFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0444\u0430\u0439\u043b \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439: " + e.getMessage());
        }
    }
}

