/*
 * Decompiled with CFR 0.152.
 */
package me.demstudios.managers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.demstudios.BLAuction;
import me.demstudios.stats.PlayerStats;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PlayerDataManager {
    private final BLAuction plugin;
    private final Map<UUID, PlayerStats> playerStats = new ConcurrentHashMap<UUID, PlayerStats>();
    private final Map<UUID, List<ItemStack>> playerStorage = new ConcurrentHashMap<UUID, List<ItemStack>>();

    public PlayerDataManager(BLAuction plugin) {
        this.plugin = plugin;
    }

    public void onPlayerJoin(Player player) {
        UUID playerId = player.getUniqueId();
        PlayerStats stats = this.getPlayerStats(playerId);
        if (!stats.getPlayerName().equals(player.getName())) {
            stats.setPlayerName(player.getName());
            this.savePlayerStats(stats);
        }
        this.loadPlayerStorage(playerId);
    }

    public PlayerStats getPlayerStats(UUID playerId) {
        return this.playerStats.computeIfAbsent(playerId, k -> {
            PlayerStats stats = null;
            if (this.plugin.getDatabase() != null) {
                stats = this.plugin.getDatabase().loadPlayerStats(playerId);
            }
            if (stats == null) {
                Player player = Bukkit.getPlayer((UUID)playerId);
                stats = new PlayerStats(playerId, player != null ? player.getName() : "Unknown");
                if (this.plugin.getDatabase() != null) {
                    this.plugin.getDatabase().savePlayerStats(stats);
                }
            }
            return stats;
        });
    }

    public void savePlayerStats(PlayerStats stats) {
        if (stats != null) {
            this.playerStats.put(stats.getPlayerId(), stats);
            if (this.plugin.getDatabase() != null) {
                this.plugin.getDatabase().savePlayerStats(stats);
            }
        }
    }

    public List<ItemStack> getPlayerStorage(UUID playerId) {
        return this.playerStorage.computeIfAbsent(playerId, k -> new ArrayList());
    }

    public void loadPlayerStorage(UUID playerId) {
        List<Object> items = new ArrayList();
        if (this.plugin.getDatabase() != null) {
            items = this.plugin.getDatabase().loadPlayerStorage(playerId);
        }
        this.playerStorage.put(playerId, items);
    }

    public boolean isOnCooldown(UUID playerId) {
        if (this.plugin.getDatabase() != null) {
            return this.plugin.getDatabase().isOnCooldown(playerId);
        }
        return false;
    }

    public void setCooldown(UUID playerId, int seconds) {
        if (this.plugin.getDatabase() != null) {
            this.plugin.getDatabase().setCooldown(playerId, seconds);
        }
    }

    public void savePlayerStorage(UUID playerId, List<ItemStack> storage) {
        if (this.plugin.getDatabase() != null) {
            this.plugin.getDatabase().savePlayerStorage(playerId, storage);
        }
    }

    public void addToStorage(UUID playerId, ItemStack item, double price, String category) {
        this.addToStorage(playerId, item, price, category, "normal");
    }

    public void addToStorage(UUID playerId, ItemStack item, double price, String category, String auctionType) {
        ItemStack itemWithPrice = item.clone();
        ItemMeta meta = itemWithPrice.getItemMeta();
        if (meta != null) {
            List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
            lore.add("\u00a77AuctionPrice:" + price);
            lore.add("\u00a77AuctionType:" + auctionType);
            meta.setLore(lore);
            itemWithPrice.setItemMeta(meta);
        }
        List<ItemStack> storage = this.getPlayerStorage(playerId);
        for (ItemStack storedItem : storage) {
            if (!storedItem.isSimilar(item)) continue;
            storedItem.setAmount(storedItem.getAmount() + item.getAmount());
            this.savePlayerStorage(playerId, storage);
            return;
        }
        storage.add(itemWithPrice);
        this.savePlayerStorage(playerId, storage);
    }

    public void removeFromStorage(UUID playerId, int index) {
        List<ItemStack> storage = this.getPlayerStorage(playerId);
        if (index >= 0 && index < storage.size()) {
            storage.remove(index);
            this.plugin.getDatabase().savePlayerStorage(playerId, storage);
        }
    }

    public void saveAllStats() {
        this.playerStats.values().forEach(this::savePlayerStats);
    }
}

