/*
 * Decompiled with CFR 0.152.
 */
package me.demstudios.managers;

import java.util.HashMap;
import java.util.Map;
import me.demstudios.BLAuction;
import me.demstudios.managers.TraderManager;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;

public class TraderGUI
implements Listener {
    private final BLAuction plugin;
    private final TraderManager traderManager;
    private final Map<Player, Integer> sellModes = new HashMap<Player, Integer>();

    public TraderGUI(BLAuction plugin) {
        this.plugin = plugin;
        this.traderManager = plugin.getTraderManager();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        if (!(title.contains("\u0421\u043a\u0443\u043f\u0449\u0438\u043a") || title.contains("Trader") || title.contains("\u0414\u043e\u0440\u043e\u0433\u043e\u0439"))) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        if (clickedItem.getType() == Material.BOOK || clickedItem.getType() == Material.BLACK_STAINED_GLASS_PANE || clickedItem.getType() == Material.YELLOW_STAINED_GLASS_PANE || clickedItem.getType() == Material.LIGHT_BLUE_STAINED_GLASS_PANE || clickedItem.getType() == Material.ARROW || clickedItem.getType() == Material.DIAMOND) {
            return;
        }
        if (event.isShiftClick() && event.isRightClick()) {
            this.handleSellModeChange(player);
        } else if (event.isLeftClick()) {
            this.handleItemSell(player, clickedItem);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getPlayer() instanceof Player) {
            this.sellModes.remove((Player)event.getPlayer());
        }
    }

    private void handleSellModeChange(Player player) {
        int currentMode = this.sellModes.getOrDefault(player, 1);
        int[] modes = new int[]{1, 10, 32, 64};
        int nextModeIndex = 0;
        for (int i = 0; i < modes.length; ++i) {
            if (modes[i] != currentMode) continue;
            nextModeIndex = (i + 1) % modes.length;
            break;
        }
        int newMode = modes[nextModeIndex];
        this.sellModes.put(player, newMode);
        player.sendMessage(this.plugin.getMessageManager().getTraderMessage("sell-mode-changed").replace("{mode}", String.valueOf(newMode)));
    }

    private void handleItemSell(Player player, ItemStack traderItem) {
        Material targetMaterial = traderItem.getType();
        int sellAmount = this.sellModes.getOrDefault(player, 1);
        ItemStack[] inventory = player.getInventory().getContents();
        int totalFound = 0;
        for (ItemStack item : inventory) {
            if (item == null || item.getType() != targetMaterial) continue;
            totalFound += item.getAmount();
        }
        if (totalFound == 0) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("item", this.getItemDisplayName(targetMaterial));
            player.sendMessage(this.plugin.getMessageManager().getTraderMessage("no-items-in-inventory", placeholders));
            return;
        }
        int actualSellAmount = Math.min(sellAmount, totalFound);
        ItemStack sellItem = new ItemStack(targetMaterial, actualSellAmount);
        this.traderManager.handleItemSell(player, sellItem);
        this.traderManager.updateTraderGUI(player);
    }

    private String getItemDisplayName(Material material) {
        String customName = this.plugin.getConfig().getString("trader.items." + material.name() + ".display-name");
        if (customName != null) {
            return customName.replace("&", "\u00a7");
        }
        return material.name().toLowerCase().replace("_", " ");
    }
}

