/*
 * Decompiled with CFR 0.152.
 */
package me.demstudios.managers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import me.demstudios.Auction;
import me.demstudios.BLAuction;
import me.demstudios.managers.AuctionManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TraderManager {
    private final BLAuction plugin;
    private final AuctionManager auctionManager;
    private final Map<Material, TraderItem> traderItems = new ConcurrentHashMap<Material, TraderItem>();
    private final Map<Material, Integer> dailySales = new ConcurrentHashMap<Material, Integer>();
    private final Map<Material, Long> lastSaleTime = new ConcurrentHashMap<Material, Long>();
    private final Map<UUID, Long> playerLastSaleTime = new ConcurrentHashMap<UUID, Long>();
    private long lastRotationTime = System.currentTimeMillis();
    private List<TraderItem> currentDisplayItems = new ArrayList<TraderItem>();
    private boolean isPremiumTraderActive = false;
    private List<TraderItem> premiumItems = new ArrayList<TraderItem>();
    private long premiumTraderEndTime = 0L;
    private final double priceReductionFactor;
    private final double recoveryFactor;
    private final double auctionInfluence;
    private final int rotationIntervalHours;
    private final int excessThreshold;
    private final int checkIntervalMinutes;
    private final int premiumTraderDurationMinutes;
    private final int premiumTraderStartDelayHours;
    private final double premiumTraderMinPriceThreshold;

    public TraderManager(BLAuction plugin) {
        this.plugin = plugin;
        this.auctionManager = plugin.getAuctionManager();
        this.priceReductionFactor = plugin.getConfig().getDouble("trader.pricing.price-reduction-factor", 0.02);
        this.recoveryFactor = plugin.getConfig().getDouble("trader.pricing.recovery-factor", 0.01);
        this.auctionInfluence = plugin.getConfig().getDouble("trader.pricing.auction-influence", 0.15);
        this.rotationIntervalHours = plugin.getConfig().getInt("trader.rotation.interval-hours", 24);
        this.excessThreshold = plugin.getConfig().getInt("trader.auction-monitoring.excess-threshold", 5);
        this.checkIntervalMinutes = plugin.getConfig().getInt("trader.auction-monitoring.check-interval-minutes", 30);
        this.premiumTraderDurationMinutes = plugin.getConfig().getInt("trader.premium-trader.duration-minutes", 30);
        this.premiumTraderStartDelayHours = plugin.getConfig().getInt("trader.premium-trader.start-delay-hours", 12);
        this.premiumTraderMinPriceThreshold = plugin.getConfig().getDouble("trader.premium-trader.min-price-threshold", 50.0);
        this.loadTraderItems();
        this.generateFixedDisplayItems();
        this.startRotationTimer();
        this.startAuctionMonitoring();
        this.startPremiumTraderTimer();
    }

    public void openTraderGUI(Player player) {
        String title = this.isPremiumTraderActive ? ChatColor.translateAlternateColorCodes((char)'&', (String)"&5&l\u0414\u043e\u0440\u043e\u0433\u043e\u0439 \u0421\u043a\u0443\u043f\u0449\u0438\u043a") : ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("trader.gui.title", "&6&l\u0421\u043a\u0443\u043f\u0449\u0438\u043a"));
        Inventory gui = Bukkit.createInventory(null, (int)36, (String)title);
        List<TraderItem> displayItems = this.isPremiumTraderActive ? this.premiumItems : this.currentDisplayItems;
        int[] itemSlots = new int[]{10, 11, 12, 13, 14, 19, 20, 21, 22, 23};
        for (int i = 0; i < displayItems.size() && i < itemSlots.length; ++i) {
            ItemStack displayItem = this.createDisplayItem(displayItems.get(i));
            gui.setItem(itemSlots[i], displayItem);
        }
        this.addDecorations(gui);
        this.addInfoBook(gui);
        player.openInventory(gui);
    }

    public void updateTraderGUI(Player player) {
        if (player.getOpenInventory() != null && (player.getOpenInventory().getTitle().contains("\u0421\u043a\u0443\u043f\u0449\u0438\u043a") || player.getOpenInventory().getTitle().contains("Trader") || player.getOpenInventory().getTitle().contains("\u0414\u043e\u0440\u043e\u0433\u043e\u0439"))) {
            Inventory currentGUI = player.getOpenInventory().getTopInventory();
            this.updateGUIItems(currentGUI);
        }
    }

    private void updateGUIItems(Inventory gui) {
        List<TraderItem> displayItems = this.isPremiumTraderActive ? this.premiumItems : this.currentDisplayItems;
        int[] itemSlots = new int[]{10, 11, 12, 13, 14, 19, 20, 21, 22, 23};
        for (int i = 0; i < displayItems.size() && i < itemSlots.length; ++i) {
            ItemStack displayItem = this.createDisplayItem(displayItems.get(i));
            gui.setItem(itemSlots[i], displayItem);
        }
        this.addInfoBook(gui);
    }

    private void generateFixedDisplayItems() {
        ArrayList<TraderItem> availableItems = new ArrayList<TraderItem>(this.traderItems.values());
        Collections.shuffle(availableItems);
        this.currentDisplayItems = availableItems.stream().limit(10L).collect(Collectors.toList());
    }

    private void generatePremiumItems() {
        ArrayList<TraderItem> premiumMaterials = new ArrayList<TraderItem>();
        for (TraderItem item : this.traderItems.values()) {
            if (!(item.getBasePrice() >= this.premiumTraderMinPriceThreshold)) continue;
            premiumMaterials.add(item);
        }
        Collections.shuffle(premiumMaterials);
        this.premiumItems = premiumMaterials.stream().limit(10L).collect(Collectors.toList());
    }

    private ItemStack createDisplayItem(TraderItem traderItem) {
        ItemStack item = new ItemStack(traderItem.getMaterial());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String displayName = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("trader.gui.item-display-name", "&e{name}"));
            displayName = displayName.replace("{name}", this.getItemDisplayName(traderItem.getMaterial()));
            meta.setDisplayName(displayName);
            ArrayList<String> lore = new ArrayList<String>();
            double currentPrice = this.calculateCurrentPrice(traderItem);
            String priceText = this.plugin.getConfig().getString("trader.gui.item-price", "&7\u0426\u0435\u043d\u0430: &a{price}");
            priceText = priceText.replace("{price}", String.format("%.2f", currentPrice));
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)priceText));
            int salesToday = this.dailySales.getOrDefault(traderItem.getMaterial(), 0);
            String salesText = this.plugin.getConfig().getString("trader.gui.sales-today", "&7\u041f\u0440\u043e\u0434\u0430\u043d\u043e \u0441\u0435\u0433\u043e\u0434\u043d\u044f: &e{count}");
            salesText = salesText.replace("{count}", String.valueOf(salesToday));
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)salesText));
            long timeUntilRotation = this.getTimeUntilRotation();
            String rotationText = this.plugin.getConfig().getString("trader.gui.rotation-time", "&7\u0420\u043e\u0442\u0430\u0446\u0438\u044f \u0447\u0435\u0440\u0435\u0437: &e{time}");
            rotationText = rotationText.replace("{time}", this.formatTime(timeUntilRotation));
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)rotationText));
            lore.add("");
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("trader.gui.sell-action", "&e\u041b\u041a\u041c - \u043f\u0440\u043e\u0434\u0430\u0442\u044c \u043f\u0440\u0435\u0434\u043c\u0435\u0442")));
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("trader.gui.sell-mode-action", "&eShift+\u041f\u041a\u041c - \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0440\u0435\u0436\u0438\u043c \u043f\u0440\u043e\u0434\u0430\u0436\u0438")));
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private void addInfoBook(Inventory gui) {
        ItemStack infoBook = new ItemStack(Material.BOOK);
        ItemMeta meta = infoBook.getItemMeta();
        if (meta != null) {
            String title = this.isPremiumTraderActive ? ChatColor.translateAlternateColorCodes((char)'&', (String)"&5&l\u0414\u043e\u0440\u043e\u0433\u043e\u0439 \u0421\u043a\u0443\u043f\u0449\u0438\u043a") : ChatColor.translateAlternateColorCodes((char)'&', (String)"&6&l\u0421\u043a\u0443\u043f\u0449\u0438\u043a");
            meta.setDisplayName(title);
            ArrayList<String> lore = new ArrayList<String>();
            int totalSales = this.dailySales.values().stream().mapToInt(Integer::intValue).sum();
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7\u0412\u0441\u0435\u0433\u043e \u043f\u0440\u043e\u0434\u0430\u043d\u043e \u0441\u0435\u0433\u043e\u0434\u043d\u044f: &e" + totalSales)));
            if (this.isPremiumTraderActive) {
                long timeLeft = this.premiumTraderEndTime - System.currentTimeMillis();
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&5\u0414\u043e\u0440\u043e\u0433\u043e\u0439 \u0441\u043a\u0443\u043f\u0449\u0438\u043a \u0430\u043a\u0442\u0438\u0432\u0435\u043d!"));
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7\u0412\u0440\u0435\u043c\u044f \u0434\u043e \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f: &e" + this.formatTime(timeLeft))));
            } else {
                long timeUntilRotation = this.getTimeUntilRotation();
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7\u0412\u0440\u0435\u043c\u044f \u0434\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f: &e" + this.formatTime(timeUntilRotation))));
            }
            lore.add("");
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7\u0426\u0435\u043d\u044b \u043c\u0435\u043d\u044f\u044e\u0442\u0441\u044f \u0432 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438 \u043e\u0442"));
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7\u043f\u0440\u043e\u0434\u0430\u0436 \u0438 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u0430\u0443\u043a\u0446\u0438\u043e\u043d\u0430."));
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7\u0422\u043e\u0432\u0430\u0440\u044b \u043e\u0431\u043d\u043e\u0432\u043b\u044f\u044e\u0442\u0441\u044f \u043a\u0430\u0436\u0434\u044b\u0435 24 \u0447\u0430\u0441\u0430."));
            lore.add("");
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&e\u041b\u041a\u041c - \u043f\u0440\u043e\u0434\u0430\u0442\u044c \u043f\u0440\u0435\u0434\u043c\u0435\u0442"));
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&eShift+\u041f\u041a\u041c - \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0440\u0435\u0436\u0438\u043c \u043f\u0440\u043e\u0434\u0430\u0436\u0438"));
            meta.setLore(lore);
            infoBook.setItemMeta(meta);
        }
        gui.setItem(4, infoBook);
    }

    private void addDecorations(Inventory gui) {
        int i;
        ItemStack glass = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta glassMeta = glass.getItemMeta();
        glassMeta.setDisplayName(" ");
        glass.setItemMeta(glassMeta);
        ItemStack goldGlass = new ItemStack(Material.YELLOW_STAINED_GLASS_PANE);
        ItemMeta goldMeta = goldGlass.getItemMeta();
        goldMeta.setDisplayName(" ");
        goldGlass.setItemMeta(goldMeta);
        ItemStack decorationGlass = this.isPremiumTraderActive ? goldGlass : glass;
        for (i = 0; i < 9; ++i) {
            gui.setItem(i, decorationGlass.clone());
            gui.setItem(i + 27, decorationGlass.clone());
        }
        for (i = 9; i < 27; i += 9) {
            gui.setItem(i, decorationGlass.clone());
            gui.setItem(i + 8, decorationGlass.clone());
        }
        ItemStack corner = new ItemStack(Material.LIGHT_BLUE_STAINED_GLASS_PANE);
        ItemMeta cornerMeta = corner.getItemMeta();
        cornerMeta.setDisplayName(" ");
        corner.setItemMeta(cornerMeta);
        gui.setItem(9, corner.clone());
        gui.setItem(17, corner.clone());
        gui.setItem(18, corner.clone());
        gui.setItem(26, corner.clone());
        ItemStack arrow = new ItemStack(Material.ARROW);
        ItemMeta arrowMeta = arrow.getItemMeta();
        arrowMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7\u0422\u043e\u0432\u0430\u0440\u044b \u0434\u043b\u044f \u043f\u0440\u043e\u0434\u0430\u0436\u0438"));
        arrow.setItemMeta(arrowMeta);
        gui.setItem(1, arrow.clone());
        gui.setItem(7, arrow.clone());
        ItemStack diamond = new ItemStack(Material.DIAMOND);
        ItemMeta diamondMeta = diamond.getItemMeta();
        diamondMeta.setDisplayName(" ");
        diamond.setItemMeta(diamondMeta);
        gui.setItem(0, diamond.clone());
        gui.setItem(8, diamond.clone());
        gui.setItem(27, diamond.clone());
        gui.setItem(35, diamond.clone());
    }

    public void handleItemSell(Player player, ItemStack item) {
        Material material = item.getType();
        TraderItem traderItem = this.traderItems.get(material);
        if (traderItem == null) {
            player.sendMessage(this.plugin.getMessageManager().getTraderMessage("item-not-accepted"));
            return;
        }
        if (!this.canPlayerSell(player, material, item.getAmount())) {
            player.sendMessage(this.plugin.getMessageManager().getTraderMessage("sell-limit-reached"));
            return;
        }
        double price = this.calculateCurrentPrice(traderItem);
        int amount = item.getAmount();
        double totalPrice = price * (double)amount;
        if (!player.getInventory().containsAtLeast(item, amount)) {
            player.sendMessage(this.plugin.getMessageManager().getTraderMessage("not-enough-items"));
            return;
        }
        player.getInventory().removeItem(new ItemStack[]{item});
        if (this.plugin.getEconomy() != null) {
            this.plugin.getEconomy().depositPlayer((OfflinePlayer)player, totalPrice);
        }
        this.dailySales.put(material, this.dailySales.getOrDefault(material, 0) + amount);
        this.lastSaleTime.put(material, System.currentTimeMillis());
        this.updatePlayerSales(player, material, amount);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("item", this.getItemDisplayName(material));
        placeholders.put("amount", String.valueOf(amount));
        placeholders.put("price", String.format("%.2f", totalPrice));
        player.sendMessage(this.plugin.getMessageManager().getTraderMessage("item-sold", placeholders));
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.updateTraderGUI(player), 5L);
    }

    private double calculateCurrentPrice(TraderItem traderItem) {
        Material material = traderItem.getMaterial();
        double basePrice = traderItem.getBasePrice();
        int salesToday = this.dailySales.getOrDefault(material, 0);
        double salesImpact = Math.log(1 + salesToday) * this.priceReductionFactor * 0.5;
        long lastSale = this.lastSaleTime.getOrDefault(material, System.currentTimeMillis());
        long hoursWithoutSales = (System.currentTimeMillis() - lastSale) / 3600000L;
        double recoveryImpact = Math.min((double)hoursWithoutSales * this.recoveryFactor * 0.3, 0.2);
        int excessOnAuction = this.getExcessOnAuction(material);
        double auctionImpact = Math.log(1 + excessOnAuction) * this.auctionInfluence * 0.3;
        double price = basePrice * (1.0 - salesImpact + recoveryImpact - auctionImpact);
        price = Math.max(price, traderItem.getMinPrice());
        price = Math.min(price, traderItem.getMaxPrice());
        return price;
    }

    private boolean canPlayerSell(Player player, Material material, int amount) {
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        int cooldownSeconds = this.plugin.getConfig().getInt("trader.player-limits.cooldown-seconds", 2);
        long lastSale = this.playerLastSaleTime.getOrDefault(playerId, 0L);
        return currentTime - lastSale >= (long)(cooldownSeconds * 1000);
    }

    private void updatePlayerSales(Player player, Material material, int amount) {
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        this.playerLastSaleTime.put(playerId, currentTime);
    }

    private int getExcessOnAuction(Material material) {
        List<Auction> activeAuctions = this.auctionManager.getActiveAuctions();
        int count = 0;
        for (Auction auction : activeAuctions) {
            if (auction.getItemStack().getType() != material) continue;
            count += auction.getAmount();
        }
        return Math.max(0, count - this.excessThreshold);
    }

    private long getTimeUntilRotation() {
        long rotationInterval = this.rotationIntervalHours * 60 * 60 * 1000;
        long timeSinceLastRotation = System.currentTimeMillis() - this.lastRotationTime;
        return Math.max(0L, rotationInterval - timeSinceLastRotation);
    }

    private String getItemDisplayName(Material material) {
        String customName = this.plugin.getConfig().getString("trader.items." + material.name() + ".display-name");
        if (customName != null) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)customName);
        }
        return material.name().toLowerCase().replace("_", " ");
    }

    private String formatTime(long milliseconds) {
        long seconds = milliseconds / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        if (hours > 0L) {
            return String.format("%d\u0447 %d\u043c", hours, minutes % 60L);
        }
        if (minutes > 0L) {
            return String.format("%d\u043c %d\u0441", minutes, seconds % 60L);
        }
        return String.format("%d\u0441", seconds);
    }

    private void loadTraderItems() {
        if (this.plugin.getConfig().contains("trader.items")) {
            for (String materialName : this.plugin.getConfig().getConfigurationSection("trader.items").getKeys(false)) {
                try {
                    Material material = Material.valueOf((String)materialName.toUpperCase());
                    double basePrice = this.plugin.getConfig().getDouble("trader.items." + materialName + ".base-price", 10.0);
                    double minPrice = this.plugin.getConfig().getDouble("trader.items." + materialName + ".min-price", 1.0);
                    double maxPrice = this.plugin.getConfig().getDouble("trader.items." + materialName + ".max-price", 100.0);
                    this.traderItems.put(material, new TraderItem(material, basePrice, minPrice, maxPrice));
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0441\u043a\u0443\u043f\u0449\u0438\u043a\u0430: " + materialName);
                }
            }
        }
    }

    private void startRotationTimer() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            this.rotateItems();
            this.lastRotationTime = System.currentTimeMillis();
            this.dailySales.clear();
            this.lastSaleTime.clear();
            this.plugin.getLogger().info("\u0422\u043e\u0432\u0430\u0440\u044b \u0441\u043a\u0443\u043f\u0449\u0438\u043a\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u044b");
        }, 72000L * (long)this.rotationIntervalHours, 72000L * (long)this.rotationIntervalHours);
    }

    private void startAuctionMonitoring() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {}, 1200L * (long)this.checkIntervalMinutes, 1200L * (long)this.checkIntervalMinutes);
    }

    private void rotateItems() {
        this.traderItems.clear();
        this.loadTraderItems();
        this.generateFixedDisplayItems();
        this.plugin.getLogger().info("\u0422\u043e\u0432\u0430\u0440\u044b \u0441\u043a\u0443\u043f\u0449\u0438\u043a\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u0434\u043b\u044f \u0432\u0441\u0435\u0445 \u0438\u0433\u0440\u043e\u043a\u043e\u0432");
    }

    private void startPremiumTraderTimer() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            long currentTime = System.currentTimeMillis();
            if (!this.isPremiumTraderActive) {
                if (this.shouldStartPremiumTrader()) {
                    this.startPremiumTrader();
                }
            } else if (currentTime >= this.premiumTraderEndTime) {
                this.endPremiumTrader();
            }
        }, 1200L, 1200L);
    }

    private boolean shouldStartPremiumTrader() {
        long delayMillis;
        long timeSinceLastRotation = System.currentTimeMillis() - this.lastRotationTime;
        return timeSinceLastRotation >= (delayMillis = (long)(this.premiumTraderStartDelayHours * 60 * 60 * 1000)) && timeSinceLastRotation < delayMillis + 60000L;
    }

    private void startPremiumTrader() {
        this.isPremiumTraderActive = true;
        this.premiumTraderEndTime = System.currentTimeMillis() + (long)(this.premiumTraderDurationMinutes * 60 * 1000);
        this.generatePremiumItems();
        String message = ChatColor.translateAlternateColorCodes((char)'&', (String)"&5&l[\u0421\u041a\u0423\u041f\u0429\u0418\u041a] &d\u0414\u043e\u0440\u043e\u0433\u043e\u0439 \u0441\u043a\u0443\u043f\u0449\u0438\u043a \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u043d\u0430 30 \u043c\u0438\u043d\u0443\u0442! &5\u041e\u0442\u043a\u0440\u043e\u0439\u0442\u0435 \u0441\u043a\u0443\u043f\u0449\u0438\u043a\u0430 \u0434\u043b\u044f \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0430 \u044d\u043a\u0441\u043a\u043b\u044e\u0437\u0438\u0432\u043d\u044b\u0445 \u0442\u043e\u0432\u0430\u0440\u043e\u0432!");
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendMessage(message);
        }
        this.plugin.getLogger().info("\u0414\u043e\u0440\u043e\u0433\u043e\u0439 \u0441\u043a\u0443\u043f\u0449\u0438\u043a \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u043d\u0430 30 \u043c\u0438\u043d\u0443\u0442");
    }

    private void endPremiumTrader() {
        this.isPremiumTraderActive = false;
        this.generateFixedDisplayItems();
        String message = ChatColor.translateAlternateColorCodes((char)'&', (String)"&5&l[\u0421\u041a\u0423\u041f\u0429\u0418\u041a] &d\u0414\u043e\u0440\u043e\u0433\u043e\u0439 \u0441\u043a\u0443\u043f\u0449\u0438\u043a \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d. \u0422\u043e\u0432\u0430\u0440\u044b \u0432\u0435\u0440\u043d\u0443\u043b\u0438\u0441\u044c \u043a \u043e\u0431\u044b\u0447\u043d\u044b\u043c.");
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendMessage(message);
        }
        this.plugin.getLogger().info("\u0414\u043e\u0440\u043e\u0433\u043e\u0439 \u0441\u043a\u0443\u043f\u0449\u0438\u043a \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d");
    }

    public boolean isPremiumTraderActive() {
        return this.isPremiumTraderActive;
    }

    public long getPremiumTraderEndTime() {
        return this.premiumTraderEndTime;
    }

    public static class TraderItem {
        private final Material material;
        private final double basePrice;
        private final double minPrice;
        private final double maxPrice;

        public TraderItem(Material material, double basePrice, double minPrice, double maxPrice) {
            this.material = material;
            this.basePrice = basePrice;
            this.minPrice = minPrice;
            this.maxPrice = maxPrice;
        }

        public Material getMaterial() {
            return this.material;
        }

        public double getBasePrice() {
            return this.basePrice;
        }

        public double getMinPrice() {
            return this.minPrice;
        }

        public double getMaxPrice() {
            return this.maxPrice;
        }
    }
}

