/*
 * Decompiled with CFR 0.152.
 */
package me.demstudios.stats;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class PlayerStats {
    private final UUID playerId;
    private String playerName;
    private int auctionsCreated;
    private int auctionsWon;
    private int bidsPlaced;
    private BigDecimal totalRevenue;
    private BigDecimal totalSpent;
    private long firstJoinTime;
    private long lastAuctionTime;

    public PlayerStats(UUID playerId, String playerName) {
        if (playerId == null) {
            throw new IllegalArgumentException("Player ID cannot be null");
        }
        this.playerId = playerId;
        this.playerName = playerName != null ? playerName : "Unknown";
        this.totalRevenue = BigDecimal.ZERO;
        this.totalSpent = BigDecimal.ZERO;
        this.firstJoinTime = System.currentTimeMillis();
    }

    public void addAuctionCreated(double startingPrice) {
        ++this.auctionsCreated;
        this.totalRevenue = this.totalRevenue.add(BigDecimal.valueOf(startingPrice));
        this.lastAuctionTime = System.currentTimeMillis();
        this.updatePlayerName();
    }

    public void addAuctionWon(double finalPrice) {
        ++this.auctionsWon;
        this.totalSpent = this.totalSpent.add(BigDecimal.valueOf(finalPrice));
        this.updatePlayerName();
    }

    public void addBidPlaced(double bidAmount) {
        ++this.bidsPlaced;
        this.totalSpent = this.totalSpent.add(BigDecimal.valueOf(bidAmount));
        this.updatePlayerName();
    }

    public void addRevenue(double amount) {
        if (amount < 0.0) {
            throw new IllegalArgumentException("Revenue cannot be negative");
        }
        this.totalRevenue = this.totalRevenue.add(BigDecimal.valueOf(amount));
    }

    public double getProfit() {
        return this.totalRevenue.subtract(this.totalSpent).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public double getAverageWinPrice() {
        return this.auctionsWon > 0 ? this.totalSpent.divide(BigDecimal.valueOf(this.auctionsWon), 2, RoundingMode.HALF_UP).doubleValue() : 0.0;
    }

    public double getAverageRevenue() {
        return this.auctionsCreated > 0 ? this.totalRevenue.divide(BigDecimal.valueOf(this.auctionsCreated), 2, RoundingMode.HALF_UP).doubleValue() : 0.0;
    }

    public long getDaysSinceFirstJoin() {
        return (System.currentTimeMillis() - this.firstJoinTime) / 86400000L;
    }

    private void updatePlayerName() {
        try {
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)this.playerId);
            if (player.getName() != null && !player.getName().equals(this.playerName)) {
                this.playerName = player.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName != null ? playerName : "Unknown";
    }

    public int getAuctionsCreated() {
        return this.auctionsCreated;
    }

    public void setAuctionsCreated(int auctionsCreated) {
        this.auctionsCreated = Math.max(0, auctionsCreated);
    }

    public int getAuctionsWon() {
        return this.auctionsWon;
    }

    public void setAuctionsWon(int auctionsWon) {
        this.auctionsWon = Math.max(0, auctionsWon);
    }

    public int getBidsPlaced() {
        return this.bidsPlaced;
    }

    public void setBidsPlaced(int bidsPlaced) {
        this.bidsPlaced = Math.max(0, bidsPlaced);
    }

    public double getTotalRevenue() {
        return this.totalRevenue.doubleValue();
    }

    public void setTotalRevenue(double totalRevenue) {
        this.totalRevenue = BigDecimal.valueOf(Math.max(0.0, totalRevenue));
    }

    public double getTotalSpent() {
        return this.totalSpent.doubleValue();
    }

    public void setTotalSpent(double totalSpent) {
        this.totalSpent = BigDecimal.valueOf(Math.max(0.0, totalSpent));
    }

    public long getFirstJoinTime() {
        return this.firstJoinTime;
    }

    public void setFirstJoinTime(long firstJoinTime) {
        this.firstJoinTime = Math.max(0L, firstJoinTime);
    }

    public long getLastAuctionTime() {
        return this.lastAuctionTime;
    }

    public void setLastAuctionTime(long lastAuctionTime) {
        this.lastAuctionTime = Math.max(0L, lastAuctionTime);
    }

    public String getFormattedStats() {
        return String.format("\u00a76\u00a7l\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u0438\u0433\u0440\u043e\u043a\u0430 %s:\n\u00a7e\u0421\u043e\u0437\u0434\u0430\u043d\u043e \u0430\u0443\u043a\u0446\u0438\u043e\u043d\u043e\u0432: \u00a7f%d\n\u00a7e\u0417\u0430\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e: \u00a7a%.2f\n\u00a7e\u041f\u043e\u0442\u0440\u0430\u0447\u0435\u043d\u043e: \u00a7c%.2f", this.playerName, this.auctionsCreated, this.totalRevenue.doubleValue(), this.totalSpent.doubleValue());
    }

    public String serialize() {
        return String.join((CharSequence)",", this.playerId.toString(), this.playerName, String.valueOf(this.auctionsCreated), String.valueOf(this.auctionsWon), String.valueOf(this.bidsPlaced), this.totalRevenue.setScale(2, RoundingMode.HALF_UP).toString(), this.totalSpent.setScale(2, RoundingMode.HALF_UP).toString(), String.valueOf(this.firstJoinTime), String.valueOf(this.lastAuctionTime));
    }

    public static PlayerStats deserialize(String data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        String[] parts = data.split(",");
        if (parts.length != 9) {
            return null;
        }
        try {
            PlayerStats stats = new PlayerStats(UUID.fromString(parts[0]), parts[1]);
            stats.setAuctionsCreated(Integer.parseInt(parts[2]));
            stats.setAuctionsWon(Integer.parseInt(parts[3]));
            stats.setBidsPlaced(Integer.parseInt(parts[4]));
            stats.setTotalRevenue(Double.parseDouble(parts[5]));
            stats.setTotalSpent(Double.parseDouble(parts[6]));
            stats.setFirstJoinTime(Long.parseLong(parts[7]));
            stats.setLastAuctionTime(Long.parseLong(parts[8]));
            return stats;
        }
        catch (Exception e) {
            return null;
        }
    }
}

