/*
 * Decompiled with CFR 0.152.
 */
package me.demstudios.stats;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.demstudios.BLAuction;
import me.demstudios.stats.PlayerStats;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PlayerStatsManager {
    private final BLAuction plugin;
    private final Map<UUID, PlayerStats> statsMap = new HashMap<UUID, PlayerStats>();

    public PlayerStatsManager(BLAuction plugin) {
        this.plugin = plugin;
    }

    public PlayerStats getPlayerStats(UUID playerId) {
        return this.statsMap.computeIfAbsent(playerId, id -> {
            Player player = Bukkit.getPlayer((UUID)id);
            return new PlayerStats((UUID)id, player != null ? player.getName() : "Unknown");
        });
    }

    public void savePlayerStats(PlayerStats stats) {
        if (stats != null) {
            this.statsMap.put(stats.getPlayerId(), stats);
        }
    }

    public void onPlayerJoin(Player player) {
        PlayerStats stats = this.getPlayerStats(player.getUniqueId());
        stats.setPlayerName(player.getName());
    }

    public void saveAllStats() {
        this.statsMap.values().forEach(this::savePlayerStats);
    }
}

