/*
 * Decompiled with CFR 0.152.
 */
package me.demstudios.utils;

import java.util.HashMap;
import java.util.Map;
import me.demstudios.managers.MessageManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemNameUtils {
    private static final Map<String, String> CUSTOM_NAMES = new HashMap<String, String>();

    public static String getLocalizedItemName(Material material) {
        return ItemNameUtils.getLocalizedItemName(new ItemStack(material));
    }

    public static String getLocalizedItemName(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            return meta.getDisplayName();
        }
        String localizedName = ItemNameUtils.getBukkitLocalizedName(itemStack);
        if (localizedName != null && !localizedName.isEmpty()) {
            return localizedName;
        }
        String nmsName = ItemNameUtils.getNMSLocalizedName(itemStack);
        if (nmsName != null && !nmsName.isEmpty()) {
            return nmsName;
        }
        return ItemNameUtils.formatMaterialName(itemStack.getType().name());
    }

    private static String getBukkitLocalizedName(ItemStack itemStack) {
        try {
            ItemStack tempItem = itemStack.clone();
            ItemMeta meta = tempItem.getItemMeta();
            if (meta != null) {
                String localizedName = meta.getLocalizedName();
                if (!(localizedName == null || localizedName.isEmpty() || localizedName.equals(itemStack.getType().getKey().getKey()) || localizedName.equals(itemStack.getType().name()))) {
                    return localizedName;
                }
                String displayName = meta.getDisplayName();
                if (!(displayName == null || displayName.isEmpty() || displayName.equals(itemStack.getType().getKey().getKey()) || displayName.equals(itemStack.getType().name()))) {
                    return displayName;
                }
            }
            return ItemNameUtils.getI18nLocalizedName(itemStack);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getI18nLocalizedName(ItemStack itemStack) {
        try {
            String key = "item." + itemStack.getType().getKey().getNamespace() + "." + itemStack.getType().getKey().getKey();
            String result = ItemNameUtils.getLocalizedStringViaCraftChatMessage(key);
            if (result != null) {
                return result;
            }
            result = ItemNameUtils.getLocalizedStringViaServer(key);
            if (result != null) {
                return result;
            }
            result = ItemNameUtils.getLocalizedStringViaNMS(key);
            if (result != null) {
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String getLocalizedStringViaCraftChatMessage(String key) {
        try {
            String[] versions;
            for (String version : versions = new String[]{"v1_20_R1", "v1_19_R3", "v1_19_R2", "v1_19_R1", "v1_18_R2", "v1_18_R1"}) {
                try {
                    Object result;
                    Class<?> craftChatMessageClass = Class.forName("org.bukkit.craftbukkit." + version + ".util.CraftChatMessage");
                    if (craftChatMessageClass == null || (result = craftChatMessageClass.getMethod("fromString", String.class).invoke(null, key)) == null) continue;
                    return result.toString();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String getLocalizedStringViaServer(String key) {
        try {
            String[] versions;
            for (String version : versions = new String[]{"v1_20_R1", "v1_19_R3", "v1_19_R2", "v1_19_R1", "v1_18_R2", "v1_18_R1"}) {
                try {
                    Object result;
                    Object nmsServer;
                    Server server;
                    Class<?> craftServerClass = Class.forName("org.bukkit.craftbukkit." + version + ".CraftServer");
                    if (craftServerClass == null || (server = Bukkit.getServer()) == null || !craftServerClass.isInstance(server) || (nmsServer = craftServerClass.getMethod("getServer", new Class[0]).invoke((Object)server, new Object[0])) == null || (result = ItemNameUtils.getLocalizedStringFromNMS(nmsServer, key)) == null) continue;
                    return result.toString();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String getLocalizedStringViaNMS(String key) {
        try {
            Object result;
            Object server;
            Class<?> nmsServerClass = Class.forName("net.minecraft.server.MinecraftServer");
            if (nmsServerClass != null && (server = nmsServerClass.getMethod("getServer", new Class[0]).invoke(null, new Object[0])) != null && (result = ItemNameUtils.getLocalizedStringFromNMS(server, key)) != null) {
                return result.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Object getLocalizedStringFromNMS(Object nmsServer, String key) {
        try {
            String[] paths;
            for (String path : paths = new String[]{"getDataManager().getLanguageManager().getLanguage().getOrDefault", "getDataManager().getLanguageManager().getLanguage().get", "getLanguageManager().getLanguage().getOrDefault", "getLanguageManager().getLanguage().get"}) {
                try {
                    String[] parts = path.split("\\.");
                    Object current = nmsServer;
                    for (String part : parts) {
                        if (part.endsWith("()")) {
                            String methodName = part.substring(0, part.length() - 2);
                            current = current.getClass().getMethod(methodName, new Class[0]).invoke(current, new Object[0]);
                        } else {
                            current = current.getClass().getMethod(part, String.class).invoke(current, key);
                        }
                        if (current == null) break;
                    }
                    if (current == null || current.toString().equals(key)) continue;
                    return current;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String getNMSLocalizedName(ItemStack itemStack) {
        try {
            Object nmsName;
            Object nmsItem;
            Object nmsItemStack = itemStack.getClass().getMethod("getHandle", new Class[0]).invoke((Object)itemStack, new Object[0]);
            if (nmsItemStack != null && (nmsItem = nmsItemStack.getClass().getMethod("getItem", new Class[0]).invoke(nmsItemStack, new Object[0])) != null && (nmsName = nmsItem.getClass().getMethod("getName", new Class[0]).invoke(nmsItem, new Object[0])) != null) {
                return nmsName.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String formatMaterialName(String materialName) {
        String[] words = materialName.toLowerCase().split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(Character.toUpperCase(word.charAt(0)));
            if (word.length() <= 1) continue;
            result.append(word.substring(1));
        }
        return result.toString();
    }

    public static void addCustomName(String materialName, String customName) {
        CUSTOM_NAMES.put(materialName, customName);
    }

    public static void removeCustomName(String materialName) {
        CUSTOM_NAMES.remove(materialName);
    }

    public static void loadCustomNamesFromConfig(MessageManager messageManager) {
        String[] materialNames;
        CUSTOM_NAMES.clear();
        for (String materialName : materialNames = new String[]{"COOKED_BEEF", "BREAD", "APPLE", "GOLDEN_APPLE", "ENCHANTED_GOLDEN_APPLE", "COOKED_CHICKEN", "COOKED_PORKCHOP", "COOKED_MUTTON", "COOKED_RABBIT", "COOKED_SALMON", "COOKED_COD", "BAKED_POTATO", "CARROT", "GOLDEN_CARROT", "BEETROOT", "BEETROOT_SOUP", "MUSHROOM_STEW", "RABBIT_STEW", "SUSPICIOUS_STEW", "PUMPKIN_PIE", "CAKE", "COOKIE", "SWEET_BERRIES", "GLOW_BERRIES", "CHORUS_FRUIT", "DRIED_KELP", "HONEY_BOTTLE", "MILK_BUCKET", "WATER_BUCKET", "LAVA_BUCKET", "BUCKET", "IRON_SWORD", "DIAMOND_SWORD", "NETHERITE_SWORD", "GOLDEN_SWORD", "WOODEN_SWORD", "STONE_SWORD", "IRON_PICKAXE", "DIAMOND_PICKAXE", "NETHERITE_PICKAXE", "GOLDEN_PICKAXE", "WOODEN_PICKAXE", "STONE_PICKAXE", "IRON_AXE", "DIAMOND_AXE", "NETHERITE_AXE", "GOLDEN_AXE", "WOODEN_AXE", "STONE_AXE", "IRON_SHOVEL", "DIAMOND_SHOVEL", "NETHERITE_SHOVEL", "GOLDEN_SHOVEL", "WOODEN_SHOVEL", "STONE_SHOVEL", "IRON_HOE", "DIAMOND_HOE", "NETHERITE_HOE", "GOLDEN_HOE", "WOODEN_HOE", "STONE_HOE"}) {
            String customName = messageManager.getItemCustomName(materialName);
            if (customName == null || customName.isEmpty()) continue;
            CUSTOM_NAMES.put(materialName, customName);
        }
    }
}

