/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.mcwbiomesoplenty;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.bridges.Bridges;
import fr.samlegamer.addonslib.client.APIRenderTypes;
import fr.samlegamer.addonslib.data.ModType;
import fr.samlegamer.addonslib.door.Doors;
import fr.samlegamer.addonslib.fences.Fences;
import fr.samlegamer.addonslib.furnitures.AddFurnituresStorage;
import fr.samlegamer.addonslib.furnitures.Furnitures;
import fr.samlegamer.addonslib.generation.loot_tables.McwLootTables;
import fr.samlegamer.addonslib.generation.tags.McwBlockTags;
import fr.samlegamer.addonslib.generation.tags.McwItemTags;
import fr.samlegamer.addonslib.path.Paths;
import fr.samlegamer.addonslib.roofs.Roofs;
import fr.samlegamer.addonslib.stairs.Stairs;
import fr.samlegamer.addonslib.tab.APICreativeTab;
import fr.samlegamer.addonslib.tab.NewIconRandom;
import fr.samlegamer.addonslib.trapdoor.Trapdoors;
import fr.samlegamer.addonslib.util.McwMod;
import fr.samlegamer.addonslib.windows.Windows;
import fr.samlegamer.mcwbiomesoplenty.Mapping;
import fr.samlegamer.mcwbiomesoplenty.Recipes;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mcwbiomesoplenty")
public class McwBOP
extends McwMod {
    public static final String MODID = "mcwbiomesoplenty";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final List<String> WOOD = List.of("dead", "fir", "hellbark", "jacaranda", "magic", "mahogany", "palm", "redwood", "umbran", "willow", "empyreal", "maple", "pine");
    public static final List<String> LEAVES = List.of("dead", "fir", "hellbark", "jacaranda", "magic", "mahogany", "palm", "redwood", "umbran", "willow", "empyreal", "pine", "orange_maple", "red_maple", "yellow_maple", "cypress", "snowblossom", "flowering_oak", "rainbow_birch", "origin");
    private static final DeferredRegister<Block> block = Registration.blocks((String)"mcwbiomesoplenty");
    private static final DeferredRegister<Item> item = Registration.items((String)"mcwbiomesoplenty");
    public static final DeferredRegister<CreativeModeTab> ct = Registration.creativeModeTab((String)"mcwbiomesoplenty");
    public static final RegistryObject<CreativeModeTab> MCWBOP_TAB = ct.register("tab", () -> CreativeModeTab.builder().icon(McwBOP::getIcon).title((Component)Component.translatable((String)"mcwbiomesoplenty.tab")).build());

    public McwBOP(FMLJavaModLoadingContext context) {
        super(context);
        LOGGER.info("Macaw's Biomes O' Plenty Loading...");
        Registration.init((FMLJavaModLoadingContext)context, block, item, ct);
        BlockBehaviour.Properties prop_crimson = BlockBehaviour.Properties.of().mapColor(MapColor.CRIMSON_STEM).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.NETHER_WOOD);
        BlockBehaviour.Properties prop_cherry = BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_WHITE).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.CHERRY_WOOD).ignitedByLava();
        List<String> woodClassic = List.of("dead", "fir", "mahogany", "palm", "redwood", "willow", "pine");
        List<String> woodCrimson = List.of("hellbark", "umbran", "empyreal");
        List<String> woodCherry = List.of("magic", "jacaranda", "maple");
        List<String> leaveClassic = List.of("dead", "fir", "hellbark", "mahogany", "palm", "redwood", "umbran", "willow", "empyreal", "pine", "cypress", "flowering_oak", "rainbow_birch", "origin");
        List<String> leaveCherry = List.of("snowblossom", "orange_maple", "red_maple", "yellow_maple", "jacaranda", "magic");
        Bridges.setRegistrationWood(woodClassic, block, item);
        Fences.setRegistrationWood(woodClassic, block, item);
        Fences.setRegistrationHedges(leaveClassic, block, item);
        Furnitures.setRegistrationWood(woodClassic, block, item);
        Roofs.setRegistrationWood(woodClassic, block, item);
        Trapdoors.setRegistrationWood(woodClassic, block, item);
        Paths.setRegistrationWood(woodClassic, block, item);
        Doors.setRegistrationWood(woodClassic, block, item);
        Windows.setRegistrationWood(woodClassic, block, item);
        Stairs.setRegistrationWood(woodClassic, block, item);
        Bridges.setRegistrationWoodModLoaded(woodCrimson, block, item, (BlockBehaviour.Properties)prop_crimson);
        Fences.setRegistrationWoodModLoaded(woodCrimson, block, item, (BlockBehaviour.Properties)prop_crimson);
        Furnitures.setRegistrationWoodModLoaded(woodCrimson, block, item, (BlockBehaviour.Properties)prop_crimson);
        Roofs.setRegistrationWoodModLoaded(woodCrimson, block, item, (BlockBehaviour.Properties)prop_crimson);
        Trapdoors.setRegistrationWoodModLoaded(woodCrimson, block, item, (BlockBehaviour.Properties)prop_crimson);
        Paths.setRegistrationWoodModLoaded(woodCrimson, block, item, (BlockBehaviour.Properties)prop_crimson);
        Doors.setRegistrationWoodModLoaded(woodCrimson, block, item, (BlockBehaviour.Properties)prop_crimson, (BlockBehaviour.Properties)BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().pushReaction(PushReaction.DESTROY));
        Windows.setRegistrationWoodModLoaded(woodCrimson, block, item, (BlockBehaviour.Properties)prop_crimson);
        Stairs.setRegistrationWoodModLoaded(woodCrimson, block, item, (BlockBehaviour.Properties)prop_crimson);
        Bridges.setRegistrationWoodModLoaded(woodCherry, block, item, (BlockBehaviour.Properties)prop_cherry);
        Fences.setRegistrationWoodModLoaded(woodCherry, block, item, (BlockBehaviour.Properties)prop_cherry);
        Fences.setRegistrationHedgesModLoaded(leaveCherry, block, item, (BlockBehaviour.Properties)BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).strength(0.2f).randomTicks().sound(SoundType.CHERRY_LEAVES).noOcclusion());
        Furnitures.setRegistrationWoodModLoaded(woodCherry, block, item, (BlockBehaviour.Properties)prop_cherry);
        Roofs.setRegistrationWoodModLoaded(woodCherry, block, item, (BlockBehaviour.Properties)prop_cherry);
        Trapdoors.setRegistrationWoodModLoaded(woodCherry, block, item, (BlockBehaviour.Properties)prop_cherry);
        Paths.setRegistrationWoodModLoaded(woodCherry, block, item, (BlockBehaviour.Properties)prop_cherry);
        Doors.setRegistrationWoodModLoaded(woodCherry, block, item, (BlockBehaviour.Properties)prop_cherry, (BlockBehaviour.Properties)BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion());
        Windows.setRegistrationWoodModLoaded(woodCherry, block, item, (BlockBehaviour.Properties)prop_cherry);
        Stairs.setRegistrationWoodModLoaded(woodCherry, block, item, (BlockBehaviour.Properties)prop_cherry);
        context.getModEventBus().addListener(this::clientSetup);
        context.getModEventBus().addListener(this::commonSetup);
        context.getModEventBus().addListener(this::dataSetup);
        context.getModEventBus().addListener(this::tabSetup);
        MinecraftForge.EVENT_BUS.register(Mapping.class);
        LOGGER.info("Macaw's Biomes O' Plenty Is Charged !");
    }

    public void clientSetup(FMLClientSetupEvent event) {
        APIRenderTypes.initAllWood((FMLClientSetupEvent)event, (String)MODID, WOOD, (ModType[])Registration.getAllModTypeWood());
        APIRenderTypes.initAllLeave((FMLClientSetupEvent)event, (String)MODID, LEAVES);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        AddFurnituresStorage.addCompatibleBlocksToFurnitureStorage((FMLCommonSetupEvent)event, (String)MODID, WOOD);
        event.enqueueWork(() -> {
            McwLootTables.addBlockAllWood((String)MODID, WOOD);
            McwLootTables.addBlockHedges((String)MODID, LEAVES);
        });
    }

    public void dataSetup(GatherDataEvent gatherDataEvent) {
        DataGenerator generator = gatherDataEvent.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture registries = gatherDataEvent.getLookupProvider();
        ExistingFileHelper existingFileHelper = gatherDataEvent.getExistingFileHelper();
        if (gatherDataEvent.includeServer()) {
            McwBlockTags mcwBlockTags = new McwBlockTags(this, packOutput, registries, MODID, existingFileHelper){

                protected void addTags(HolderLookup.Provider p_256380_) {
                    this.addAllMcwTags(McwBOP.MODID, WOOD, LEAVES);
                }
            };
            generator.addProvider(true, (DataProvider)new Recipes.Runner(packOutput, registries));
            generator.addProvider(true, (DataProvider)mcwBlockTags);
            generator.addProvider(true, (DataProvider)new McwItemTags(this, packOutput, registries, mcwBlockTags.contentsGetter(), MODID, existingFileHelper){

                protected void addTags(HolderLookup.Provider p_256380_) {
                    this.addAllMcwTags(McwBOP.MODID, WOOD, LEAVES);
                }
            });
        }
    }

    public void tabSetup(BuildCreativeModeTabContentsEvent event) {
        APICreativeTab.initAllWood((BuildCreativeModeTabContentsEvent)event, (String)MODID, WOOD, (CreativeModeTab)((CreativeModeTab)MCWBOP_TAB.get()), (ModType[])Registration.getAllModTypeWood());
        APICreativeTab.initAllLeave((BuildCreativeModeTabContentsEvent)event, (String)MODID, LEAVES, (CreativeModeTab)((CreativeModeTab)MCWBOP_TAB.get()));
    }

    private static ItemStack getIcon() {
        NewIconRandom.NewProperties prop = new NewIconRandom.NewProperties(Finder.findBlock((String)MODID, (String)"redwood_roof"), Finder.findBlock((String)MODID, (String)"redwood_picket_fence"), Finder.findBlock((String)MODID, (String)"redwood_wardrobe"), Finder.findBlock((String)MODID, (String)"redwood_log_bridge_middle"), Finder.findBlock((String)MODID, (String)"redwood_pane_window"), Finder.findBlock((String)MODID, (String)"redwood_modern_door"), Finder.findBlock((String)MODID, (String)"redwood_mystic_trapdoor"), Finder.findBlock((String)MODID, (String)"redwood_planks_path"), Finder.findBlock((String)MODID, (String)"redwood_skyline_stairs"));
        prop.addType(NewIconRandom.BlockType.BRIDGES).addType(NewIconRandom.BlockType.ROOFS).addType(NewIconRandom.BlockType.FENCES).addType(NewIconRandom.BlockType.FURNITURES).addType(NewIconRandom.BlockType.STAIRS).addType(NewIconRandom.BlockType.PATHS).addType(NewIconRandom.BlockType.WINDOWS).addType(NewIconRandom.BlockType.DOORS).addType(NewIconRandom.BlockType.TRAPDOORS);
        Block icon = prop.buildIcon(new NewIconRandom.BlockType[]{NewIconRandom.BlockType.BRIDGES, NewIconRandom.BlockType.ROOFS, NewIconRandom.BlockType.FENCES, NewIconRandom.BlockType.FURNITURES, NewIconRandom.BlockType.STAIRS, NewIconRandom.BlockType.PATHS, NewIconRandom.BlockType.WINDOWS, NewIconRandom.BlockType.DOORS, NewIconRandom.BlockType.TRAPDOORS});
        return new ItemStack((ItemLike)icon);
    }
}

