/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.temperature999;

import com.yourname.temperature999.Temperature999;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class DisplayManager {
    private final Temperature999 plugin;
    private final Map<UUID, BossBar> playerBossBars = new ConcurrentHashMap<UUID, BossBar>();

    public DisplayManager(Temperature999 plugin) {
        this.plugin = plugin;
    }

    public void addPlayer(Player player) {
        BossBar bossBar = Bukkit.createBossBar((String)"Temperature", (BarColor)BarColor.BLUE, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        bossBar.addPlayer(player);
        this.playerBossBars.put(player.getUniqueId(), bossBar);
    }

    public void removePlayer(Player player) {
        BossBar bossBar = this.playerBossBars.remove(player.getUniqueId());
        if (bossBar != null) {
            bossBar.removeAll();
        }
    }

    public void updatePlayerDisplay(Player player, double temperature) {
        UUID uuid = player.getUniqueId();
        if (this.plugin.isDisplayToggled(uuid)) {
            BossBar bossBar = this.playerBossBars.get(uuid);
            if (bossBar != null) {
                bossBar.setVisible(false);
            }
            return;
        }
        BossBar bossBar = this.playerBossBars.get(uuid);
        if (bossBar != null) {
            bossBar.setVisible(true);
            bossBar.setProgress(temperature / 100.0);
            bossBar.setTitle(this.getTemperatureMessage(temperature));
            bossBar.setColor(this.getBarColor(temperature));
        }
        this.applyVisualEffects(player, temperature);
    }

    private void applyVisualEffects(Player player, double temperature) {
        if (temperature < (double)this.plugin.getFreezeThreshold()) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 120, 0));
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_HURT_FREEZE, 1.0f, 1.0f);
        } else if (temperature > (double)this.plugin.getBurnThreshold()) {
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_BREATH, 1.0f, 1.0f);
        }
    }

    private String getTemperatureMessage(double temperature) {
        if (temperature < 20.0) {
            return String.valueOf(ChatColor.AQUA) + "Freezing";
        }
        if (temperature < 40.0) {
            return String.valueOf(ChatColor.BLUE) + "Cold";
        }
        if (temperature < 60.0) {
            return String.valueOf(ChatColor.GREEN) + "Comfortable";
        }
        if (temperature < 80.0) {
            return String.valueOf(ChatColor.GOLD) + "Warm";
        }
        return String.valueOf(ChatColor.RED) + "Burning";
    }

    private BarColor getBarColor(double temperature) {
        if (temperature < 20.0) {
            return BarColor.BLUE;
        }
        if (temperature < 40.0) {
            return BarColor.GREEN;
        }
        if (temperature < 60.0) {
            return BarColor.GREEN;
        }
        if (temperature < 80.0) {
            return BarColor.YELLOW;
        }
        return BarColor.RED;
    }
}

