/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.temperature999;

import com.yourname.temperature999.DisplayManager;
import com.yourname.temperature999.TemperatureCommand;
import com.yourname.temperature999.TemperatureManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class Temperature999
extends JavaPlugin
implements Listener {
    private final Map<UUID, Double> playerTemperatures = new ConcurrentHashMap<UUID, Double>();
    private final Set<UUID> displayToggled = new HashSet<UUID>();
    private DisplayManager displayManager;
    private TemperatureManager temperatureManager;
    private List<String> enabledWorlds;
    private List<String> hotBiomes;
    private List<String> coldBiomes;
    private int updateInterval;
    private double dayNormalRate;
    private double dayHotBiomeRate;
    private double dayColdBiomeRate;
    private double nightNormalRate;
    private double nightHotBiomeRate;
    private double nightColdBiomeRate;
    private double waterRate;
    private double wetnessRate;
    private double heatSourceRate;
    private double coldSourceRate;
    private Map<String, Double> insulationValues;
    private List<String> heatSources;
    private List<String> coldSources;
    private int freezeThreshold;
    private int burnThreshold;
    private double freezeDamage;
    private double burnDamage;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.displayManager = new DisplayManager(this);
        this.temperatureManager = new TemperatureManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("temperature999").setExecutor((CommandExecutor)new TemperatureCommand(this));
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.playerTemperatures.putIfAbsent(player.getUniqueId(), 50.0);
            this.displayManager.addPlayer(player);
        }
        this.startUpdateTask();
        this.getLogger().info(String.valueOf(ChatColor.GREEN) + "Temperature999 has been enabled!");
    }

    public void onDisable() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.displayManager.removePlayer(player);
        }
    }

    public void loadConfig() {
        this.reloadConfig();
        FileConfiguration config = this.getConfig();
        this.enabledWorlds = config.getStringList("worlds.enabled");
        this.hotBiomes = config.getStringList("biomes.hot");
        this.coldBiomes = config.getStringList("biomes.cold");
        this.updateInterval = config.getInt("update_interval_ticks");
        this.dayNormalRate = config.getDouble("rates.day.normal");
        this.dayHotBiomeRate = config.getDouble("rates.day.hot_biome");
        this.dayColdBiomeRate = config.getDouble("rates.day.cold_biome");
        this.nightNormalRate = config.getDouble("rates.night.normal");
        this.nightHotBiomeRate = config.getDouble("rates.night.hot_biome");
        this.nightColdBiomeRate = config.getDouble("rates.night.cold_biome");
        this.waterRate = config.getDouble("rates.water");
        this.wetnessRate = config.getDouble("rates.wetness");
        this.heatSourceRate = config.getDouble("rates.heat_source");
        this.coldSourceRate = config.getDouble("rates.cold_source");
        this.insulationValues = new HashMap<String, Double>();
        for (String material : config.getConfigurationSection("insulation").getKeys(false)) {
            this.insulationValues.put(material, config.getDouble("insulation." + material));
        }
        this.heatSources = config.getStringList("sources.heat");
        this.coldSources = config.getStringList("sources.cold");
        this.freezeThreshold = config.getInt("damage.freezing.threshold");
        this.burnThreshold = config.getInt("damage.burning.threshold");
        this.freezeDamage = config.getDouble("damage.freezing.damage_per_second");
        this.burnDamage = config.getDouble("damage.burning.damage_per_second");
    }

    private void startUpdateTask() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    Temperature999.this.updatePlayerTemperature(player);
                }
            }
        }.runTaskTimer((Plugin)this, 0L, (long)this.updateInterval);
    }

    private void updatePlayerTemperature(Player player) {
        UUID uuid = player.getUniqueId();
        double currentTemp = this.playerTemperatures.getOrDefault(uuid, 50.0);
        double change = this.temperatureManager.calculateTemperatureChange(player);
        double newTemp = Math.max(0.0, Math.min(100.0, currentTemp + change));
        this.playerTemperatures.put(uuid, newTemp);
        this.displayManager.updatePlayerDisplay(player, newTemp);
        this.applyTemperatureEffects(player, newTemp);
    }

    private void applyTemperatureEffects(Player player, double temperature) {
        if (temperature < (double)this.freezeThreshold) {
            player.damage(this.freezeDamage);
        } else if (temperature > (double)this.burnThreshold) {
            player.damage(this.burnDamage);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.playerTemperatures.putIfAbsent(player.getUniqueId(), 50.0);
        this.displayManager.addPlayer(player);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.playerTemperatures.remove(player.getUniqueId());
        this.displayManager.removePlayer(player);
    }

    public void reloadConfiguration() {
        this.loadConfig();
    }

    public double getPlayerTemperature(UUID uuid) {
        return this.playerTemperatures.getOrDefault(uuid, 50.0);
    }

    public void setPlayerTemperature(UUID uuid, double temperature) {
        this.playerTemperatures.put(uuid, temperature);
    }

    public void toggleDisplay(UUID uuid) {
        if (this.displayToggled.contains(uuid)) {
            this.displayToggled.remove(uuid);
        } else {
            this.displayToggled.add(uuid);
        }
    }

    public boolean isDisplayToggled(UUID uuid) {
        return this.displayToggled.contains(uuid);
    }

    public List<String> getEnabledWorlds() {
        return this.enabledWorlds;
    }

    public List<String> getHotBiomes() {
        return this.hotBiomes;
    }

    public List<String> getColdBiomes() {
        return this.coldBiomes;
    }

    public double getDayNormalRate() {
        return this.dayNormalRate;
    }

    public double getDayHotBiomeRate() {
        return this.dayHotBiomeRate;
    }

    public double getDayColdBiomeRate() {
        return this.dayColdBiomeRate;
    }

    public double getNightNormalRate() {
        return this.nightNormalRate;
    }

    public double getNightHotBiomeRate() {
        return this.nightHotBiomeRate;
    }

    public double getNightColdBiomeRate() {
        return this.nightColdBiomeRate;
    }

    public double getWaterRate() {
        return this.waterRate;
    }

    public double getWetnessRate() {
        return this.wetnessRate;
    }

    public double getHeatSourceRate() {
        return this.heatSourceRate;
    }

    public double getColdSourceRate() {
        return this.coldSourceRate;
    }

    public double getInsulation(Material material) {
        return this.insulationValues.getOrDefault(material.name(), 0.0);
    }

    public List<String> getHeatSources() {
        return this.heatSources;
    }

    public List<String> getColdSources() {
        return this.coldSources;
    }

    public int getFreezeThreshold() {
        return this.freezeThreshold;
    }

    public int getBurnThreshold() {
        return this.burnThreshold;
    }
}

