/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.temperature999;

import com.yourname.temperature999.Temperature999;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TemperatureCommand
implements CommandExecutor {
    private final Temperature999 plugin;

    public TemperatureCommand(Temperature999 plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
            this.sendHelpMessage(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "check": {
                this.handleCheckCommand(sender, args);
                break;
            }
            case "toggle": {
                this.handleToggleCommand(sender);
                break;
            }
            case "admin": {
                this.handleAdminCommand(sender, args);
                break;
            }
            case "biomes": {
                this.handleBiomesCommand(sender, args);
                break;
            }
            case "config": {
                if (args.length <= 1 || !args[1].equalsIgnoreCase("reload")) break;
                this.plugin.reloadConfiguration();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Configuration reloaded!");
                break;
            }
            default: {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown command. Use /temp help for help.");
            }
        }
        return true;
    }

    private void handleCheckCommand(CommandSender sender, String[] args) {
        if (args.length == 1) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                double temp = this.plugin.getPlayerTemperature(player.getUniqueId());
                player.sendMessage(String.valueOf(ChatColor.GOLD) + "Your current temperature is: " + String.format("%.1f", temp));
            } else {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be run by a player.");
            }
        } else if (sender.hasPermission("temperature999.check.others")) {
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target != null) {
                double temp = this.plugin.getPlayerTemperature(target.getUniqueId());
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + target.getName() + "'s current temperature is: " + String.format("%.1f", temp));
            } else {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            }
        } else {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to check other players' temperature.");
        }
    }

    private void handleToggleCommand(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.plugin.toggleDisplay(player.getUniqueId());
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Temperature display toggled.");
        } else {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be run by a player.");
        }
    }

    private void handleAdminCommand(CommandSender sender, String[] args) {
        if (sender.hasPermission("temperature999.admin")) {
            if (args.length > 2 && args[1].equalsIgnoreCase("set")) {
                Player target = Bukkit.getPlayer((String)args[2]);
                if (target != null) {
                    try {
                        double temp = Double.parseDouble(args[3]);
                        this.plugin.setPlayerTemperature(target.getUniqueId(), temp);
                        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Set " + target.getName() + "'s temperature to " + temp);
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid temperature value.");
                    }
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                }
            } else {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /temp admin set <player> <temp>");
            }
        } else {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
        }
    }

    private void handleBiomesCommand(CommandSender sender, String[] args) {
        if (sender.hasPermission("temperature999.admin.biomes")) {
            if (args.length > 1) {
                if (args[1].equalsIgnoreCase("list")) {
                    if (args.length > 2) {
                        if (args[2].equalsIgnoreCase("hot")) {
                            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Hot Biomes:");
                            List<String> hotBiomes = this.plugin.getHotBiomes();
                            for (String biome : hotBiomes) {
                                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "- " + biome);
                            }
                        } else if (args[2].equalsIgnoreCase("cold")) {
                            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Cold Biomes:");
                            List<String> coldBiomes = this.plugin.getColdBiomes();
                            for (String biome : coldBiomes) {
                                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "- " + biome);
                            }
                        } else {
                            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /temp biomes list <hot/cold>");
                        }
                    } else {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /temp biomes list <hot/cold>");
                    }
                }
            } else {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /temp biomes list <hot/cold>");
            }
        } else {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
        }
    }

    private void sendHelpMessage(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "====== Temperature999 Help ======");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/temp help" + String.valueOf(ChatColor.WHITE) + " - Show this help");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/temp check [player]" + String.valueOf(ChatColor.WHITE) + " - Checks temperature");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/temp toggle" + String.valueOf(ChatColor.WHITE) + " - Toggles the display");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/temp admin set <player> <temp>" + String.valueOf(ChatColor.WHITE) + " - Sets a player's temperature");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/temp biomes list <hot/cold>" + String.valueOf(ChatColor.WHITE) + " - Lists biomes");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/temp config reload" + String.valueOf(ChatColor.WHITE) + " - Reloads configuration");
    }
}

