/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.temperature999;

import com.yourname.temperature999.Temperature999;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class TemperatureManager {
    private final Temperature999 plugin;

    public TemperatureManager(Temperature999 plugin) {
        this.plugin = plugin;
    }

    public double calculateTemperatureChange(Player player) {
        boolean isNight;
        Location loc = player.getLocation();
        String biome = loc.getBlock().getBiome().name();
        double change = 0.0;
        if (!this.plugin.getEnabledWorlds().contains(loc.getWorld().getName())) {
            return 0.0;
        }
        long time = loc.getWorld().getTime();
        boolean bl = isNight = time > 12300L && time < 23850L;
        change = this.plugin.getHotBiomes().contains(biome) ? (change += isNight ? this.plugin.getNightHotBiomeRate() : this.plugin.getDayHotBiomeRate()) : (this.plugin.getColdBiomes().contains(biome) ? (change += isNight ? this.plugin.getNightColdBiomeRate() : this.plugin.getDayColdBiomeRate()) : (change += isNight ? this.plugin.getNightNormalRate() : this.plugin.getDayNormalRate()));
        double insulation = 0.0;
        for (ItemStack armor : player.getInventory().getArmorContents()) {
            if (armor == null) continue;
            insulation += this.plugin.getInsulation(armor.getType());
        }
        change -= insulation * 0.1;
        if (player.isInWater()) {
            change += this.plugin.getWaterRate();
        } else if (player.getWorld().hasStorm() && player.getLocation().getY() >= (double)player.getWorld().getHighestBlockYAt(player.getLocation())) {
            change += this.plugin.getWetnessRate();
        }
        if (this.isNearHeatSource(loc)) {
            change += this.plugin.getHeatSourceRate();
        } else if (this.isNearColdSource(loc)) {
            change += this.plugin.getColdSourceRate();
        }
        return change;
    }

    private boolean isNearHeatSource(Location loc) {
        return this.isNearSource(loc, this.plugin.getHeatSources());
    }

    private boolean isNearColdSource(Location loc) {
        return this.isNearSource(loc, this.plugin.getColdSources());
    }

    private boolean isNearSource(Location loc, List<String> sources) {
        int radius = 1;
        World world = loc.getWorld();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    Block block = world.getBlockAt(loc.clone().add((double)x, (double)y, (double)z));
                    if (!sources.contains(block.getType().name())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

