/*
 * Decompiled with CFR 0.152.
 */
package io.github.furromaid.core;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig {
    public static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("rot_config.json");
    public static List<String> notInfestable = new ArrayList<String>(List.of(""));
    public static boolean experimentalMode = true;
    public static boolean claimProtection = true;

    public static void load() {
        try {
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                ModConfig.save();
                return;
            }
            String json = Files.readString(CONFIG_PATH);
            JsonObject obj = JsonParser.parseString((String)json).getAsJsonObject();
            if (obj.has("Not Infestable")) {
                notInfestable.clear();
                JsonArray arr = obj.getAsJsonArray("Not Infestable");
                for (JsonElement el : arr) {
                    notInfestable.add(el.getAsString());
                }
            }
            if (obj.has("Experimental Mode")) {
                experimentalMode = obj.get("Experimental Mode").getAsBoolean();
            }
            if (obj.has("Claim Protection")) {
                claimProtection = obj.get("Claim Protection").getAsBoolean();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            JsonObject obj = new JsonObject();
            JsonArray list = new JsonArray();
            for (String value : notInfestable) {
                list.add(value);
            }
            obj.add("Claim Protection", (JsonElement)new JsonPrimitive(Boolean.valueOf(claimProtection)));
            new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)obj, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

