/*
 * Decompiled with CFR 0.152.
 */
package io.github.furromaid.systems.cursor_system;

import io.github.furromaid.systems.cursor_system.ICursor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_3218;

public class CursorSystem {
    private static final List<ICursor> virtualCursors = new ArrayList<ICursor>();
    private static final int maxCursors = 100;
    private int cursorIndex = 0;

    public CursorSystem() {
        ServerTickEvents.END_WORLD_TICK.register(this::onServerTick);
    }

    public void onServerTick(class_3218 server) {
        this.tickVirtualCursors();
    }

    public static void addCursor(ICursor cursor) {
        if (virtualCursors.size() < 100 && !virtualCursors.contains(cursor)) {
            virtualCursors.add(cursor);
        }
    }

    private void tickVirtualCursors() {
        Iterator<ICursor> iterator = virtualCursors.iterator();
        while (iterator.hasNext()) {
            ICursor cursor = iterator.next();
            if (cursor.isFinished()) {
                iterator.remove();
                continue;
            }
            cursor.tick();
        }
    }
}

