/*
 * Decompiled with CFR 0.152.
 */
package io.github.furromaid.systems.cursor_system;

import io.github.furromaid.common.command.DebugCommand;
import io.github.furromaid.systems.cursor_system.ICursor;
import io.github.furromaid.systems.infestation_systems.block_infestation_system.BlockInfestationSystem;
import io.github.furromaid.util.BlockAlgorithms;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class InfectionCursor
implements ICursor {
    private final class_3218 world;
    private class_2338 pos;
    protected HashMap<Long, Boolean> positionsSearched = new HashMap();
    protected HashMap<Long, Boolean> visitedPositions = new HashMap();
    Queue<class_2338> searchQueue = new LinkedList<class_2338>();
    private int lifeSpan = 300;
    private final Random random = new Random();
    int g = 0;

    public InfectionCursor(class_3218 level, class_2338 pos) {
        this.world = level;
        this.pos = pos;
    }

    protected void resetSearchTick() {
        this.searchQueue.clear();
        this.positionsSearched.clear();
        this.visitedPositions.clear();
    }

    protected void addPositionToQueueIfValid(class_2338 pos) {
        boolean isPositionNotObstructed;
        boolean isPositionNotVisited = !this.positionsSearched.containsKey(pos.method_10063());
        class_2680 neighborBlockState = this.world.method_8320(pos);
        boolean bl = isPositionNotObstructed = !this.isObstructed(neighborBlockState, pos);
        if (isPositionNotVisited && isPositionNotObstructed) {
            this.searchQueue.add(pos);
            this.positionsSearched.put(pos.method_10063(), true);
        }
    }

    protected boolean isObstructed(class_2680 state, class_2338 pos) {
        if (state.method_26215()) {
            return true;
        }
        if (!state.method_26227().method_15769()) {
            if (state.method_26227().method_39360((class_3611)class_3612.field_15910) && state.method_27852(class_2246.field_10382)) {
                return true;
            }
            if (!state.method_26227().method_39360((class_3611)class_3612.field_15910)) {
                return true;
            }
        } else if (this.visitedPositions.containsKey(pos.method_10063())) {
            return true;
        }
        boolean isExposedToAir = class_2350.method_42013().map(arg_0 -> ((class_2338)pos).method_10093(arg_0)).anyMatch(adjacentPos -> this.world.method_8320(adjacentPos).method_26215());
        boolean isLikeExposedToAir = BlockAlgorithms.isExposedToAir(this.world, pos);
        boolean isFlora = BlockInfestationSystem.isBlockToRemoveAbove(state);
        return !isLikeExposedToAir;
    }

    @Override
    public void tick() {
        if (this.lifeSpan-- <= 0) {
            return;
        }
        for (int i = 0; i < 100; ++i) {
            class_2350 dir = class_2350.values()[this.random.nextInt(class_2350.values().length)];
            ArrayList<class_2338> neighbors = BlockAlgorithms.getNeighborsCube(this.pos, false);
            class_2338 offset = (class_2338)neighbors.get(new Random().nextInt(neighbors.size()));
            if (DebugCommand.isCursorDebug1Enabled()) {
                this.world.method_14199((class_2394)class_2398.field_11240, (double)offset.method_10263() + 0.5, (double)offset.method_10264() + 1.15, (double)offset.method_10260() + 0.5, 2, 0.2, 0.0, 0.2, 0.0);
            }
            if (DebugCommand.isCursorDebug2Enabled() && !this.isObstructed(this.world.method_8320(offset), offset)) {
                this.world.method_14199((class_2394)class_2398.field_22246, (double)offset.method_10263() + 0.5, (double)offset.method_10264() + 1.15, (double)offset.method_10260() + 0.5, 2, 0.2, 0.0, 0.2, 0.0);
            }
            if (!this.isObstructed(this.world.method_8320(offset), offset)) {
                BlockInfestationSystem.tryToInfestBlock(this.world, offset);
                this.world.method_8396(null, offset, class_3417.field_37364, class_3419.field_15245, 1.0f, 1.2f);
                this.visitedPositions.put(offset.method_10063(), true);
                this.pos = offset;
                this.g = 0;
                break;
            }
            ++this.g;
            if (this.g <= 100) continue;
            this.resetSearchTick();
        }
    }

    @Override
    public boolean isFinished() {
        return this.lifeSpan <= 0;
    }

    @Override
    public class_2338 getPos() {
        return this.pos;
    }

    @Override
    public class_1937 getWorld() {
        return this.world;
    }
}

