/*
 * Decompiled with CFR 0.152.
 */
package io.github.furromaid.util;

import java.util.ArrayList;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class BlockAlgorithms {
    public static boolean isAir(class_2680 blockState) {
        return blockState.method_26215() || blockState.method_27852(class_2246.field_10124) || blockState.method_27852(class_2246.field_10543);
    }

    public static boolean isNotSolid(class_3218 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        boolean isNotSolid = !state.method_51367();
        boolean isAir = state.method_26215();
        return isNotSolid || isAir;
    }

    public static ArrayList<class_2338> getNeighborsCube(class_2338 pos, boolean includeOrigin) {
        ArrayList<class_2338> neighbors = new ArrayList<class_2338>();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (i == 0 && j == 0 && k == 0 && !includeOrigin) continue;
                    neighbors.add(pos.method_10069(i, j, k));
                }
            }
        }
        return neighbors;
    }

    public static ArrayList<class_2338> getAdjacentNeighbors(class_2338 origin) {
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        list.addAll(BlockAlgorithms.getNeighborsXZPlane(origin, false));
        list.addAll(BlockAlgorithms.getNeighborsXZPlane(origin.method_10084(), true));
        list.addAll(BlockAlgorithms.getNeighborsXZPlane(origin.method_10074(), true));
        return list;
    }

    public static ArrayList<class_2338> getNeighborsXZPlane(class_2338 origin, boolean includeOrigin) {
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        list.add(origin.method_10095());
        list.add(origin.method_10095().method_10078());
        list.add(origin.method_10095().method_10067());
        list.add(origin.method_10078());
        list.add(origin.method_10072());
        list.add(origin.method_10072().method_10078());
        list.add(origin.method_10072().method_10067());
        list.add(origin.method_10067());
        if (includeOrigin) {
            list.add(origin);
        }
        return list;
    }

    public static boolean isExposedToAir(class_3218 serverWorld, class_2338 targetPos) {
        ArrayList<class_2338> list = BlockAlgorithms.getAdjacentNeighbors(targetPos);
        for (class_2338 position : list) {
            if (!BlockAlgorithms.isNotSolid(serverWorld, position)) continue;
            return true;
        }
        return false;
    }
}

