/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viarewind.protocol.v1_8to1_7_6_10.provider.compression;

import com.viaversion.viarewind.ViaRewind;
import com.viaversion.viarewind.api.minecraft.netty.EmptyChannelHandler;
import com.viaversion.viarewind.api.minecraft.netty.ForwardMessageToByteEncoder;
import com.viaversion.viarewind.protocol.v1_8to1_7_6_10.provider.CompressionHandlerProvider;
import com.viaversion.viarewind.protocol.v1_8to1_7_6_10.provider.compression.CompressionDecoder;
import com.viaversion.viarewind.protocol.v1_8to1_7_6_10.provider.compression.CompressionEncoder;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;

public class TrackingCompressionHandlerProvider
extends CompressionHandlerProvider {
    @Override
    public void setCompressionThreshold(UserConnection user, int threshold) {
        ChannelPipeline pipeline = user.getChannel().pipeline();
        if (!user.isClientSide() || threshold < 0) {
            this.setRemoveCompression(user, true);
            return;
        }
        String compressHandlerName = ViaRewind.getPlatform().compressHandlerName();
        CompressionEncoder encoder = (CompressionEncoder)pipeline.get(compressHandlerName);
        if (encoder != null) {
            encoder.setThreshold(threshold);
        } else {
            pipeline.addBefore(Via.getManager().getInjector().getEncoderName(), compressHandlerName, this.getEncoder(threshold));
        }
        String decompressHandlerName = ViaRewind.getPlatform().decompressHandlerName();
        CompressionDecoder decoder = (CompressionDecoder)pipeline.get(decompressHandlerName);
        if (decoder != null) {
            decoder.setThreshold(threshold);
        } else {
            pipeline.addBefore(Via.getManager().getInjector().getDecoderName(), decompressHandlerName, this.getDecoder(threshold));
        }
    }

    @Override
    public void onTransformPacket(UserConnection user) {
        if (this.isRemoveCompression(user)) {
            ChannelPipeline pipeline = user.getChannel().pipeline();
            String compressor = null;
            String decompressor = null;
            if (pipeline.get(ViaRewind.getPlatform().compressHandlerName()) != null) {
                compressor = ViaRewind.getPlatform().compressHandlerName();
                decompressor = ViaRewind.getPlatform().decompressHandlerName();
            }
            if (compressor == null) {
                throw new IllegalStateException("Couldn't remove compression for 1.7!");
            }
            pipeline.replace(decompressor, decompressor, (ChannelHandler)new EmptyChannelHandler());
            pipeline.replace(compressor, compressor, (ChannelHandler)new ForwardMessageToByteEncoder());
            this.setRemoveCompression(user, false);
        }
    }

    @Override
    public ChannelHandler getEncoder(int threshold) {
        return new CompressionEncoder(threshold);
    }

    @Override
    public ChannelHandler getDecoder(int threshold) {
        return new CompressionDecoder(threshold);
    }
}

