/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viarewind.protocol.v1_9to1_8.rewriter;

import com.viaversion.viarewind.api.minecraft.math.RelativeMoveUtil;
import com.viaversion.viarewind.api.rewriter.VREntityRewriter;
import com.viaversion.viarewind.protocol.v1_9to1_8.Protocol1_9To1_8;
import com.viaversion.viarewind.protocol.v1_9to1_8.data.EntityDataIndex1_8;
import com.viaversion.viarewind.protocol.v1_9to1_8.storage.CooldownStorage;
import com.viaversion.viarewind.protocol.v1_9to1_8.storage.EntityTracker1_9;
import com.viaversion.viarewind.protocol.v1_9to1_8.storage.LevitationStorage;
import com.viaversion.viarewind.protocol.v1_9to1_8.storage.PlayerPositionTracker;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockPosition;
import com.viaversion.viaversion.api.minecraft.ClientWorld;
import com.viaversion.viaversion.api.minecraft.EulerAngle;
import com.viaversion.viaversion.api.minecraft.Vector;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.minecraft.entities.EntityTypes1_9;
import com.viaversion.viaversion.api.minecraft.entitydata.EntityData;
import com.viaversion.viaversion.api.minecraft.entitydata.EntityDataType;
import com.viaversion.viaversion.api.minecraft.entitydata.types.EntityDataTypes1_8;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.libs.fastutil.ints.IntArrayList;
import com.viaversion.viaversion.libs.fastutil.ints.IntList;
import com.viaversion.viaversion.protocols.v1_8to1_9.data.EntityDataIndex1_9;
import com.viaversion.viaversion.protocols.v1_8to1_9.packet.ClientboundPackets1_8;
import com.viaversion.viaversion.protocols.v1_8to1_9.packet.ClientboundPackets1_9;
import com.viaversion.viaversion.rewriter.entitydata.EntityDataHandlerEvent;
import com.viaversion.viaversion.util.IdAndData;
import com.viaversion.viaversion.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class EntityPacketRewriter1_9
extends VREntityRewriter<ClientboundPackets1_9, Protocol1_9To1_8> {
    private static final byte HAND_ACTIVE_BIT = 0;
    private static final byte STATUS_USE_BIT = 4;

    public EntityPacketRewriter1_9(Protocol1_9To1_8 protocol) {
        super(protocol);
    }

    protected void registerPackets() {
        this.registerRemoveEntities((ClientboundPacketType)ClientboundPackets1_9.REMOVE_ENTITIES);
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.LOGIN, wrapper -> {
            int entityId = (Integer)wrapper.passthrough((Type)Types.INT);
            wrapper.passthrough((Type)Types.UNSIGNED_BYTE);
            byte dimension = (Byte)wrapper.passthrough((Type)Types.BYTE);
            this.trackPlayer(wrapper.user(), entityId);
            ClientWorld clientWorld = wrapper.user().getClientWorld(Protocol1_9To1_8.class);
            clientWorld.setEnvironment((int)dimension);
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.SET_ENTITY_DATA, wrapper -> {
            int entityId = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
            if (!this.tracker(wrapper.user()).hasEntity(entityId)) {
                wrapper.cancel();
                return;
            }
            List entityData = (List)wrapper.read(Types.ENTITY_DATA_LIST1_9);
            this.handleEntityData(entityId, entityData, wrapper.user());
            wrapper.write(Types.ENTITY_DATA_LIST1_8, (Object)entityData);
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.ADD_ENTITY, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT);
                this.read(Types.UUID);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.DOUBLE, Protocol1_9To1_8.DOUBLE_TO_INT_TIMES_32);
                this.map((Type)Types.DOUBLE, Protocol1_9To1_8.DOUBLE_TO_INT_TIMES_32);
                this.map((Type)Types.DOUBLE, Protocol1_9To1_8.DOUBLE_TO_INT_TIMES_32);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.INT);
                this.handler(EntityPacketRewriter1_9.this.getObjectTrackerHandler());
                this.handler(EntityPacketRewriter1_9.this.getObjectRewriter(EntityTypes1_9.ObjectType::findById));
                this.handler(wrapper -> {
                    int data;
                    int entityId = (Integer)wrapper.get((Type)Types.VAR_INT, 0);
                    byte entityType = (Byte)wrapper.get((Type)Types.BYTE, 0);
                    EntityTypes1_9.EntityType type = EntityTypes1_9.ObjectType.getEntityType((int)entityType, (int)(data = ((Integer)wrapper.get((Type)Types.INT, 3)).intValue()));
                    if (type == null || type == EntityTypes1_9.EntityType.AREA_EFFECT_CLOUD || type == EntityTypes1_9.EntityType.SPECTRAL_ARROW || type == EntityTypes1_9.EntityType.DRAGON_FIREBALL) {
                        wrapper.cancel();
                        return;
                    }
                    if (type.is((EntityType)EntityTypes1_9.EntityType.BOAT)) {
                        byte yaw = (Byte)wrapper.get((Type)Types.BYTE, 1);
                        yaw = (byte)(yaw - 64);
                        wrapper.set((Type)Types.BYTE, 1, (Object)yaw);
                        int y = (Integer)wrapper.get((Type)Types.INT, 1);
                        wrapper.set((Type)Types.INT, 1, (Object)(y += 6));
                    }
                    if (type.isOrHasParent((EntityType)EntityTypes1_9.EntityType.ARROW) && data != 0) {
                        wrapper.set((Type)Types.INT, 3, (Object)(--data));
                    }
                    if (type.is((EntityType)EntityTypes1_9.EntityType.FALLING_BLOCK)) {
                        int blockId = data & 0xFFF;
                        int blockData = data >> 12 & 0xF;
                        IdAndData replace = ((Protocol1_9To1_8)EntityPacketRewriter1_9.this.protocol).getItemRewriter().handleBlock(blockId, blockData);
                        if (replace != null) {
                            wrapper.set((Type)Types.INT, 3, (Object)(replace.getId() | replace.getData() << 12));
                        }
                    }
                    if (data > 0) {
                        wrapper.passthrough((Type)Types.SHORT);
                        wrapper.passthrough((Type)Types.SHORT);
                        wrapper.passthrough((Type)Types.SHORT);
                    } else {
                        short velocityX = (Short)wrapper.read((Type)Types.SHORT);
                        short velocityY = (Short)wrapper.read((Type)Types.SHORT);
                        short velocityZ = (Short)wrapper.read((Type)Types.SHORT);
                        PacketWrapper setEntityMotion = PacketWrapper.create((PacketType)ClientboundPackets1_8.SET_ENTITY_MOTION, (UserConnection)wrapper.user());
                        setEntityMotion.write((Type)Types.VAR_INT, (Object)entityId);
                        setEntityMotion.write((Type)Types.SHORT, (Object)velocityX);
                        setEntityMotion.write((Type)Types.SHORT, (Object)velocityY);
                        setEntityMotion.write((Type)Types.SHORT, (Object)velocityZ);
                        setEntityMotion.scheduleSend(Protocol1_9To1_8.class);
                    }
                });
            }
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.ADD_EXPERIENCE_ORB, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT);
                this.map((Type)Types.DOUBLE, Protocol1_9To1_8.DOUBLE_TO_INT_TIMES_32);
                this.map((Type)Types.DOUBLE, Protocol1_9To1_8.DOUBLE_TO_INT_TIMES_32);
                this.map((Type)Types.DOUBLE, Protocol1_9To1_8.DOUBLE_TO_INT_TIMES_32);
                this.map((Type)Types.SHORT);
                this.handler(wrapper -> {
                    int entityId = (Integer)wrapper.get((Type)Types.VAR_INT, 0);
                    wrapper.user().getEntityTracker(Protocol1_9To1_8.class).addEntity(entityId, (EntityType)EntityTypes1_9.EntityType.EXPERIENCE_ORB);
                });
            }
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.ADD_GLOBAL_ENTITY, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.DOUBLE, Protocol1_9To1_8.DOUBLE_TO_INT_TIMES_32);
                this.map((Type)Types.DOUBLE, Protocol1_9To1_8.DOUBLE_TO_INT_TIMES_32);
                this.map((Type)Types.DOUBLE, Protocol1_9To1_8.DOUBLE_TO_INT_TIMES_32);
                this.handler(wrapper -> {
                    int entityId = (Integer)wrapper.get((Type)Types.VAR_INT, 0);
                    wrapper.user().getEntityTracker(Protocol1_9To1_8.class).addEntity(entityId, (EntityType)EntityTypes1_9.EntityType.LIGHTNING_BOLT);
                });
            }
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.ADD_MOB, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT);
                this.read(Types.UUID);
                this.map((Type)Types.UNSIGNED_BYTE);
                this.map((Type)Types.DOUBLE, Protocol1_9To1_8.DOUBLE_TO_INT_TIMES_32);
                this.map((Type)Types.DOUBLE, Protocol1_9To1_8.DOUBLE_TO_INT_TIMES_32);
                this.map((Type)Types.DOUBLE, Protocol1_9To1_8.DOUBLE_TO_INT_TIMES_32);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.SHORT);
                this.map((Type)Types.SHORT);
                this.map((Type)Types.SHORT);
                this.map(Types.ENTITY_DATA_LIST1_9, Types.ENTITY_DATA_LIST1_8);
                this.handler(EntityPacketRewriter1_9.this.getTrackerHandler((Type)Types.UNSIGNED_BYTE, 0));
                this.handler(EntityPacketRewriter1_9.this.getMobSpawnRewriter(Types.ENTITY_DATA_LIST1_8));
            }
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.ADD_PAINTING, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT);
                this.read(Types.UUID);
                this.map(Types.STRING);
                this.map(Types.BLOCK_POSITION1_8);
                this.map((Type)Types.BYTE, (Type)Types.UNSIGNED_BYTE);
                this.handler(wrapper -> {
                    int entityId = (Integer)wrapper.get((Type)Types.VAR_INT, 0);
                    wrapper.user().getEntityTracker(Protocol1_9To1_8.class).addEntity(entityId, (EntityType)EntityTypes1_9.EntityType.PAINTING);
                });
            }
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.ADD_PLAYER, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT);
                this.map(Types.UUID);
                this.map((Type)Types.DOUBLE, Protocol1_9To1_8.DOUBLE_TO_INT_TIMES_32);
                this.map((Type)Types.DOUBLE, Protocol1_9To1_8.DOUBLE_TO_INT_TIMES_32);
                this.map((Type)Types.DOUBLE, Protocol1_9To1_8.DOUBLE_TO_INT_TIMES_32);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.BYTE);
                this.create((Type)Types.SHORT, (short)0);
                this.map(Types.ENTITY_DATA_LIST1_9, Types.ENTITY_DATA_LIST1_8);
                this.handler(EntityPacketRewriter1_9.this.getTrackerAndDataHandler(Types.ENTITY_DATA_LIST1_8, (EntityType)EntityTypes1_9.EntityType.PLAYER));
            }
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.ENTITY_EVENT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.INT);
                this.handler(wrapper -> {
                    byte status = (Byte)wrapper.read((Type)Types.BYTE);
                    if (status > 23) {
                        wrapper.cancel();
                        return;
                    }
                    wrapper.write((Type)Types.BYTE, (Object)status);
                });
            }
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.MOVE_ENTITY_POS, wrapper -> {
            int entityId = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
            short deltaX = (Short)wrapper.read((Type)Types.SHORT);
            short deltaY = (Short)wrapper.read((Type)Types.SHORT);
            short deltaZ = (Short)wrapper.read((Type)Types.SHORT);
            Vector[] moves = RelativeMoveUtil.calculateRelativeMoves(wrapper.user(), entityId, deltaX, deltaY, deltaZ);
            wrapper.write((Type)Types.BYTE, (Object)((byte)moves[0].blockX()));
            wrapper.write((Type)Types.BYTE, (Object)((byte)moves[0].blockY()));
            wrapper.write((Type)Types.BYTE, (Object)((byte)moves[0].blockZ()));
            boolean onGround = (Boolean)wrapper.passthrough((Type)Types.BOOLEAN);
            if (moves.length > 1) {
                PacketWrapper secondPacket = PacketWrapper.create((PacketType)ClientboundPackets1_8.MOVE_ENTITY_POS, (UserConnection)wrapper.user());
                secondPacket.write((Type)Types.VAR_INT, (Object)entityId);
                secondPacket.write((Type)Types.BYTE, (Object)((byte)moves[1].blockX()));
                secondPacket.write((Type)Types.BYTE, (Object)((byte)moves[1].blockY()));
                secondPacket.write((Type)Types.BYTE, (Object)((byte)moves[1].blockZ()));
                secondPacket.write((Type)Types.BOOLEAN, (Object)onGround);
                secondPacket.scheduleSend(Protocol1_9To1_8.class);
            }
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.MOVE_ENTITY_POS_ROT, wrapper -> {
            int entityId = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
            short deltaX = (Short)wrapper.read((Type)Types.SHORT);
            short deltaY = (Short)wrapper.read((Type)Types.SHORT);
            short deltaZ = (Short)wrapper.read((Type)Types.SHORT);
            Vector[] moves = RelativeMoveUtil.calculateRelativeMoves(wrapper.user(), entityId, deltaX, deltaY, deltaZ);
            wrapper.write((Type)Types.BYTE, (Object)((byte)moves[0].blockX()));
            wrapper.write((Type)Types.BYTE, (Object)((byte)moves[0].blockY()));
            wrapper.write((Type)Types.BYTE, (Object)((byte)moves[0].blockZ()));
            byte yaw = (Byte)wrapper.passthrough((Type)Types.BYTE);
            byte pitch = (Byte)wrapper.passthrough((Type)Types.BYTE);
            boolean onGround = (Boolean)wrapper.passthrough((Type)Types.BOOLEAN);
            EntityType type = wrapper.user().getEntityTracker(Protocol1_9To1_8.class).entityType(entityId);
            if (type == EntityTypes1_9.EntityType.BOAT) {
                yaw = (byte)(yaw - 64);
                wrapper.set((Type)Types.BYTE, 3, (Object)yaw);
            }
            if (moves.length > 1) {
                PacketWrapper secondPacket = PacketWrapper.create((PacketType)ClientboundPackets1_8.MOVE_ENTITY_POS_ROT, (UserConnection)wrapper.user());
                secondPacket.write((Type)Types.VAR_INT, (Object)entityId);
                secondPacket.write((Type)Types.BYTE, (Object)((byte)moves[1].blockX()));
                secondPacket.write((Type)Types.BYTE, (Object)((byte)moves[1].blockY()));
                secondPacket.write((Type)Types.BYTE, (Object)((byte)moves[1].blockZ()));
                secondPacket.write((Type)Types.BYTE, (Object)yaw);
                secondPacket.write((Type)Types.BYTE, (Object)pitch);
                secondPacket.write((Type)Types.BOOLEAN, (Object)onGround);
                secondPacket.scheduleSend(Protocol1_9To1_8.class);
            }
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.MOVE_ENTITY_ROT, wrapper -> {
            int entityId = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
            EntityType type = wrapper.user().getEntityTracker(Protocol1_9To1_8.class).entityType(entityId);
            if (type == EntityTypes1_9.EntityType.BOAT) {
                byte yaw = (Byte)wrapper.read((Type)Types.BYTE);
                yaw = (byte)(yaw - 64);
                wrapper.write((Type)Types.BYTE, (Object)yaw);
            }
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.MOVE_VEHICLE, (ClientboundPacketType)ClientboundPackets1_8.TELEPORT_ENTITY, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.handler(wrapper -> {
                    EntityTracker1_9 tracker = (EntityTracker1_9)wrapper.user().getEntityTracker(Protocol1_9To1_8.class);
                    Integer vehicle = tracker.getVehicle(tracker.clientEntityId());
                    if (vehicle == null) {
                        wrapper.cancel();
                    } else {
                        wrapper.write((Type)Types.VAR_INT, (Object)vehicle);
                    }
                });
                this.map((Type)Types.DOUBLE, Protocol1_9To1_8.DOUBLE_TO_INT_TIMES_32);
                this.map((Type)Types.DOUBLE, Protocol1_9To1_8.DOUBLE_TO_INT_TIMES_32);
                this.map((Type)Types.DOUBLE, Protocol1_9To1_8.DOUBLE_TO_INT_TIMES_32);
                this.map((Type)Types.FLOAT, Protocol1_9To1_8.DEGREES_TO_ANGLE);
                this.map((Type)Types.FLOAT, Protocol1_9To1_8.DEGREES_TO_ANGLE);
                this.handler(wrapper -> {
                    if (wrapper.isCancelled()) {
                        return;
                    }
                    PlayerPositionTracker storage = (PlayerPositionTracker)wrapper.user().get(PlayerPositionTracker.class);
                    double x = (double)((Integer)wrapper.get((Type)Types.INT, 0)).intValue() / 32.0;
                    double y = (double)((Integer)wrapper.get((Type)Types.INT, 1)).intValue() / 32.0;
                    double z = (double)((Integer)wrapper.get((Type)Types.INT, 2)).intValue() / 32.0;
                    storage.setPos(x, y, z);
                });
                this.create((Type)Types.BOOLEAN, true);
                this.handler(wrapper -> {
                    if (wrapper.isCancelled()) {
                        return;
                    }
                    int entityId = (Integer)wrapper.get((Type)Types.VAR_INT, 0);
                    EntityType type = wrapper.user().getEntityTracker(Protocol1_9To1_8.class).entityType(entityId);
                    if (type == EntityTypes1_9.EntityType.BOAT) {
                        byte yaw = (Byte)wrapper.get((Type)Types.BYTE, 0);
                        yaw = (byte)(yaw - 64);
                        wrapper.set((Type)Types.BYTE, 0, (Object)yaw);
                        int y = (Integer)wrapper.get((Type)Types.INT, 1);
                        wrapper.set((Type)Types.INT, 1, (Object)(y += 6));
                    }
                });
            }
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.REMOVE_MOB_EFFECT, wrapper -> {
            int entityId = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
            byte effectId = (Byte)wrapper.passthrough((Type)Types.BYTE);
            if (effectId > 23) {
                wrapper.cancel();
            }
            EntityTracker1_9 tracker = (EntityTracker1_9)wrapper.user().getEntityTracker(Protocol1_9To1_8.class);
            if (effectId == 25 && entityId == tracker.clientEntityId()) {
                ((LevitationStorage)wrapper.user().get(LevitationStorage.class)).setActive(false);
            }
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.SET_ENTITY_LINK, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.INT);
                this.map((Type)Types.INT);
                this.create((Type)Types.BOOLEAN, true);
            }
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.SET_EQUIPPED_ITEM, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT);
                this.handler(wrapper -> {
                    int slot = (Integer)wrapper.read((Type)Types.VAR_INT);
                    if (slot == 1) {
                        wrapper.cancel();
                    } else if (slot > 1) {
                        --slot;
                    }
                    wrapper.write((Type)Types.SHORT, (Object)((short)slot));
                });
                this.map(Types.ITEM1_8);
                this.handler(wrapper -> ((Protocol1_9To1_8)EntityPacketRewriter1_9.this.protocol).getItemRewriter().handleItemToClient(wrapper.user(), (Item)wrapper.get(Types.ITEM1_8, 0)));
            }
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.SET_PASSENGERS, null, wrapper -> {
            wrapper.cancel();
            EntityTracker1_9 tracker = (EntityTracker1_9)wrapper.user().getEntityTracker(Protocol1_9To1_8.class);
            int vehicle = (Integer)wrapper.read((Type)Types.VAR_INT);
            IntList oldPassengers = tracker.getPassengers(vehicle);
            IntArrayList passengers = new IntArrayList((int[])wrapper.read(Types.VAR_INT_ARRAY_PRIMITIVE));
            tracker.setPassengers(vehicle, (IntList)passengers);
            if (!oldPassengers.isEmpty()) {
                for (Integer passenger : oldPassengers) {
                    PacketWrapper detach = PacketWrapper.create((PacketType)ClientboundPackets1_8.SET_ENTITY_LINK, (UserConnection)wrapper.user());
                    detach.write((Type)Types.INT, (Object)passenger);
                    detach.write((Type)Types.INT, (Object)-1);
                    detach.write((Type)Types.BOOLEAN, (Object)false);
                    detach.scheduleSend(Protocol1_9To1_8.class);
                }
            }
            for (int i = 0; i < passengers.size(); ++i) {
                int attachedEntityId = passengers.getInt(i);
                int holdingEntityId = i == 0 ? vehicle : passengers.getInt(i - 1);
                PacketWrapper attach = PacketWrapper.create((PacketType)ClientboundPackets1_8.SET_ENTITY_LINK, (UserConnection)wrapper.user());
                attach.write((Type)Types.INT, (Object)attachedEntityId);
                attach.write((Type)Types.INT, (Object)holdingEntityId);
                attach.write((Type)Types.BOOLEAN, (Object)false);
                attach.scheduleSend(Protocol1_9To1_8.class);
            }
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.TELEPORT_ENTITY, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT);
                this.map((Type)Types.DOUBLE, Protocol1_9To1_8.DOUBLE_TO_INT_TIMES_32);
                this.map((Type)Types.DOUBLE, Protocol1_9To1_8.DOUBLE_TO_INT_TIMES_32);
                this.map((Type)Types.DOUBLE, Protocol1_9To1_8.DOUBLE_TO_INT_TIMES_32);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.BOOLEAN);
                this.handler(wrapper -> {
                    int entityId = (Integer)wrapper.get((Type)Types.VAR_INT, 0);
                    EntityTracker1_9 tracker = (EntityTracker1_9)wrapper.user().getEntityTracker(Protocol1_9To1_8.class);
                    if (tracker.entityType(entityId) == EntityTypes1_9.EntityType.BOAT) {
                        byte yaw = (Byte)wrapper.get((Type)Types.BYTE, 0);
                        yaw = (byte)(yaw - 64);
                        wrapper.set((Type)Types.BYTE, 0, (Object)yaw);
                        int y = (Integer)wrapper.get((Type)Types.INT, 1);
                        wrapper.set((Type)Types.INT, 1, (Object)(y += 6));
                    }
                    tracker.resetEntityOffset(entityId);
                });
            }
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.UPDATE_ATTRIBUTES, wrapper -> {
            EntityTracker1_9 tracker;
            int entityId = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
            boolean player = entityId == (tracker = (EntityTracker1_9)wrapper.user().getEntityTracker(Protocol1_9To1_8.class)).clientEntityId();
            int removed = 0;
            int size = (Integer)wrapper.passthrough((Type)Types.INT);
            for (int i = 0; i < size; ++i) {
                String key = (String)wrapper.read(Types.STRING);
                double value = (Double)wrapper.read((Type)Types.DOUBLE);
                int modifierSize = (Integer)wrapper.read((Type)Types.VAR_INT);
                boolean valid = ((Protocol1_9To1_8)this.protocol).getItemRewriter().VALID_ATTRIBUTES.contains(key);
                if (valid) {
                    wrapper.write(Types.STRING, (Object)key);
                    wrapper.write((Type)Types.DOUBLE, (Object)value);
                    wrapper.write((Type)Types.VAR_INT, (Object)modifierSize);
                }
                ArrayList<Pair<Byte, Double>> modifiers = new ArrayList<Pair<Byte, Double>>();
                for (int j = 0; j < modifierSize; ++j) {
                    UUID modifierId = (UUID)wrapper.read(Types.UUID);
                    double amount = (Double)wrapper.read((Type)Types.DOUBLE);
                    byte operation = (Byte)wrapper.read((Type)Types.BYTE);
                    if (valid) {
                        wrapper.write(Types.UUID, (Object)modifierId);
                        wrapper.write((Type)Types.DOUBLE, (Object)amount);
                        wrapper.write((Type)Types.BYTE, (Object)operation);
                    }
                    modifiers.add((Pair<Byte, Double>)new Pair((Object)operation, (Object)amount));
                }
                if (valid) continue;
                if (player && key.equals("generic.attackSpeed")) {
                    ((CooldownStorage)wrapper.user().get(CooldownStorage.class)).setAttackSpeed(value, modifiers);
                }
                ++removed;
            }
            wrapper.set((Type)Types.INT, 0, (Object)(size - removed));
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.UPDATE_MOB_EFFECT, wrapper -> {
            int entityId = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
            byte effectId = (Byte)wrapper.passthrough((Type)Types.BYTE);
            byte amplifier = (Byte)wrapper.passthrough((Type)Types.BYTE);
            if (effectId > 23) {
                wrapper.cancel();
            }
            EntityTracker1_9 tracker = (EntityTracker1_9)wrapper.user().getEntityTracker(Protocol1_9To1_8.class);
            if (effectId == 25 && entityId == tracker.clientEntityId()) {
                LevitationStorage levitation = (LevitationStorage)wrapper.user().get(LevitationStorage.class);
                levitation.setActive(true);
                levitation.setAmplifier(amplifier);
            }
        });
    }

    protected void registerRewrites() {
        this.mapEntityTypeWithData((EntityType)EntityTypes1_9.EntityType.SHULKER, (EntityType)EntityTypes1_9.EntityType.MAGMA_CUBE).plainName();
        this.mapEntityTypeWithData((EntityType)EntityTypes1_9.EntityType.SHULKER_BULLET, (EntityType)EntityTypes1_9.EntityType.WITCH).plainName();
        this.filter().handler(this::handleEntityData);
    }

    private void handleEntityData(EntityDataHandlerEvent event, EntityData entityData) {
        EntityDataIndex1_9 metaIndex;
        EntityTracker1_9 tracker = (EntityTracker1_9)this.tracker(event.user());
        if (entityData.id() == EntityDataIndex1_9.ENTITY_STATUS.getIndex()) {
            tracker.getStatus().put(event.entityId(), (int)((Byte)entityData.value()).byteValue());
        }
        if ((metaIndex = EntityDataIndex1_8.searchIndex(event.entityType(), entityData.id())) == null) {
            event.cancel();
            return;
        }
        if (metaIndex.getOldType() == null || metaIndex.getNewType() == null) {
            if (metaIndex == EntityDataIndex1_9.PLAYER_HAND) {
                byte status = (byte)tracker.getStatus().getOrDefault(event.entityId(), 0);
                status = ((Byte)entityData.value() & 1) != 0 ? (byte)(status | 0x10) : (byte)(status & 0xFFFFFFEF);
                event.createExtraData(new EntityData(EntityDataIndex1_9.ENTITY_STATUS.getIndex(), (EntityDataType)EntityDataTypes1_8.BYTE, (Object)status));
            }
            event.cancel();
            return;
        }
        entityData.setId(metaIndex.getIndex());
        entityData.setDataTypeUnsafe((EntityDataType)metaIndex.getOldType());
        Object value = entityData.getValue();
        switch (metaIndex.getNewType()) {
            case BYTE: {
                if (metaIndex.getOldType() == EntityDataTypes1_8.BYTE) {
                    entityData.setValue(value);
                }
                if (metaIndex.getOldType() != EntityDataTypes1_8.INT) break;
                entityData.setValue((Object)((Byte)value).intValue());
                break;
            }
            case OPTIONAL_UUID: {
                if (metaIndex.getOldType() != EntityDataTypes1_8.STRING) {
                    event.cancel();
                    break;
                }
                UUID owner = (UUID)value;
                entityData.setValue((Object)(owner != null ? owner.toString() : ""));
                break;
            }
            case OPTIONAL_BLOCK_STATE: {
                event.cancel();
                event.createExtraData(new EntityData(metaIndex.getIndex(), (EntityDataType)EntityDataTypes1_8.SHORT, (Object)((Integer)value).shortValue()));
                break;
            }
            case VAR_INT: {
                if (metaIndex.getOldType() == EntityDataTypes1_8.BYTE) {
                    entityData.setValue((Object)((Integer)value).byteValue());
                }
                if (metaIndex.getOldType() == EntityDataTypes1_8.SHORT) {
                    entityData.setValue((Object)((Integer)value).shortValue());
                }
                if (metaIndex.getOldType() != EntityDataTypes1_8.INT) break;
                entityData.setValue(value);
                break;
            }
            case FLOAT: 
            case STRING: 
            case COMPONENT: {
                entityData.setValue(value);
                break;
            }
            case BOOLEAN: {
                boolean bool = (Boolean)value;
                if (metaIndex == EntityDataIndex1_9.ABSTRACT_AGEABLE_AGE) {
                    entityData.setValue((Object)((byte)(bool ? -1 : 0)));
                    break;
                }
                entityData.setValue((Object)((byte)(bool ? 1 : 0)));
                break;
            }
            case ITEM: {
                entityData.setValue((Object)((Protocol1_9To1_8)this.protocol).getItemRewriter().handleItemToClient(event.user(), (Item)value));
                break;
            }
            case BLOCK_POSITION: {
                BlockPosition position = (BlockPosition)value;
                entityData.setValue((Object)position);
                break;
            }
            case ROTATIONS: {
                EulerAngle angle = (EulerAngle)value;
                entityData.setValue((Object)angle);
                break;
            }
            default: {
                event.cancel();
            }
        }
    }

    public EntityTypes1_9.EntityType typeFromId(int type) {
        return EntityTypes1_9.EntityType.findById((int)type);
    }

    public EntityTypes1_9.EntityType objectTypeFromId(int type, int data) {
        return EntityTypes1_9.ObjectType.getEntityType((int)type, (int)data);
    }
}

