/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viarewind.protocol.v1_9to1_8.rewriter;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.StringTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viarewind.ViaRewind;
import com.viaversion.viarewind.protocol.v1_9to1_8.Protocol1_9To1_8;
import com.viaversion.viarewind.protocol.v1_9to1_8.data.EffectIdMappings1_8;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockPosition;
import com.viaversion.viaversion.api.minecraft.Environment;
import com.viaversion.viaversion.api.minecraft.chunks.BaseChunk;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSectionImpl;
import com.viaversion.viaversion.api.minecraft.chunks.DataPalette;
import com.viaversion.viaversion.api.minecraft.chunks.PaletteType;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.rewriter.RewriterBase;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.chunk.ChunkType1_8;
import com.viaversion.viaversion.api.type.types.chunk.ChunkType1_9_1;
import com.viaversion.viaversion.protocols.v1_8to1_9.packet.ClientboundPackets1_8;
import com.viaversion.viaversion.protocols.v1_8to1_9.packet.ClientboundPackets1_9;
import java.util.ArrayList;

public class WorldPacketRewriter1_9
extends RewriterBase<Protocol1_9To1_8> {
    public WorldPacketRewriter1_9(Protocol1_9To1_8 protocol) {
        super((Protocol)protocol);
    }

    protected void registerPackets() {
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.BLOCK_ENTITY_DATA, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Types.BLOCK_POSITION1_8);
                this.map((Type)Types.UNSIGNED_BYTE);
                this.map(Types.NAMED_COMPOUND_TAG);
                this.handler(wrapper -> {
                    CompoundTag spawnData;
                    Tag id;
                    CompoundTag tag = (CompoundTag)wrapper.get(Types.NAMED_COMPOUND_TAG, 0);
                    Tag patt2983$temp = tag.remove("SpawnData");
                    if (patt2983$temp instanceof CompoundTag && (id = (spawnData = (CompoundTag)patt2983$temp).remove("id")) instanceof StringTag) {
                        tag.put("EntityId", id);
                    }
                });
            }
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.BLOCK_EVENT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Types.BLOCK_POSITION1_8);
                this.map((Type)Types.UNSIGNED_BYTE);
                this.map((Type)Types.UNSIGNED_BYTE);
                this.map((Type)Types.VAR_INT);
                this.handler(wrapper -> {
                    int block = (Integer)wrapper.get((Type)Types.VAR_INT, 0);
                    if (block >= 219 && block <= 234) {
                        wrapper.set((Type)Types.VAR_INT, 0, (Object)130);
                    }
                });
            }
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.CUSTOM_SOUND, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Types.STRING);
                this.handler(wrapper -> {
                    String name = (String)wrapper.get(Types.STRING, 0);
                    name = ((Protocol1_9To1_8)WorldPacketRewriter1_9.this.protocol).getMappingData().getMappedNamedSound(name);
                    if (name == null) {
                        wrapper.cancel();
                    } else {
                        wrapper.set(Types.STRING, 0, (Object)name);
                    }
                });
                this.read((Type)Types.VAR_INT);
                this.map((Type)Types.INT);
                this.map((Type)Types.INT);
                this.map((Type)Types.INT);
                this.map((Type)Types.FLOAT);
                this.map((Type)Types.UNSIGNED_BYTE);
            }
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.FORGET_LEVEL_CHUNK, (ClientboundPacketType)ClientboundPackets1_8.LEVEL_CHUNK, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.handler(wrapper -> {
                    Environment environment = wrapper.user().getClientWorld(Protocol1_9To1_8.class).getEnvironment();
                    int chunkX = (Integer)wrapper.read((Type)Types.INT);
                    int chunkZ = (Integer)wrapper.read((Type)Types.INT);
                    wrapper.write((Type)ChunkType1_8.forEnvironment((Environment)environment), (Object)new BaseChunk(chunkX, chunkZ, true, false, 0, new ChunkSection[16], null, new ArrayList()));
                });
            }
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.LEVEL_CHUNK, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.handler(wrapper -> {
                    Environment environment = wrapper.user().getClientWorld(Protocol1_9To1_8.class).getEnvironment();
                    Chunk chunk = (Chunk)wrapper.read((Type)ChunkType1_9_1.forEnvironment((Environment)environment));
                    for (ChunkSection section : chunk.getSections()) {
                        if (section == null) continue;
                        DataPalette palette = section.palette(PaletteType.BLOCKS);
                        for (int i = 0; i < palette.size(); ++i) {
                            int block = palette.idByIndex(i);
                            int replacedBlock = ((Protocol1_9To1_8)WorldPacketRewriter1_9.this.protocol).getItemRewriter().handleBlockId(block);
                            palette.setIdByIndex(i, replacedBlock);
                        }
                    }
                    if (chunk.isFullChunk() && chunk.getBitmask() == 0) {
                        boolean skylight = environment == Environment.NORMAL;
                        ChunkSection[] sections = new ChunkSection[16];
                        ChunkSectionImpl section = new ChunkSectionImpl(true);
                        sections[0] = section;
                        section.palette(PaletteType.BLOCKS).addId(0);
                        if (skylight) {
                            section.getLight().setSkyLight(new byte[2048]);
                        }
                        chunk = new BaseChunk(chunk.getX(), chunk.getZ(), true, false, 1, sections, chunk.getBiomeData(), chunk.getBlockEntities());
                    }
                    wrapper.write((Type)ChunkType1_8.forEnvironment((Environment)environment), (Object)chunk);
                    chunk.getBlockEntities().forEach(nbt -> {
                        short action;
                        String id;
                        if (!(nbt.contains("x") && nbt.contains("y") && nbt.contains("z") && nbt.contains("id"))) {
                            return;
                        }
                        BlockPosition position = new BlockPosition(((Integer)nbt.get("x").getValue()).intValue(), ((Integer)nbt.get("y").getValue()).intValue(), ((Integer)nbt.get("z").getValue()).intValue());
                        switch (id = (String)nbt.get("id").getValue()) {
                            case "minecraft:mob_spawner": {
                                action = 1;
                                break;
                            }
                            case "minecraft:command_block": {
                                action = 2;
                                break;
                            }
                            case "minecraft:beacon": {
                                action = 3;
                                break;
                            }
                            case "minecraft:skull": {
                                action = 4;
                                break;
                            }
                            case "minecraft:flower_pot": {
                                action = 5;
                                break;
                            }
                            case "minecraft:banner": {
                                action = 6;
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        PacketWrapper blockEntityData = PacketWrapper.create((PacketType)ClientboundPackets1_9.BLOCK_ENTITY_DATA, (UserConnection)wrapper.user());
                        blockEntityData.write(Types.BLOCK_POSITION1_8, (Object)position);
                        blockEntityData.write((Type)Types.UNSIGNED_BYTE, (Object)action);
                        blockEntityData.write(Types.NAMED_COMPOUND_TAG, nbt);
                        blockEntityData.scheduleSend(Protocol1_9To1_8.class, false);
                    });
                });
            }
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.LEVEL_EVENT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.INT);
                this.map(Types.BLOCK_POSITION1_8);
                this.map((Type)Types.INT);
                this.map((Type)Types.BOOLEAN);
                this.handler(wrapper -> {
                    int id = (Integer)wrapper.get((Type)Types.INT, 0);
                    if ((id = EffectIdMappings1_8.getOldId(id)) == -1) {
                        wrapper.cancel();
                        return;
                    }
                    wrapper.set((Type)Types.INT, 0, (Object)id);
                    if (id == 2001) {
                        int replacedBlock = ((Protocol1_9To1_8)WorldPacketRewriter1_9.this.protocol).getItemRewriter().handleBlockId((Integer)wrapper.get((Type)Types.INT, 1));
                        wrapper.set((Type)Types.INT, 1, (Object)replacedBlock);
                    }
                });
            }
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.LEVEL_PARTICLES, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.INT);
                this.handler(wrapper -> {
                    int id = (Integer)wrapper.get((Type)Types.INT, 0);
                    if (id > 41 && !ViaRewind.getConfig().isReplaceParticles()) {
                        wrapper.cancel();
                        return;
                    }
                    if (id == 42) {
                        wrapper.set((Type)Types.INT, 0, (Object)24);
                    } else if (id == 43) {
                        wrapper.set((Type)Types.INT, 0, (Object)3);
                    } else if (id == 44) {
                        wrapper.set((Type)Types.INT, 0, (Object)34);
                    } else if (id == 45) {
                        wrapper.set((Type)Types.INT, 0, (Object)1);
                    }
                });
            }
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.MAP_ITEM_DATA, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT);
                this.map((Type)Types.BYTE);
                this.read((Type)Types.BOOLEAN);
            }
        });
        ((Protocol1_9To1_8)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_9.SOUND, (ClientboundPacketType)ClientboundPackets1_8.CUSTOM_SOUND, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.handler(wrapper -> {
                    int soundId = (Integer)wrapper.read((Type)Types.VAR_INT);
                    int mappedSoundId = ((Protocol1_9To1_8)WorldPacketRewriter1_9.this.protocol).getMappingData().getFullSoundMappings().getNewId(soundId);
                    if (mappedSoundId == -1) {
                        wrapper.cancel();
                    } else {
                        wrapper.write(Types.STRING, (Object)((Protocol1_9To1_8)WorldPacketRewriter1_9.this.protocol).getMappingData().getFullSoundMappings().mappedIdentifier(mappedSoundId));
                    }
                });
                this.read((Type)Types.VAR_INT);
                this.map((Type)Types.INT);
                this.map((Type)Types.INT);
                this.map((Type)Types.INT);
                this.map((Type)Types.FLOAT);
                this.map((Type)Types.UNSIGNED_BYTE);
            }
        });
    }
}

