/*
 * Decompiled with CFR 0.152.
 */
package com.procurer.commands;

import com.procurer.enums.StratagemType;
import com.procurer.managers.StratagemManager;
import com.procurer.stratagems.AbstractStratagem;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class StratagemCommand
implements CommandExecutor {
    private final StratagemManager stratagemManager;

    public StratagemCommand(StratagemManager stratagemManager) {
        this.stratagemManager = stratagemManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            sender.sendMessage(Component.text((String)"This command can only be used by players!").color((TextColor)NamedTextColor.RED));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.showHelp(player);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "list": {
                this.showStratagemList(player);
                break;
            }
            case "give": {
                this.handleGiveCommand(player, args);
                break;
            }
            case "info": {
                this.handleInfoCommand(player, args);
                break;
            }
            case "help": {
                this.showHelp(player);
                break;
            }
            default: {
                player.sendMessage(Component.text((String)("Unknown subcommand: " + subCommand)).color((TextColor)NamedTextColor.RED));
                this.showHelp(player);
            }
        }
        return true;
    }

    private void showHelp(Player player) {
        player.sendMessage(Component.text((String)"=== Stratagems Commands ===").color((TextColor)NamedTextColor.GOLD));
        player.sendMessage(((TextComponent)Component.text((String)"/stratagems list").color((TextColor)NamedTextColor.YELLOW)).append(Component.text((String)" - List all available stratagems").color((TextColor)NamedTextColor.GRAY)));
        player.sendMessage(((TextComponent)Component.text((String)"/stratagems give <type>").color((TextColor)NamedTextColor.YELLOW)).append(Component.text((String)" - Give yourself a stratagem").color((TextColor)NamedTextColor.GRAY)));
        player.sendMessage(((TextComponent)Component.text((String)"/stratagems info <type>").color((TextColor)NamedTextColor.YELLOW)).append(Component.text((String)" - Show stratagem information").color((TextColor)NamedTextColor.GRAY)));
        player.sendMessage(Component.text((String)"Craft stratagems: Snowball + TNT \u2192 Orbital Precision Strike").color((TextColor)NamedTextColor.GREEN));
    }

    private void showStratagemList(Player player) {
        player.sendMessage(Component.text((String)"=== Available Stratagems ===").color((TextColor)NamedTextColor.GOLD));
        for (AbstractStratagem stratagem : this.stratagemManager.getAllStratagems()) {
            StratagemType type = stratagem.getType();
            Component line = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"\u2022 ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)type.getDisplayName()).color((TextColor)type.getNameColor()))).append((Component)Component.space())).append(Component.text((String)("[" + type.getUsage().getDisplayName() + "]")).color((TextColor)NamedTextColor.GRAY));
            player.sendMessage(line);
        }
    }

    private void handleGiveCommand(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(Component.text((String)"Usage: /stratagems give <type>").color((TextColor)NamedTextColor.RED));
            return;
        }
        String typeName = args[1];
        StratagemType type = StratagemType.fromString(typeName);
        if (type == null) {
            player.sendMessage(Component.text((String)("Unknown stratagem type: " + typeName)).color((TextColor)NamedTextColor.RED));
            return;
        }
        if (!player.isOp() && !player.hasPermission("stratagems.give")) {
            player.sendMessage(Component.text((String)"You don't have permission to use this command!").color((TextColor)NamedTextColor.RED));
            return;
        }
        ItemStack stratagemItem = this.stratagemManager.createStratagemItem(type);
        if (stratagemItem == null) {
            player.sendMessage(Component.text((String)"Failed to create stratagem item!").color((TextColor)NamedTextColor.RED));
            return;
        }
        player.getInventory().addItem(new ItemStack[]{stratagemItem});
        player.sendMessage(((TextComponent)Component.text((String)"Given: ").color((TextColor)NamedTextColor.GREEN)).append(Component.text((String)type.getDisplayName()).color((TextColor)type.getNameColor())));
    }

    private void handleInfoCommand(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(Component.text((String)"Usage: /stratagems info <type>").color((TextColor)NamedTextColor.RED));
            return;
        }
        String typeName = args[1];
        StratagemType type = StratagemType.fromString(typeName);
        if (type == null) {
            player.sendMessage(Component.text((String)("Unknown stratagem type: " + typeName)).color((TextColor)NamedTextColor.RED));
            return;
        }
        AbstractStratagem stratagem = this.stratagemManager.getStratagem(type);
        if (stratagem == null) {
            player.sendMessage(Component.text((String)"Stratagem not available!").color((TextColor)NamedTextColor.RED));
            return;
        }
        player.sendMessage(Component.text((String)("=== " + type.getDisplayName() + " ===")).color((TextColor)type.getNameColor()));
        player.sendMessage(Component.text((String)type.getDescription()).color((TextColor)NamedTextColor.GRAY));
        player.sendMessage(Component.text((String)("Delay: " + type.getDelayMillis() / 1000L + " seconds")).color((TextColor)NamedTextColor.YELLOW));
        player.sendMessage(Component.text((String)("Usage: " + type.getUsage().getDisplayName())).color((TextColor)NamedTextColor.YELLOW));
        player.sendMessage(Component.text((String)type.getUsage().getDetails()).color((TextColor)NamedTextColor.GRAY));
    }
}

