/*
 * Decompiled with CFR 0.152.
 */
package com.procurer.enums;

import com.procurer.enums.StratagemUsage;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Material;

public enum StratagemType {
    ORBITAL_PRECISION_STRIKE("Orbital Precision Strike", "A single precise shot from orbit that delivers devastating damage to a targeted area.", Material.SNOWBALL, NamedTextColor.RED, false, 3000L, StratagemUsage.CONSUMABLE),
    EAGLE_NAPALM_AIRSTRIKE("Eagle Napalm Airstrike", "A barrage of napalm bombs creating a wall of fire that damages enemies over time.", Material.SNOWBALL, NamedTextColor.GOLD, true, 2000L, StratagemUsage.CONSUMABLE),
    EAGLE_500KG_BOMB("Eagle 500KG Bomb", "A massive 500kg bomb that embeds before detonating with devastating power. Clear the area!", Material.SNOWBALL, NamedTextColor.DARK_RED, true, 3500L, StratagemUsage.CONSUMABLE),
    GATLING_SENTRY("Gatling Sentry", "Orbital drop a Gatling sentry turret that automatically engages nearby hostiles until its ammo is spent.", Material.SNOWBALL, NamedTextColor.AQUA, false, 2500L, StratagemUsage.CONSUMABLE),
    ARTILLERY_120MM_HE_BARRAGE("120MM HE Barrage", "Sustained artillery barrage with multiple high-explosive shells covering a wide area over time.", Material.SNOWBALL, NamedTextColor.YELLOW, false, 4000L, StratagemUsage.CONSUMABLE);

    private final String displayName;
    private final String description;
    private final Material itemMaterial;
    private final NamedTextColor nameColor;
    private final boolean isEagle;
    private final long delayMillis;
    private final StratagemUsage usage;

    private StratagemType(String displayName, String description, Material itemMaterial, NamedTextColor nameColor, boolean isEagle, long delayMillis, StratagemUsage usage) {
        this.displayName = displayName;
        this.description = description;
        this.itemMaterial = itemMaterial;
        this.nameColor = nameColor;
        this.isEagle = isEagle;
        this.delayMillis = delayMillis;
        this.usage = usage;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public Material getItemMaterial() {
        return this.itemMaterial;
    }

    public NamedTextColor getNameColor() {
        return this.nameColor;
    }

    public long getDelayMillis() {
        return this.delayMillis;
    }

    public boolean isEagle() {
        return this.isEagle;
    }

    public StratagemUsage getUsage() {
        return this.usage;
    }

    public static StratagemType fromString(String name) {
        for (StratagemType type : StratagemType.values()) {
            if (!type.name().equalsIgnoreCase(name) && !type.getDisplayName().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }
}

