/*
 * Decompiled with CFR 0.152.
 */
package com.procurer.listeners;

import com.procurer.enums.StratagemType;
import com.procurer.managers.StratagemManager;
import com.procurer.stratagems.AbstractStratagem;
import com.procurer.stratagems.Artillery120MMHEBarrage;
import com.procurer.stratagems.Eagle500KGBomb;
import com.procurer.stratagems.EagleNapalmAirstrike;
import com.procurer.stratagems.OrbitalPrecisionStrike;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.projectiles.ProjectileSource;

public class StratagemListener
implements Listener {
    private final JavaPlugin plugin;
    private final StratagemManager stratagemManager;

    public StratagemListener(JavaPlugin plugin, StratagemManager stratagemManager) {
        this.plugin = plugin;
        this.stratagemManager = stratagemManager;
        this.registerCraftingRecipes();
    }

    private void registerCraftingRecipes() {
        NamespacedKey opsKey = new NamespacedKey((Plugin)this.plugin, "orbital_precision_strike");
        ItemStack opsResult = this.stratagemManager.createStratagemItem(StratagemType.ORBITAL_PRECISION_STRIKE);
        if (opsResult == null) {
            this.plugin.getLogger().severe("Failed to create Orbital Precision Strike item!");
            return;
        }
        ShapelessRecipe opsRecipe = new ShapelessRecipe(opsKey, opsResult);
        opsRecipe.addIngredient(Material.SNOWBALL);
        opsRecipe.addIngredient(Material.TNT);
        try {
            this.plugin.getServer().addRecipe((Recipe)opsRecipe);
            this.plugin.getLogger().info("Registered Orbital Precision Strike crafting recipe");
        }
        catch (IllegalStateException e) {
            this.plugin.getLogger().warning("Failed to register Orbital Precision Strike recipe: " + e.getMessage());
        }
        NamespacedKey enasKey = new NamespacedKey((Plugin)this.plugin, "eagle_napalm_airstrike");
        ItemStack enasResult = this.stratagemManager.createStratagemItem(StratagemType.EAGLE_NAPALM_AIRSTRIKE);
        if (enasResult == null) {
            this.plugin.getLogger().severe("Failed to create Eagle Napalm Airstrike item!");
            return;
        }
        ShapelessRecipe enasRecipe = new ShapelessRecipe(enasKey, enasResult);
        enasRecipe.addIngredient(Material.FIRE_CHARGE);
        enasRecipe.addIngredient(Material.TNT);
        try {
            this.plugin.getServer().addRecipe((Recipe)enasRecipe);
            this.plugin.getLogger().info("Registered Eagle Napalm Airstrike crafting recipe");
        }
        catch (IllegalStateException e) {
            this.plugin.getLogger().warning("Failed to register Eagle Napalm Airstrike recipe: " + e.getMessage());
        }
        NamespacedKey e500kgKey = new NamespacedKey((Plugin)this.plugin, "eagle_500kg_bomb");
        ItemStack e500kgResult = this.stratagemManager.createStratagemItem(StratagemType.EAGLE_500KG_BOMB);
        if (e500kgResult == null) {
            this.plugin.getLogger().severe("Failed to create Eagle 500KG Bomb item!");
            return;
        }
        ShapelessRecipe e500kgRecipe = new ShapelessRecipe(e500kgKey, e500kgResult);
        e500kgRecipe.addIngredient(Material.TNT);
        e500kgRecipe.addIngredient(Material.TNT);
        e500kgRecipe.addIngredient(Material.GUNPOWDER);
        try {
            this.plugin.getServer().addRecipe((Recipe)e500kgRecipe);
            this.plugin.getLogger().info("Registered Eagle 500KG Bomb crafting recipe");
        }
        catch (IllegalStateException e) {
            this.plugin.getLogger().warning("Failed to register Eagle 500KG Bomb recipe: " + e.getMessage());
        }
        NamespacedKey gatlingKey = new NamespacedKey((Plugin)this.plugin, "gatling_sentry");
        ItemStack gatlingResult = this.stratagemManager.createStratagemItem(StratagemType.GATLING_SENTRY);
        if (gatlingResult == null) {
            this.plugin.getLogger().severe("Failed to create Gatling Sentry item!");
            return;
        }
        ShapelessRecipe gatlingRecipe = new ShapelessRecipe(gatlingKey, gatlingResult);
        gatlingRecipe.addIngredient(Material.DISPENSER);
        gatlingRecipe.addIngredient(Material.IRON_BLOCK);
        gatlingRecipe.addIngredient(Material.REDSTONE_TORCH);
        gatlingRecipe.addIngredient(Material.GUNPOWDER);
        try {
            this.plugin.getServer().addRecipe((Recipe)gatlingRecipe);
            this.plugin.getLogger().info("Registered Gatling Sentry crafting recipe");
        }
        catch (IllegalStateException e) {
            this.plugin.getLogger().warning("Failed to register Gatling Sentry recipe: " + e.getMessage());
        }
        NamespacedKey artilleryKey = new NamespacedKey((Plugin)this.plugin, "artillery_120mm_he_barrage");
        ItemStack artilleryResult = this.stratagemManager.createStratagemItem(StratagemType.ARTILLERY_120MM_HE_BARRAGE);
        if (artilleryResult == null) {
            this.plugin.getLogger().severe("Failed to create 120MM HE Barrage item!");
            return;
        }
        ShapelessRecipe artilleryRecipe = new ShapelessRecipe(artilleryKey, artilleryResult);
        artilleryRecipe.addIngredient(Material.TNT);
        artilleryRecipe.addIngredient(Material.IRON_INGOT);
        artilleryRecipe.addIngredient(Material.GUNPOWDER);
        artilleryRecipe.addIngredient(Material.GUNPOWDER);
        try {
            this.plugin.getServer().addRecipe((Recipe)artilleryRecipe);
            this.plugin.getLogger().info("Registered 120MM HE Barrage crafting recipe");
        }
        catch (IllegalStateException e) {
            this.plugin.getLogger().warning("Failed to register 120MM HE Barrage recipe: " + e.getMessage());
        }
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        Recipe recipe = event.getRecipe();
        ItemStack result = recipe.getResult();
        StratagemType stratagemType = this.stratagemManager.getStratagemType(result);
        if (stratagemType == null) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        player.sendMessage(((TextComponent)Component.text((String)"Stratagem crafted: ").color((TextColor)NamedTextColor.GREEN)).append(Component.text((String)stratagemType.getDisplayName()).color((TextColor)stratagemType.getNameColor())));
        this.plugin.getLogger().info(player.getName() + " crafted a " + stratagemType.getDisplayName());
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        Projectile projectile = event.getEntity();
        if (!(projectile instanceof Snowball)) {
            return;
        }
        Snowball snowball = (Snowball)projectile;
        ProjectileSource projectileSource = snowball.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player player = (Player)projectileSource;
        ItemStack item = snowball.getItem();
        StratagemType stratagemType = this.stratagemManager.getStratagemType(item);
        if (stratagemType == null) {
            return;
        }
        AbstractStratagem stratagem = this.stratagemManager.getStratagem(stratagemType);
        if (stratagem == null) {
            player.sendMessage(Component.text((String)"Stratagem not available!").color((TextColor)NamedTextColor.RED));
            return;
        }
        Location impactLocation = event.getHitBlock() != null ? event.getHitBlock().getLocation().add(0.5, 1.0, 0.5) : (event.getHitEntity() != null ? event.getHitEntity().getLocation() : snowball.getLocation());
        stratagem.execute(impactLocation, player);
        player.sendMessage(((TextComponent)Component.text((String)"Stratagem deployed: ").color((TextColor)NamedTextColor.YELLOW)).append(Component.text((String)stratagemType.getDisplayName()).color((TextColor)stratagemType.getNameColor())));
        this.plugin.getLogger().info(player.getName() + " deployed " + stratagemType.getDisplayName() + " at " + impactLocation.getBlockX() + ", " + impactLocation.getBlockY() + ", " + impactLocation.getBlockZ());
    }

    @EventHandler
    public void onItemSpawn(ItemSpawnEvent event) {
        Item item = event.getEntity();
        if (OrbitalPrecisionStrike.shouldPreventItemDrop(item.getLocation()) || EagleNapalmAirstrike.shouldPreventItemDrop(item.getLocation()) || Eagle500KGBomb.shouldPreventItemDrop(item.getLocation()) || Artillery120MMHEBarrage.shouldPreventItemDrop(item.getLocation())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        FallingBlock fallingBlock;
        Component customName;
        Entity entity = event.getEntity();
        if (entity instanceof FallingBlock && (customName = (fallingBlock = (FallingBlock)entity).customName()) != null && Component.text((String)"\u00a77Debris").equals((Object)customName)) {
            event.setCancelled(true);
            Location landingSpot = event.getBlock().getLocation();
            if (landingSpot.getWorld() != null) {
                landingSpot.getWorld().spawnParticle(Particle.SMOKE, landingSpot.add(0.5, 0.5, 0.5), 3, 0.1, 0.1, 0.1, 0.05);
                landingSpot.getWorld().spawnParticle(Particle.DUST, landingSpot, 2, 0.1, 0.1, 0.1, 0.0, (Object)new Particle.DustOptions(Color.GRAY, 1.0f));
            }
            fallingBlock.remove();
        }
    }
}

