/*
 * Decompiled with CFR 0.152.
 */
package com.procurer.managers;

import com.procurer.enums.StratagemType;
import com.procurer.stratagems.AbstractStratagem;
import com.procurer.stratagems.Artillery120MMHEBarrage;
import com.procurer.stratagems.Eagle500KGBomb;
import com.procurer.stratagems.EagleNapalmAirstrike;
import com.procurer.stratagems.GatlingSentryStratagem;
import com.procurer.stratagems.OrbitalPrecisionStrike;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class StratagemManager {
    private final JavaPlugin plugin;
    private final Map<StratagemType, AbstractStratagem> stratagems;
    private final NamespacedKey stratagemKey;

    public StratagemManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.stratagems = new HashMap<StratagemType, AbstractStratagem>();
        this.stratagemKey = new NamespacedKey((Plugin)plugin, "stratagem_type");
    }

    public void loadStratagems() {
        this.registerStratagem(new OrbitalPrecisionStrike(this.plugin));
        this.registerStratagem(new EagleNapalmAirstrike(this.plugin));
        this.registerStratagem(new Eagle500KGBomb(this.plugin));
        this.registerStratagem(new GatlingSentryStratagem(this.plugin));
        this.registerStratagem(new Artillery120MMHEBarrage(this.plugin));
        this.plugin.getLogger().info("Loaded " + this.stratagems.size() + " stratagems for Super Earth!");
    }

    public void registerStratagem(AbstractStratagem stratagem) {
        this.stratagems.put(stratagem.getType(), stratagem);
        this.plugin.getLogger().info("Registered stratagem: " + stratagem.getDisplayName());
    }

    public AbstractStratagem getStratagem(StratagemType type) {
        return this.stratagems.get((Object)type);
    }

    public Collection<AbstractStratagem> getAllStratagems() {
        return this.stratagems.values();
    }

    public ItemStack createStratagemItem(StratagemType type) {
        AbstractStratagem stratagem = this.getStratagem(type);
        if (stratagem == null) {
            return null;
        }
        ItemStack item = new ItemStack(type.getItemMaterial());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            Component displayName = ((TextComponent)Component.text((String)type.getDisplayName()).color((TextColor)type.getNameColor())).decoration(TextDecoration.ITALIC, false);
            meta.displayName(displayName);
            ArrayList<Object> lore = new ArrayList<Object>();
            List<String> wrappedDescription = this.wrapText(type.getDescription(), 40);
            for (String line : wrappedDescription) {
                lore.add(((TextComponent)Component.text((String)line).color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false));
            }
            lore.add(Component.empty());
            lore.add(((TextComponent)Component.text((String)("Delay: " + type.getDelayMillis() / 1000L + "s")).color((TextColor)NamedTextColor.YELLOW)).decoration(TextDecoration.ITALIC, false));
            lore.add(((TextComponent)Component.text((String)("Usage: " + type.getUsage().getDisplayName())).color((TextColor)NamedTextColor.YELLOW)).decoration(TextDecoration.ITALIC, false));
            String usageDetails = type.getUsage().getDetails();
            if (!usageDetails.isEmpty()) {
                lore.add(((TextComponent)Component.text((String)usageDetails).color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false));
            }
            if (type.isEagle()) {
                lore.add(Component.empty());
                lore.add(((TextComponent)Component.text((String)"\u26a1 Eagle Stratagem").color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.ITALIC, false));
                lore.add(((TextComponent)Component.text((String)"Craft extras to stay stocked.").color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.ITALIC, false));
            }
            meta.lore(lore);
            meta.getPersistentDataContainer().set(this.stratagemKey, PersistentDataType.STRING, (Object)type.name());
            item.setItemMeta(meta);
        }
        return item;
    }

    public StratagemType getStratagemType(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        String typeString = (String)meta.getPersistentDataContainer().get(this.stratagemKey, PersistentDataType.STRING);
        if (typeString == null) {
            return null;
        }
        try {
            return StratagemType.valueOf(typeString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public void shutdown() {
        this.stratagems.clear();
    }

    private List<String> wrapText(String text, int maxLineLength) {
        ArrayList<String> lines = new ArrayList<String>();
        if (text.length() <= maxLineLength) {
            lines.add(text);
            return lines;
        }
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (currentLine.length() + word.length() + 1 > maxLineLength) {
                if (currentLine.length() > 0) {
                    lines.add(currentLine.toString());
                    currentLine = new StringBuilder();
                }
                if (word.length() > maxLineLength) {
                    lines.add(word);
                    continue;
                }
                currentLine.append(word);
                continue;
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }
}

