/*
 * Decompiled with CFR 0.152.
 */
package com.procurer.stratagems;

import com.procurer.Main;
import com.procurer.enums.StratagemType;
import com.procurer.managers.BlockRegenerationManager;
import com.procurer.stratagems.AbstractStratagem;
import com.procurer.utils.ExplosionEffectsUtils;
import com.procurer.utils.StratagemUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Artillery120MMHEBarrage
extends AbstractStratagem {
    private final BlockRegenerationManager blockRegenerationManager;
    private static final double EXPLOSION_POWER = 4.5;
    private static final double DAMAGE_MULTIPLIER = 3.0;
    private static final int SHELL_COUNT = 10;
    private static final double BARRAGE_RADIUS = 18.0;
    private static final int BARRAGE_DURATION_TICKS = 160;
    private static final int SHELL_HEIGHT = 70;
    private static final double SHELL_DAMAGE_RADIUS = 6.0;
    private static final Particle.DustOptions TARGETING_BEAM_COLOR = new Particle.DustOptions(Color.fromRGB((int)255, (int)165, (int)0), 2.0f);
    private static final Set<Location> itemDropPreventionZones = Collections.synchronizedSet(new HashSet());

    public Artillery120MMHEBarrage(JavaPlugin plugin) {
        super(plugin, StratagemType.ARTILLERY_120MM_HE_BARRAGE);
        this.blockRegenerationManager = ((Main)plugin).getBlockRegenerationManager();
    }

    @Override
    public void execute(final Location location, final Player player) {
        this.onActivation(location, player);
        new BukkitRunnable(this){
            final /* synthetic */ Artillery120MMHEBarrage this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.onImpact(location, player);
            }
        }.runTaskLater((Plugin)this.plugin, Math.max(1L, this.getDelayMillis() / 50L));
    }

    @Override
    protected void onActivation(Location location, Player player) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        world.playSound(location, Sound.BLOCK_BEACON_ACTIVATE, 2.0f, 0.6f);
        world.playSound(location, Sound.ENTITY_LIGHTNING_BOLT_THUNDER, 1.0f, 1.5f);
        this.createBarrageTargeting(location, player);
        this.broadcastBarrageWarning(location, player);
        player.sendMessage((Component)Component.text((String)"120MM HE Barrage inbound - danger close!", (TextColor)NamedTextColor.RED));
    }

    @Override
    protected void onImpact(Location location, Player player) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        this.addToItemDropPrevention(location);
        this.executeArtilleryBarrage(location, player);
    }

    private void createBarrageTargeting(final Location center, Player player) {
        final World world = center.getWorld();
        if (world == null) {
            return;
        }
        final long delayTicks = this.getDelayMillis() / 50L;
        new BukkitRunnable(this){
            int ticks = 0;
            final int maxTicks = (int)delayTicks;
            final /* synthetic */ Artillery120MMHEBarrage this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.ticks >= this.maxTicks || world == null) {
                    this.cancel();
                    return;
                }
                for (int y = 0; y < 40; ++y) {
                    Location particleLocation = center.clone().add(0.0, (double)y, 0.0);
                    world.spawnParticle(Particle.DUST, particleLocation, 5, 0.2, 0.2, 0.2, 0.0, (Object)TARGETING_BEAM_COLOR);
                    if (y % 4 != 0) continue;
                    world.spawnParticle(Particle.FLAME, particleLocation, 2, 0.1, 0.1, 0.1, 0.02);
                }
                this.this$0.createTargetingCircle(center, 10.799999999999999, Color.ORANGE, 1.8f);
                this.this$0.createTargetingCircle(center, 18.0, Color.RED, 1.4f);
                for (int i = 0; i < 8; ++i) {
                    double angle = Math.random() * Math.PI * 2.0;
                    double distance = Math.random() * 18.0 * 0.8;
                    double x = Math.cos(angle) * distance;
                    double z = Math.sin(angle) * distance;
                    Location impactIndicator = center.clone().add(x, 0.0, z);
                    world.spawnParticle(Particle.DUST, impactIndicator, 3, 0.2, 0.2, 0.2, 0.0, (Object)new Particle.DustOptions(Color.YELLOW, 1.0f));
                }
                if (this.ticks % 30 == 0) {
                    world.playSound(center, Sound.BLOCK_NOTE_BLOCK_BASS, 1.5f, 0.7f);
                    world.spawnParticle(Particle.FLASH, center, 1, 0.0, 0.0, 0.0, 0.0);
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 4L);
    }

    private void createTargetingCircle(Location center, double radius, Color color, float size) {
        World world = center.getWorld();
        if (world == null) {
            return;
        }
        int points = (int)(radius * 4.0);
        for (int i = 0; i < points; ++i) {
            double angle = (double)i * Math.PI * 2.0 / (double)points;
            double x = Math.cos(angle) * radius;
            double z = Math.sin(angle) * radius;
            Location circleLocation = center.clone().add(x, 0.0, z);
            circleLocation.setY((double)world.getHighestBlockYAt(circleLocation) + 0.1);
            world.spawnParticle(Particle.DUST, circleLocation, 2, 0.1, 0.1, 0.1, 0.0, (Object)new Particle.DustOptions(color, size));
        }
    }

    private void executeArtilleryBarrage(Location center, final Player player) {
        World world = center.getWorld();
        if (world == null) {
            return;
        }
        world.playSound(center, Sound.ENTITY_WITHER_SPAWN, 2.0f, 0.8f);
        final List<Location> impactLocations = this.generateShellImpactLocations(center);
        new BukkitRunnable(this){
            int shellsLaunched = 0;
            int tick = 0;
            final /* synthetic */ Artillery120MMHEBarrage this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.shellsLaunched >= 10 || this.tick >= 160) {
                    if (player != null && player.isOnline()) {
                        player.sendMessage((Component)Component.text((String)"Artillery barrage complete.", (TextColor)NamedTextColor.GRAY));
                    }
                    this.cancel();
                    return;
                }
                if ((this.tick % 16 == 0 || Math.random() < 0.3 && this.shellsLaunched < impactLocations.size()) && this.shellsLaunched < impactLocations.size()) {
                    Location impactLocation = (Location)impactLocations.get(this.shellsLaunched);
                    this.this$0.launchArtilleryShell(impactLocation, player);
                    ++this.shellsLaunched;
                }
                ++this.tick;
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 2L);
    }

    private List<Location> generateShellImpactLocations(Location center) {
        ArrayList<Location> locations = new ArrayList<Location>();
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            double angle = random.nextDouble() * Math.PI * 2.0;
            double distance = Math.sqrt(random.nextDouble()) * 18.0;
            double x = Math.cos(angle) * distance;
            double z = Math.sin(angle) * distance;
            Location impactLocation = center.clone().add(x, 0.0, z);
            impactLocation.setY((double)center.getWorld().getHighestBlockYAt(impactLocation));
            locations.add(impactLocation);
        }
        return locations;
    }

    private void launchArtilleryShell(final Location impactLocation, final Player player) {
        World world = impactLocation.getWorld();
        if (world == null) {
            return;
        }
        world.playSound(impactLocation.clone().add(0.0, 70.0, 0.0), Sound.ENTITY_FIREWORK_ROCKET_LAUNCH, 1.5f, 0.4f);
        this.createIncomingShellEffect(impactLocation);
        new BukkitRunnable(this){
            final /* synthetic */ Artillery120MMHEBarrage this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.executeShellImpact(impactLocation, player);
            }
        }.runTaskLater((Plugin)this.plugin, 40L);
    }

    private void createIncomingShellEffect(final Location impactLocation) {
        final World world = impactLocation.getWorld();
        if (world == null) {
            return;
        }
        Location shellStart = impactLocation.clone().add(0.0, 70.0, 0.0);
        final FallingBlock shell = world.spawnFallingBlock(shellStart, Material.IRON_BLOCK.createBlockData());
        shell.setVelocity(new Vector(0.0, -1.2, 0.0));
        shell.setDropItem(false);
        shell.setHurtEntities(false);
        shell.customName((Component)Component.text((String)"artillery_shell", (TextColor)NamedTextColor.GRAY));
        shell.setCustomNameVisible(false);
        new BukkitRunnable(this){
            int trails = 0;

            public void run() {
                if (!shell.isValid() || this.trails > 100) {
                    this.cancel();
                    return;
                }
                Location shellLoc = shell.getLocation();
                world.spawnParticle(Particle.SMOKE, shellLoc, 8, 0.3, 0.3, 0.3, 0.05);
                world.spawnParticle(Particle.FLAME, shellLoc, 4, 0.2, 0.2, 0.2, 0.02);
                world.spawnParticle(Particle.CRIT, shellLoc, 3, 0.1, 0.1, 0.1, 0.1);
                if (this.trails % 20 == 0) {
                    world.playSound(shellLoc, Sound.ENTITY_ARROW_SHOOT, 0.8f, 0.3f);
                }
                ++this.trails;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 2L);
        new BukkitRunnable(this){

            public void run() {
                if (shell.isValid()) {
                    shell.remove();
                    Block blockAtImpact = world.getBlockAt(impactLocation);
                    if (blockAtImpact.getType() == Material.IRON_BLOCK) {
                        blockAtImpact.setType(Material.AIR);
                    }
                }
            }
        }.runTaskLater((Plugin)this.plugin, 45L);
    }

    private void executeShellImpact(Location location, Player player) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        Set<Block> affectedBlocks = StratagemUtils.getAffectedBlocks(location, 4.5);
        this.blockRegenerationManager.storeBlocksForRegeneration(affectedBlocks);
        ExplosionEffectsUtils.createBlockBlastEffect(location, affectedBlocks, 4.5, this.plugin);
        world.createExplosion(location.getX(), location.getY(), location.getZ(), 4.5f, false, false);
        for (Block block : affectedBlocks) {
            if (block.getType() == Material.AIR || block.getType() == Material.BEDROCK) continue;
            block.setType(Material.AIR, false);
        }
        world.playSound(location, Sound.ENTITY_GENERIC_EXPLODE, 2.0f, 0.6f);
        world.playSound(location, Sound.BLOCK_ANVIL_LAND, 1.5f, 0.7f);
        world.playSound(location, Sound.ENTITY_LIGHTNING_BOLT_THUNDER, 1.0f, 1.2f);
        this.createShellImpactParticles(location);
        StratagemUtils.damageEntitiesInRadius(location, 6.0, 18.0, player);
        this.applyShellKnockback(location);
    }

    private void createShellImpactParticles(final Location location) {
        final World world = location.getWorld();
        if (world == null) {
            return;
        }
        world.spawnParticle(Particle.EXPLOSION, location, 8, 2.0, 2.0, 2.0, 0.0);
        world.spawnParticle(Particle.FLAME, location, 30, 3.0, 3.0, 3.0, 0.2);
        world.spawnParticle(Particle.LARGE_SMOKE, location, 25, 4.0, 4.0, 4.0, 0.15);
        world.spawnParticle(Particle.LAVA, location, 15, 2.0, 1.0, 2.0, 0.1);
        for (int i = 0; i < 12; ++i) {
            Vector shrapnel = new Vector((Math.random() - 0.5) * 6.0, Math.random() * 3.0 + 1.0, (Math.random() - 0.5) * 6.0);
            Location shrapnelLoc = location.clone().add(shrapnel);
            world.spawnParticle(Particle.CRIT, shrapnelLoc, 3, 0.2, 0.2, 0.2, 0.1);
        }
        new BukkitRunnable(this){
            double radius = 0.0;
            final double maxRadius = 9.0;

            public void run() {
                if (this.radius > 9.0) {
                    this.cancel();
                    return;
                }
                int points = (int)(this.radius * 8.0);
                for (int i = 0; i < points; ++i) {
                    double angle = (double)i * Math.PI * 2.0 / (double)points;
                    double x = Math.cos(angle) * this.radius;
                    double z = Math.sin(angle) * this.radius;
                    Location particleLocation = location.clone().add(x, 0.3, z);
                    world.spawnParticle(Particle.DUST, particleLocation, 1, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.DustOptions(Color.fromRGB((int)139, (int)69, (int)19), 1.5f));
                    world.spawnParticle(Particle.SMOKE, particleLocation, 1, 0.1, 0.1, 0.1, 0.05);
                }
                this.radius += 1.2;
            }
        }.runTaskTimer((Plugin)this.plugin, 2L, 2L);
    }

    private void applyShellKnockback(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        for (Entity entity : world.getNearbyEntities(location, 7.199999999999999, 7.199999999999999, 7.199999999999999)) {
            if (!(entity instanceof LivingEntity)) continue;
            double distance = entity.getLocation().distance(location);
            double knockbackStrength = Math.max(0.0, 1.0 - distance / 7.199999999999999);
            Vector knockback = entity.getLocation().toVector().subtract(location.toVector()).normalize();
            knockback.multiply(2.5 * knockbackStrength);
            knockback.setY(Math.max(knockback.getY(), 0.8 * knockbackStrength));
            entity.setVelocity(entity.getVelocity().add(knockback));
            if (!(entity instanceof Player) || !(distance < 4.199999999999999)) continue;
            ((Player)entity).sendMessage((Component)Component.text((String)"*Shell shock - ears ringing*", (TextColor)NamedTextColor.GRAY));
        }
    }

    private void broadcastBarrageWarning(Location location, Player caller) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        TextComponent warningMessage = Component.text((String)"\u26a0 ARTILLERY BARRAGE INCOMING! TAKE COVER! \u26a0", (TextColor)NamedTextColor.RED);
        for (Player player : world.getPlayers()) {
            if (!(player.getLocation().distance(location) <= 50.0)) continue;
            player.sendMessage((Component)warningMessage);
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 2.0f, 0.5f);
        }
    }

    private void addToItemDropPrevention(Location center) {
        int x = -21;
        while ((double)x <= 21.0) {
            int y = -6;
            while ((double)y <= 6.5) {
                int z = -21;
                while ((double)z <= 21.0) {
                    Location loc = center.clone().add((double)x, (double)y, (double)z);
                    itemDropPreventionZones.add(loc);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        new BukkitRunnable(this){

            public void run() {
                itemDropPreventionZones.clear();
            }
        }.runTaskLater((Plugin)this.plugin, 260L);
    }

    public static boolean isInItemDropPreventionZone(Location location) {
        return itemDropPreventionZones.contains(location);
    }

    public static boolean shouldPreventItemDrop(Location location) {
        return itemDropPreventionZones.contains(location);
    }
}

