/*
 * Decompiled with CFR 0.152.
 */
package com.procurer.stratagems;

import com.procurer.Main;
import com.procurer.enums.StratagemType;
import com.procurer.managers.BlockRegenerationManager;
import com.procurer.stratagems.AbstractStratagem;
import com.procurer.utils.ExplosionEffectsUtils;
import com.procurer.utils.StratagemUtils;
import java.util.HashSet;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Eagle500KGBomb
extends AbstractStratagem {
    private final BlockRegenerationManager blockRegenerationManager;
    private static final double EXPLOSION_POWER = 24.0;
    private static final double DAMAGE_MULTIPLIER = 8.0;
    private static final int STRIKE_HEIGHT = 80;
    private static final int EMBED_DELAY_TICKS = 20;
    private static final double INNER_RADIUS = 10.0;
    private static final double OUTER_RADIUS = 25.0;
    private static final double SHOCKWAVE_RADIUS = 35.0;
    private static final double CRATER_DEPTH = 8.0;
    private static final Set<Location> itemDropPreventionZones = new HashSet<Location>();

    public Eagle500KGBomb(JavaPlugin plugin) {
        super(plugin, StratagemType.EAGLE_500KG_BOMB);
        this.blockRegenerationManager = ((Main)plugin).getBlockRegenerationManager();
    }

    @Override
    public void execute(final Location location, final Player player) {
        this.onActivation(location, player);
        new BukkitRunnable(this){
            final /* synthetic */ Eagle500KGBomb this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.onImpact(location, player);
            }
        }.runTaskLater((Plugin)this.plugin, this.getDelayMillis() / 50L);
    }

    @Override
    protected void onActivation(Location location, Player player) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        world.playSound(location, Sound.ENTITY_ENDER_DRAGON_FLAP, 3.0f, 0.6f);
        world.playSound(location, Sound.ENTITY_WITHER_SPAWN, 1.0f, 1.8f);
        world.playSound(location, Sound.BLOCK_ANVIL_LAND, 0.8f, 0.3f);
        this.createMassiveTargeting(location, player);
        this.broadcastMassiveWarning(location, player);
        player.sendMessage(((TextComponent)Component.text((String)("INCOMING MASSIVE ORDNANCE! 500KG BOMB ETA " + this.getDelayMillis() / 1000L + " SECONDS!")).color((TextColor)NamedTextColor.DARK_RED)).decorate(TextDecoration.BOLD));
    }

    private void createMassiveTargeting(final Location center, Player player) {
        final World world = center.getWorld();
        if (world == null) {
            return;
        }
        new BukkitRunnable(this){
            int ticks = 0;
            final int maxTicks = (int)(this.this$0.getDelayMillis() / 50L);
            final /* synthetic */ Eagle500KGBomb this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.ticks >= this.maxTicks) {
                    this.cancel();
                    return;
                }
                for (int y = 0; y < 50; ++y) {
                    Location particleLocation = center.clone().add(0.0, (double)y, 0.0);
                    world.spawnParticle(Particle.DUST, particleLocation, 8, 0.3, 0.3, 0.3, 0.0, (Object)new Particle.DustOptions(Color.RED, 2.5f));
                    world.spawnParticle(Particle.FLAME, particleLocation, 3, 0.2, 0.2, 0.2, 0.05);
                }
                this.this$0.createTargetingCircle(center, 10.0, Color.RED, 2.0f);
                this.this$0.createTargetingCircle(center, 25.0, Color.ORANGE, 1.5f);
                this.this$0.createTargetingCircle(center, 35.0, Color.YELLOW, 1.0f);
                if (this.ticks % 20 == 0) {
                    world.playSound(center, Sound.BLOCK_NOTE_BLOCK_BASS, 2.0f, 0.5f);
                    world.spawnParticle(Particle.FLASH, center, 1, 0.0, 0.0, 0.0, 0.0);
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 4L);
    }

    private void createTargetingCircle(Location center, double radius, Color color, float size) {
        World world = center.getWorld();
        if (world == null) {
            return;
        }
        int points = (int)(radius * 4.0);
        for (int i = 0; i < points; ++i) {
            double angle = (double)i * Math.PI * 2.0 / (double)points;
            double x = Math.cos(angle) * radius;
            double z = Math.sin(angle) * radius;
            Location circleLocation = center.clone().add(x, 0.5, z);
            world.spawnParticle(Particle.DUST, circleLocation, 2, 0.1, 0.1, 0.1, 0.0, (Object)new Particle.DustOptions(color, size));
        }
    }

    @Override
    protected void onImpact(final Location location, final Player player) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        this.createIncomingMassiveBomb(location);
        new BukkitRunnable(this){
            final /* synthetic */ Eagle500KGBomb this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.executeEmbedAndDetonate(location, player);
            }
        }.runTaskLater((Plugin)this.plugin, 15L);
    }

    private void createIncomingMassiveBomb(final Location location) {
        final World world = location.getWorld();
        if (world == null) {
            return;
        }
        world.playSound(location, Sound.ENTITY_ENDER_DRAGON_FLAP, 4.0f, 0.4f);
        world.playSound(location, Sound.ENTITY_WITHER_SHOOT, 2.0f, 0.3f);
        world.playSound(location, Sound.BLOCK_ANVIL_FALL, 3.0f, 0.2f);
        new BukkitRunnable(this){
            int progress = 0;
            final int maxProgress = 15;

            public void run() {
                if (this.progress >= 15) {
                    this.cancel();
                    return;
                }
                double currentHeight = 80.0 - (double)this.progress * 5.333333333333333;
                Location particleLocation = location.clone().add(0.0, currentHeight, 0.0);
                world.spawnParticle(Particle.FLAME, particleLocation, 15, 1.0, 1.0, 1.0, 0.2);
                world.spawnParticle(Particle.SMOKE, particleLocation, 10, 0.8, 0.8, 0.8, 0.1);
                world.spawnParticle(Particle.LARGE_SMOKE, particleLocation, 5, 0.5, 0.5, 0.5, 0.05);
                world.spawnParticle(Particle.FIREWORK, particleLocation, 8, 0.6, 0.6, 0.6, 0.1);
                world.spawnParticle(Particle.CLOUD, particleLocation, 12, 2.0, 2.0, 2.0, 0.3);
                ++this.progress;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void executeEmbedAndDetonate(final Location location, final Player player) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        Set<Block> affectedBlocks = StratagemUtils.getAffectedBlocks(location, 26.0);
        if (!affectedBlocks.isEmpty()) {
            this.blockRegenerationManager.storeBlocksForRegeneration(affectedBlocks);
            this.plugin.getLogger().info("Stored " + affectedBlocks.size() + " blocks for Eagle 500KG regeneration");
        }
        ExplosionEffectsUtils.createIntenseBlockBlastEffect(location, affectedBlocks, 24.0, 2.5, this.plugin);
        this.addToItemDropPrevention(location);
        this.createEmbedImpact(location);
        new BukkitRunnable(this){
            final /* synthetic */ Eagle500KGBomb this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.createMassiveDetonation(location, player);
            }
        }.runTaskLater((Plugin)this.plugin, 20L);
    }

    private void createEmbedImpact(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        world.playSound(location, Sound.BLOCK_ANVIL_LAND, 3.0f, 0.1f);
        world.playSound(location, Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 0.8f);
        world.playSound(location, Sound.BLOCK_STONE_BREAK, 2.0f, 0.5f);
        world.createExplosion(location, 2.0f, false, false);
        world.spawnParticle(Particle.BLOCK, location, 30, 2.0, 1.0, 2.0, 0.2, (Object)Material.STONE.createBlockData());
        world.spawnParticle(Particle.LARGE_SMOKE, location, 15, 1.5, 0.5, 1.5, 0.1);
        world.spawnParticle(Particle.FLAME, location, 10, 1.0, 0.5, 1.0, 0.1);
        this.createEmbedCrater(location);
        this.createChargingEffect(location);
    }

    private void createEmbedCrater(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                for (int y = 0; y >= -2; --y) {
                    Block block;
                    Location blockLoc = location.clone().add((double)x, (double)y, (double)z);
                    double distance = blockLoc.distance(location);
                    if (!(distance <= 2.5) || (block = blockLoc.getBlock()).getType() == Material.AIR || block.getType() == Material.BEDROCK) continue;
                    block.setType(Material.AIR, false);
                }
            }
        }
    }

    private void createChargingEffect(final Location location) {
        final World world = location.getWorld();
        if (world == null) {
            return;
        }
        new BukkitRunnable(this){
            int beeps = 0;
            final int maxBeeps = 4;

            public void run() {
                if (this.beeps >= 4) {
                    this.cancel();
                    return;
                }
                float pitch = 0.8f + (float)this.beeps * 0.1f;
                world.playSound(location, Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, pitch);
                world.spawnParticle(Particle.DUST, location.clone().add(0.0, 0.5, 0.0), 5, 0.3, 0.1, 0.3, 0.0, (Object)new Particle.DustOptions(Color.RED, 1.5f));
                world.spawnParticle(Particle.FIREWORK, location.clone().add(0.0, 0.5, 0.0), 2, 0.2, 0.1, 0.2, 0.05);
                ++this.beeps;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 5L);
    }

    private void createMassiveDetonation(final Location location, Player player) {
        final World world = location.getWorld();
        if (world == null) {
            return;
        }
        world.playSound(location, Sound.ENTITY_GENERIC_EXPLODE, 5.0f, 0.1f);
        world.playSound(location, Sound.ENTITY_LIGHTNING_BOLT_THUNDER, 4.0f, 0.3f);
        world.playSound(location, Sound.ENTITY_DRAGON_FIREBALL_EXPLODE, 5.0f, 0.2f);
        world.playSound(location, Sound.ENTITY_WITHER_BREAK_BLOCK, 3.0f, 0.1f);
        world.playSound(location, Sound.BLOCK_ANVIL_LAND, 2.0f, 0.05f);
        world.createExplosion(location, 24.0f, false, true);
        new BukkitRunnable(this){

            public void run() {
                world.createExplosion(location.clone().add(0.0, 2.0, 0.0), 19.2f, false, true);
                world.playSound(location, Sound.ENTITY_GENERIC_EXPLODE, 3.0f, 0.2f);
            }
        }.runTaskLater((Plugin)this.plugin, 3L);
        new BukkitRunnable(this){

            public void run() {
                world.createExplosion(location.clone().add(0.0, -2.0, 0.0), 14.4f, false, true);
                world.playSound(location, Sound.ENTITY_GENERIC_EXPLODE, 2.0f, 0.3f);
            }
        }.runTaskLater((Plugin)this.plugin, 6L);
        this.createMassiveCrater(location);
        this.damageEntitiesInZones(location, player);
        this.createMassiveParticleEffects(location);
        this.scheduleCleanup(location);
    }

    private void createMassiveCrater(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        int blocksDestroyed = 0;
        int x = -27;
        while ((double)x <= 27.0) {
            int y = -8;
            while ((double)y <= 24.0) {
                int z = -27;
                while ((double)z <= 27.0) {
                    Block block;
                    Location blockLocation = location.clone().add((double)x, (double)y, (double)z);
                    double distance = blockLocation.distance(location);
                    double craterChance = 1.0 - distance / 27.0;
                    if (y < 0) {
                        craterChance *= 1.5;
                    }
                    if (craterChance > 0.1 && Math.random() < craterChance && (block = blockLocation.getBlock()).getType() != Material.AIR && block.getType() != Material.BEDROCK && block.getType() != Material.VOID_AIR) {
                        block.setType(Material.AIR, false);
                        ++blocksDestroyed;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        this.plugin.getLogger().info("Eagle 500KG Bomb destroyed " + blocksDestroyed + " blocks in massive crater");
    }

    private void damageEntitiesInZones(Location location, Player player) {
        StratagemUtils.damageEntitiesInRadius(location, 10.0, 120.0, player);
        StratagemUtils.damageEntitiesInRadius(location, 25.0, 64.0, player);
        for (Entity entity : location.getWorld().getNearbyEntities(location, 35.0, 35.0, 35.0)) {
            double distance = entity.getLocation().distance(location);
            if (!(distance <= 35.0) || !(distance > 25.0) || !(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            double damageRatio = 1.0 - distance / 35.0;
            double damage = 24.0 * damageRatio;
            livingEntity.damage(damage);
            Vector knockback = entity.getLocation().toVector().subtract(location.toVector()).normalize();
            knockback.multiply(4.0 * damageRatio);
            knockback.setY(Math.max(knockback.getY(), 1.0));
            entity.setVelocity(entity.getVelocity().add(knockback));
            entity.setFireTicks(100);
        }
    }

    private void createMassiveParticleEffects(final Location location) {
        final World world = location.getWorld();
        if (world == null) {
            return;
        }
        world.spawnParticle(Particle.EXPLOSION_EMITTER, location, 10, 3.0, 3.0, 3.0, 0.0);
        world.spawnParticle(Particle.FIREWORK, location, 100, 8.0, 8.0, 8.0, 0.5);
        world.spawnParticle(Particle.FLASH, location, 20, 4.0, 4.0, 4.0, 0.0);
        world.spawnParticle(Particle.FLAME, location, 80, 6.0, 6.0, 6.0, 0.3);
        world.spawnParticle(Particle.LAVA, location, 50, 5.0, 3.0, 5.0, 0.2);
        world.spawnParticle(Particle.LARGE_SMOKE, location, 60, 8.0, 8.0, 8.0, 0.4);
        new BukkitRunnable(this){
            double radius = 0.0;
            final double maxRadius = 35.0;

            public void run() {
                if (this.radius > 35.0) {
                    this.cancel();
                    return;
                }
                int points = (int)(this.radius * 8.0);
                for (int i = 0; i < points; ++i) {
                    double angle = (double)i * Math.PI * 2.0 / (double)points;
                    double x = Math.cos(angle) * this.radius;
                    double z = Math.sin(angle) * this.radius;
                    Location particleLocation = location.clone().add(x, 1.0, z);
                    world.spawnParticle(Particle.DUST, particleLocation, 3, 0.2, 0.2, 0.2, 0.0, (Object)new Particle.DustOptions(Color.WHITE, 3.0f));
                    world.spawnParticle(Particle.LARGE_SMOKE, particleLocation, 2, 0.3, 0.3, 0.3, 0.2);
                    world.spawnParticle(Particle.FLAME, particleLocation, 1, 0.1, 0.1, 0.1, 0.05);
                }
                this.radius += 1.0;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
        new BukkitRunnable(this){
            int ticks = 0;

            public void run() {
                if (this.ticks > 300) {
                    this.cancel();
                    return;
                }
                for (int i = 0; i < 8; ++i) {
                    Location debrisLocation = location.clone().add((Math.random() - 0.5) * 24.0 * 3.0, Math.random() * 15.0, (Math.random() - 0.5) * 24.0 * 3.0);
                    world.spawnParticle(Particle.BLOCK, debrisLocation, 8, 1.0, 1.0, 1.0, 0.0, (Object)Material.STONE.createBlockData());
                    world.spawnParticle(Particle.LARGE_SMOKE, debrisLocation, 4, 0.5, 0.5, 0.5, 0.2);
                    world.spawnParticle(Particle.FLAME, debrisLocation, 2, 0.3, 0.3, 0.3, 0.1);
                }
                if (this.ticks < 100) {
                    Location cloudLocation = location.clone().add(0.0, 10.0 + (double)this.ticks * 0.2, 0.0);
                    world.spawnParticle(Particle.LARGE_SMOKE, cloudLocation, 10, 3.0, 2.0, 3.0, 0.3);
                    world.spawnParticle(Particle.CLOUD, cloudLocation, 8, 4.0, 3.0, 4.0, 0.4);
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 3L);
    }

    private void broadcastMassiveWarning(Location location, Player caller) {
        location.getWorld().getNearbyEntities(location, 100.0, 100.0, 100.0).forEach(entity -> {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.sendMessage(((TextComponent)((TextComponent)Component.text((String)"\ud83d\udea8 DANGER! MASSIVE 500KG BOMB INCOMING! \ud83d\udea8").color((TextColor)NamedTextColor.DARK_RED)).decorate(TextDecoration.BOLD)).decorate(TextDecoration.UNDERLINED));
                player.sendMessage(((TextComponent)Component.text((String)"CLEAR THE AREA IMMEDIATELY!").color((TextColor)NamedTextColor.RED)).decorate(TextDecoration.BOLD));
                if (!player.equals((Object)caller)) {
                    player.sendMessage(Component.text((String)("Called in by: " + caller.getName())).color((TextColor)NamedTextColor.YELLOW));
                }
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 2.0f, 2.0f);
            }
        });
    }

    private void addToItemDropPrevention(Location center) {
        int x = -29;
        while ((double)x <= 29.0) {
            int y = -29;
            while ((double)y <= 29.0) {
                int z = -29;
                while ((double)z <= 29.0) {
                    Location loc = center.clone().add((double)x, (double)y, (double)z);
                    itemDropPreventionZones.add(loc);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    private void removeFromItemDropPrevention(Location center) {
        int x = -29;
        while ((double)x <= 29.0) {
            int y = -29;
            while ((double)y <= 29.0) {
                int z = -29;
                while ((double)z <= 29.0) {
                    Location loc = center.clone().add((double)x, (double)y, (double)z);
                    itemDropPreventionZones.remove(loc);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public static boolean shouldPreventItemDrop(Location itemLocation) {
        return itemDropPreventionZones.stream().anyMatch(preventLoc -> preventLoc.distance(itemLocation) <= 27.0);
    }

    private void scheduleCleanup(final Location center) {
        new BukkitRunnable(this){
            final /* synthetic */ Eagle500KGBomb this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.removeFromItemDropPrevention(center);
                this.this$0.plugin.getLogger().info("Eagle 500KG Bomb cleanup completed at " + center.getBlockX() + ", " + center.getBlockY() + ", " + center.getBlockZ());
            }
        }.runTaskLater((Plugin)this.plugin, 400L);
    }
}

