/*
 * Decompiled with CFR 0.152.
 */
package com.procurer.stratagems;

import com.procurer.Main;
import com.procurer.enums.StratagemType;
import com.procurer.managers.BlockRegenerationManager;
import com.procurer.stratagems.AbstractStratagem;
import com.procurer.utils.ExplosionEffectsUtils;
import com.procurer.utils.StratagemUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Fire;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class EagleNapalmAirstrike
extends AbstractStratagem {
    private final BlockRegenerationManager blockRegenerationManager;
    private static final double EXPLOSION_POWER = 3.0;
    private static final double DAMAGE_MULTIPLIER = 2.5;
    private static final int BOMB_COUNT = 5;
    private static final double BOMB_SPACING = 4.0;
    private static final int STRIKE_HEIGHT = 60;
    private static final int FIRE_DURATION_TICKS = 200;
    private static final double FIRE_DAMAGE = 3.0;
    private static final int FIRE_TICK_INTERVAL = 20;
    private static final Set<Location> itemDropPreventionZones = new HashSet<Location>();
    private static final Map<Location, Integer> fireZones = new HashMap<Location, Integer>();

    public EagleNapalmAirstrike(JavaPlugin plugin) {
        super(plugin, StratagemType.EAGLE_NAPALM_AIRSTRIKE);
        this.blockRegenerationManager = ((Main)plugin).getBlockRegenerationManager();
    }

    @Override
    public void execute(final Location location, final Player player) {
        this.onActivation(location, player);
        new BukkitRunnable(this){
            final /* synthetic */ EagleNapalmAirstrike this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.onImpact(location, player);
            }
        }.runTaskLater((Plugin)this.plugin, this.getDelayMillis() / 50L);
    }

    @Override
    protected void onActivation(Location location, Player player) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        world.playSound(location, Sound.ENTITY_ENDER_DRAGON_FLAP, 2.0f, 0.8f);
        world.playSound(location, Sound.ENTITY_PHANTOM_FLAP, 1.5f, 1.2f);
        this.createTargetingLine(location, player);
        player.sendMessage(Component.text((String)("Eagle Napalm inbound! ETA " + this.getDelayMillis() / 1000L + " seconds!")).color((TextColor)NamedTextColor.GOLD));
    }

    private void createTargetingLine(Location center, Player player) {
        final World world = center.getWorld();
        if (world == null) {
            return;
        }
        Vector direction = this.getPerpendicularDirection(player.getLocation().getDirection());
        final Location[] bombPositions = this.calculateBombPositions(center, direction);
        new BukkitRunnable(this){
            int ticks = 0;
            final int maxTicks = (int)(this.this$0.getDelayMillis() / 50L);
            final /* synthetic */ EagleNapalmAirstrike this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.ticks >= this.maxTicks) {
                    this.cancel();
                    return;
                }
                for (Location bombPos : bombPositions) {
                    for (int y = 0; y < 25; ++y) {
                        Location particleLocation = bombPos.clone().add(0.0, (double)y, 0.0);
                        world.spawnParticle(Particle.DUST, particleLocation, 2, 0.1, 0.1, 0.1, 0.0, (Object)new Particle.DustOptions(Color.RED, 1.0f));
                    }
                    for (int i = 0; i < 16; ++i) {
                        double angle = (double)i * Math.PI * 2.0 / 16.0;
                        double radius = 3.0;
                        double x = Math.cos(angle) * radius;
                        double z = Math.sin(angle) * radius;
                        Location circleLocation = bombPos.clone().add(x, 0.5, z);
                        world.spawnParticle(Particle.DUST, circleLocation, 1, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.DustOptions(Color.ORANGE, 1.5f));
                    }
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 4L);
    }

    private Vector getPerpendicularDirection(Vector playerDirection) {
        return new Vector(-playerDirection.getZ(), 0.0, playerDirection.getX()).normalize();
    }

    private Location[] calculateBombPositions(Location center, Vector direction) {
        Location[] positions = new Location[5];
        double totalLength = 16.0;
        Location startPos = center.clone().subtract(direction.clone().multiply(totalLength / 2.0));
        for (int i = 0; i < 5; ++i) {
            positions[i] = startPos.clone().add(direction.clone().multiply((double)i * 4.0));
        }
        return positions;
    }

    @Override
    protected void onImpact(Location location, final Player player) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        Vector direction = this.getPerpendicularDirection(player.getLocation().getDirection());
        Location[] bombPositions = this.calculateBombPositions(location, direction);
        this.createIncomingEagle(bombPositions);
        for (int i = 0; i < bombPositions.length; ++i) {
            final Location bombLocation = bombPositions[i];
            new BukkitRunnable(this){
                final /* synthetic */ EagleNapalmAirstrike this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.this$0.executeSingleBomb(bombLocation, player);
                }
            }.runTaskLater((Plugin)this.plugin, (long)i * 3L);
        }
    }

    private void createIncomingEagle(final Location[] bombPositions) {
        final World world = bombPositions[0].getWorld();
        if (world == null) {
            return;
        }
        world.playSound(bombPositions[0], Sound.ENTITY_ENDER_DRAGON_FLAP, 3.0f, 1.2f);
        world.playSound(bombPositions[0], Sound.ENTITY_PHANTOM_FLAP, 2.0f, 1.5f);
        new BukkitRunnable(this){
            int progress = 0;
            final int maxProgress = 8;

            public void run() {
                if (this.progress >= 8) {
                    this.cancel();
                    return;
                }
                for (Location bombPos : bombPositions) {
                    double currentHeight = 60.0 - (double)this.progress * 7.5;
                    Location particleLocation = bombPos.clone().add(0.0, currentHeight, 0.0);
                    world.spawnParticle(Particle.FLAME, particleLocation, 5, 0.5, 0.5, 0.5, 0.1);
                    world.spawnParticle(Particle.SMOKE, particleLocation, 3, 0.3, 0.3, 0.3, 0.05);
                }
                ++this.progress;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void executeSingleBomb(final Location location, Player player) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        Set<Block> affectedBlocks = StratagemUtils.getAffectedBlocks(location, 4.0);
        if (!affectedBlocks.isEmpty()) {
            this.blockRegenerationManager.storeBlocksForRegeneration(affectedBlocks);
            this.plugin.getLogger().info("Stored " + affectedBlocks.size() + " blocks for Eagle Napalm regeneration");
        }
        ExplosionEffectsUtils.createBlockBlastEffect(location, affectedBlocks, 3.0, this.plugin);
        this.addToItemDropPrevention(location);
        world.playSound(location, Sound.ENTITY_GENERIC_EXPLODE, 1.5f, 0.7f);
        world.playSound(location, Sound.BLOCK_FIRE_EXTINGUISH, 2.0f, 0.5f);
        world.playSound(location, Sound.ENTITY_BLAZE_SHOOT, 1.0f, 0.8f);
        world.createExplosion(location, 3.0f, false, true);
        this.createNapalmImpactParticles(location);
        StratagemUtils.damageEntitiesInRadius(location, 4.5, 10.0, player);
        this.createFireZone(location);
        new BukkitRunnable(this){
            final /* synthetic */ EagleNapalmAirstrike this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.placePostExplosionFire(location);
            }
        }.runTaskLater((Plugin)this.plugin, 10L);
        this.scheduleCleanup(location);
    }

    private void createNapalmImpactParticles(final Location location) {
        final World world = location.getWorld();
        if (world == null) {
            return;
        }
        world.spawnParticle(Particle.EXPLOSION, location, 5, 2.0, 2.0, 2.0, 0.0);
        world.spawnParticle(Particle.FLAME, location, 50, 3.0, 3.0, 3.0, 0.3);
        world.spawnParticle(Particle.LAVA, location, 20, 2.0, 1.0, 2.0, 0.1);
        world.spawnParticle(Particle.SMOKE, location, 30, 4.0, 4.0, 4.0, 0.2);
        new BukkitRunnable(this){
            double radius = 0.0;
            final double maxRadius = 5.0;

            public void run() {
                if (this.radius > 5.0) {
                    this.cancel();
                    return;
                }
                for (int i = 0; i < 24; ++i) {
                    double angle = (double)i * Math.PI * 2.0 / 24.0;
                    double x = Math.cos(angle) * this.radius;
                    double z = Math.sin(angle) * this.radius;
                    Location particleLocation = location.clone().add(x, 0.5, z);
                    world.spawnParticle(Particle.FLAME, particleLocation, 3, 0.2, 0.1, 0.2, 0.05);
                    world.spawnParticle(Particle.SMOKE, particleLocation, 2, 0.1, 0.1, 0.1, 0.02);
                }
                this.radius += 0.5;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 2L);
        new BukkitRunnable(this){
            int ticks = 0;

            public void run() {
                if (this.ticks > 200) {
                    this.cancel();
                    return;
                }
                for (int i = 0; i < 12; ++i) {
                    Location fireLocation = location.clone().add((Math.random() - 0.5) * 3.0 * 2.0, Math.random() * 3.0, (Math.random() - 0.5) * 3.0 * 2.0);
                    world.spawnParticle(Particle.FLAME, fireLocation, 2, 0.2, 0.2, 0.2, 0.03);
                    world.spawnParticle(Particle.LAVA, fireLocation, 1, 0.1, 0.1, 0.1, 0.01);
                    if (!(Math.random() < 0.4)) continue;
                    world.spawnParticle(Particle.SMOKE, fireLocation, 1, 0.2, 0.3, 0.2, 0.02);
                }
                this.ticks += 10;
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 10L);
    }

    private void createFireZone(final Location center) {
        fireZones.put(center.clone(), 200);
        new BukkitRunnable(this){
            int remainingTicks = 200;

            public void run() {
                if (this.remainingTicks <= 0) {
                    fireZones.remove(center);
                    this.cancel();
                    return;
                }
                StratagemUtils.damageEntitiesInRadius(center, 4.0, 3.0, null);
                for (Entity entity : center.getWorld().getNearbyEntities(center, 4.0, 4.0, 4.0)) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (entity instanceof Player) continue;
                    livingEntity.setFireTicks(60);
                }
                this.remainingTicks -= 20;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    private void placePostExplosionFire(final Location center) {
        World world = center.getWorld();
        if (world == null) {
            return;
        }
        HashSet<Block> fireBlocksPlaced = new HashSet<Block>();
        final int fireRadius = 3;
        for (int x = -fireRadius; x <= fireRadius; ++x) {
            for (int z = -fireRadius; z <= fireRadius; ++z) {
                Location fireLocation = center.clone().add((double)x, 0.0, (double)z);
                double distance = fireLocation.distance(center);
                if (!(distance <= (double)fireRadius)) continue;
                double fireChance = 0.8 * (1.0 - distance / (double)fireRadius);
                if (!(Math.random() < fireChance)) continue;
                Block block = fireLocation.getBlock();
                Block blockBelow = fireLocation.clone().add(0.0, -1.0, 0.0).getBlock();
                if (block.getType() != Material.AIR || !blockBelow.getType().isSolid() || blockBelow.getType().isFlammable()) continue;
                fireBlocksPlaced.add(block);
                block.setType(Material.FIRE);
                BlockData blockData = block.getBlockData();
                if (!(blockData instanceof Fire)) continue;
                Fire fireData = (Fire)blockData;
                fireData.setAge(fireData.getMaximumAge() - 2);
                block.setBlockData((BlockData)fireData);
            }
        }
        if (!fireBlocksPlaced.isEmpty()) {
            this.blockRegenerationManager.storeBlocksForRegeneration(fireBlocksPlaced);
            this.plugin.getLogger().info("Placed " + fireBlocksPlaced.size() + " fire blocks for napalm effect");
        }
        new BukkitRunnable(this){
            final /* synthetic */ EagleNapalmAirstrike this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.cleanupRemainingFire(center, fireRadius);
            }
        }.runTaskLater((Plugin)this.plugin, 200L);
        this.plugin.getLogger().info("Placed post-explosion fire at " + center.getBlockX() + ", " + center.getBlockY() + ", " + center.getBlockZ());
    }

    private void cleanupRemainingFire(Location center, int radius) {
        World world = center.getWorld();
        if (world == null) {
            return;
        }
        int cleanedBlocks = 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    Location checkLocation = center.clone().add((double)x, (double)y, (double)z);
                    Block block = checkLocation.getBlock();
                    if (block.getType() != Material.FIRE) continue;
                    block.setType(Material.AIR);
                    ++cleanedBlocks;
                }
            }
        }
        if (cleanedBlocks > 0) {
            this.plugin.getLogger().info("Cleaned up " + cleanedBlocks + " remaining fire blocks from napalm strike");
        }
    }

    private void addToItemDropPrevention(Location center) {
        int x = -5;
        while ((double)x <= 5.0) {
            int y = -5;
            while ((double)y <= 5.0) {
                int z = -5;
                while ((double)z <= 5.0) {
                    Location loc = center.clone().add((double)x, (double)y, (double)z);
                    itemDropPreventionZones.add(loc);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    private void removeFromItemDropPrevention(Location center) {
        int x = -5;
        while ((double)x <= 5.0) {
            int y = -5;
            while ((double)y <= 5.0) {
                int z = -5;
                while ((double)z <= 5.0) {
                    Location loc = center.clone().add((double)x, (double)y, (double)z);
                    itemDropPreventionZones.remove(loc);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public static boolean shouldPreventItemDrop(Location itemLocation) {
        return itemDropPreventionZones.stream().anyMatch(preventLoc -> preventLoc.distance(itemLocation) <= 3.0);
    }

    private void scheduleCleanup(final Location center) {
        new BukkitRunnable(this){
            final /* synthetic */ EagleNapalmAirstrike this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.removeFromItemDropPrevention(center);
                this.this$0.plugin.getLogger().info("Eagle Napalm cleanup completed at " + center.getBlockX() + ", " + center.getBlockY() + ", " + center.getBlockZ());
            }
        }.runTaskLater((Plugin)this.plugin, 300L);
    }
}

