/*
 * Decompiled with CFR 0.152.
 */
package com.procurer.stratagems;

import com.procurer.enums.StratagemType;
import com.procurer.stratagems.AbstractStratagem;
import com.procurer.utils.StratagemUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Bee;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Player;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Wolf;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class GatlingSentryStratagem
extends AbstractStratagem {
    private static final double DROP_HEIGHT = 28.0;
    private static final double TARGET_RANGE = 24.0;
    private static final int MAX_AMMO = 480;
    private static final int FIRE_INTERVAL_TICKS = 4;
    private static final double BULLET_SPEED = 2.7;
    private static final double BULLET_DAMAGE = 3.0;
    private static final long MAX_LIFETIME_TICKS = 2400L;
    private static final Particle.DustOptions TARGET_BEAM_COLOR = new Particle.DustOptions(Color.fromRGB((int)78, (int)210, (int)255), 1.5f);
    private static final Set<Block> reservedLandingPads = Collections.synchronizedSet(new HashSet());

    public GatlingSentryStratagem(JavaPlugin plugin) {
        super(plugin, StratagemType.GATLING_SENTRY);
    }

    @Override
    public void execute(final Location location, final Player player) {
        this.onActivation(location, player);
        new BukkitRunnable(this){
            final /* synthetic */ GatlingSentryStratagem this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.onImpact(location, player);
            }
        }.runTaskLater((Plugin)this.plugin, Math.max(1L, this.getDelayMillis() / 50L));
    }

    @Override
    protected void onActivation(Location location, Player player) {
        final World world = location.getWorld();
        if (world == null) {
            return;
        }
        world.playSound(location, Sound.EVENT_RAID_HORN, 1.4f, 0.7f);
        world.playSound(location, Sound.BLOCK_BEACON_AMBIENT, 1.2f, 1.4f);
        final Location target = location.clone().add(0.5, 0.0, 0.5);
        new BukkitRunnable(this){
            int ticks = 0;
            final int maxTicks = Math.max(20, (int)(this.this$0.getDelayMillis() / 50L));
            final /* synthetic */ GatlingSentryStratagem this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.ticks >= this.maxTicks || world == null) {
                    this.cancel();
                    return;
                }
                for (int y = 0; y < 25; ++y) {
                    world.spawnParticle(Particle.DUST, target.clone().add(0.0, (double)y, 0.0), 3, 0.15, 0.15, 0.15, 0.01, (Object)TARGET_BEAM_COLOR);
                }
                StratagemUtils.createParticleCircle(target, Particle.DUST, 3.0, 36, TARGET_BEAM_COLOR);
                StratagemUtils.createParticleCircle(target, Particle.DUST, 1.5, 24, new Particle.DustOptions(Color.fromRGB((int)10, (int)146, (int)239), 1.2f));
                if (this.ticks % 20 == 0) {
                    world.playSound(target, Sound.BLOCK_NOTE_BLOCK_HAT, 1.4f, 1.4f);
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 3L);
        player.sendMessage((Component)Component.text((String)"Gatling sentry inbound \u2013 clear the zone!", (TextColor)NamedTextColor.AQUA));
    }

    @Override
    protected void onImpact(Location location, Player player) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        Location landingSpot = this.findSafeLanding(location);
        if (landingSpot == null) {
            player.sendMessage((Component)Component.text((String)"No clear landing zone for the sentry!", (TextColor)NamedTextColor.RED));
            return;
        }
        this.spawnDropPod(world, landingSpot, player);
    }

    private Location findSafeLanding(Location target) {
        World world = target.getWorld();
        if (world == null) {
            return null;
        }
        Location groundLocation = target.clone();
        groundLocation.setY((double)world.getHighestBlockYAt(groundLocation));
        Block airBlock1 = world.getBlockAt(groundLocation.clone().add(0.0, 1.0, 0.0));
        Block airBlock2 = world.getBlockAt(groundLocation.clone().add(0.0, 2.0, 0.0));
        if (!airBlock1.getType().isAir() || !airBlock2.getType().isAir()) {
            for (int radius = 1; radius <= 3; ++radius) {
                block1: for (int x = -radius; x <= radius; ++x) {
                    for (int z = -radius; z <= radius; ++z) {
                        Location testLoc = target.clone().add((double)x, 0.0, (double)z);
                        testLoc.setY((double)world.getHighestBlockYAt(testLoc));
                        Block testAir1 = world.getBlockAt(testLoc.clone().add(0.0, 1.0, 0.0));
                        Block testAir2 = world.getBlockAt(testLoc.clone().add(0.0, 2.0, 0.0));
                        if (!testAir1.getType().isAir() || !testAir2.getType().isAir()) continue;
                        groundLocation = testLoc;
                        continue block1;
                    }
                }
                if (groundLocation != target) break;
            }
        }
        Location finalLocation = groundLocation.add(0.5, 1.0, 0.5);
        reservedLandingPads.add(world.getBlockAt(groundLocation));
        return finalLocation;
    }

    private void spawnDropPod(final World world, final Location landingSpot, final Player owner) {
        Location dropOrigin = landingSpot.clone().add(0.0, 28.0, 0.0);
        world.playSound(dropOrigin, Sound.ENTITY_FIREWORK_ROCKET_LAUNCH, 2.0f, 0.6f);
        for (int i = 0; i < 20; ++i) {
            world.spawnParticle(Particle.CLOUD, dropOrigin.clone().add(0.0, (double)(-i), 0.0), 6, 0.5, 0.5, 0.5, 0.05);
        }
        final FallingBlock pod = world.spawnFallingBlock(dropOrigin, Material.IRON_BLOCK.createBlockData());
        pod.setVelocity(new Vector(0.0, -1.5, 0.0));
        pod.setDropItem(false);
        pod.setHurtEntities(false);
        pod.customName((Component)Component.text((String)"stratagem_gatling_pod", (TextColor)NamedTextColor.GRAY));
        pod.setCustomNameVisible(false);
        new BukkitRunnable(this){
            int attempts = 0;
            final /* synthetic */ GatlingSentryStratagem this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (!pod.isValid()) {
                    Block blockAtLanding = world.getBlockAt(landingSpot);
                    if (blockAtLanding.getType() == Material.IRON_BLOCK) {
                        blockAtLanding.setType(Material.AIR);
                    }
                    this.cancel();
                    this.this$0.deployTurret(landingSpot, owner);
                    return;
                }
                world.spawnParticle(Particle.SMALL_FLAME, pod.getLocation(), 8, 0.3, 0.5, 0.3, 0.05);
                world.spawnParticle(Particle.SMOKE, pod.getLocation(), 4, 0.3, 0.5, 0.3, 0.01);
                if (pod.isOnGround() || this.attempts > 200) {
                    Location podLocation = pod.getLocation();
                    LandingEffect.create(world, podLocation);
                    pod.remove();
                    Block blockAtPodLocation = world.getBlockAt(podLocation);
                    if (blockAtPodLocation.getType() == Material.IRON_BLOCK) {
                        blockAtPodLocation.setType(Material.AIR);
                    }
                    this.this$0.deployTurret(landingSpot, owner);
                    this.cancel();
                }
                ++this.attempts;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void deployTurret(Location landingSpot, Player owner) {
        World world = landingSpot.getWorld();
        if (world == null) {
            return;
        }
        world.playSound(landingSpot, Sound.BLOCK_PISTON_EXTEND, 1.6f, 0.7f);
        world.playSound(landingSpot, Sound.ITEM_ARMOR_EQUIP_IRON, 1.0f, 1.3f);
        this.spawnLandingPad(world, landingSpot);
        ArmorStand turretStand = (ArmorStand)world.spawn(landingSpot.clone().add(0.0, 0.2, 0.0), ArmorStand.class, stand -> {
            stand.setInvisible(false);
            stand.setGravity(false);
            stand.setMarker(false);
            stand.setSmall(true);
            stand.setArms(true);
            stand.setBasePlate(false);
            if (stand.getEquipment() != null) {
                stand.getEquipment().setHelmet(new ItemStack(Material.IRON_BLOCK));
                stand.getEquipment().setItemInMainHand(new ItemStack(Material.CROSSBOW));
                stand.getEquipment().setChestplate(new ItemStack(Material.GRAY_CONCRETE));
                stand.getEquipment().setLeggings(new ItemStack(Material.IRON_LEGGINGS));
                stand.addEquipmentLock(EquipmentSlot.HEAD, ArmorStand.LockType.REMOVING_OR_CHANGING);
                stand.addEquipmentLock(EquipmentSlot.HAND, ArmorStand.LockType.REMOVING_OR_CHANGING);
                stand.addEquipmentLock(EquipmentSlot.CHEST, ArmorStand.LockType.REMOVING_OR_CHANGING);
                stand.addEquipmentLock(EquipmentSlot.LEGS, ArmorStand.LockType.REMOVING_OR_CHANGING);
                stand.addEquipmentLock(EquipmentSlot.FEET, ArmorStand.LockType.REMOVING_OR_CHANGING);
                stand.addEquipmentLock(EquipmentSlot.OFF_HAND, ArmorStand.LockType.REMOVING_OR_CHANGING);
            }
            stand.customName((Component)Component.text((String)"Gatling Sentry", (TextColor)NamedTextColor.AQUA));
            stand.setCustomNameVisible(true);
            stand.setCollidable(false);
            stand.setPersistent(false);
            stand.setInvulnerable(true);
        });
        TurretController controller = new TurretController(turretStand, owner, null);
        controller.begin();
        owner.sendMessage((Component)Component.text((String)"Gatling Sentry deployed and scanning for targets...", (TextColor)NamedTextColor.GREEN));
    }

    private void spawnLandingPad(World world, Location landingSpot) {
        Block block = landingSpot.clone().subtract(0.0, 1.0, 0.0).getBlock();
        if (!block.getType().isAir()) {
            reservedLandingPads.add(block);
        }
        world.spawnParticle(Particle.EXPLOSION, landingSpot, 12, 0.6, 0.1, 0.6, 0.01);
    }

    private static void removeLandingPad(Block block) {
        if (block == null) {
            return;
        }
        reservedLandingPads.remove(block);
    }

    private class TurretController
    extends BukkitRunnable {
        private final ArmorStand turret;
        private final Player owner;
        private final Block turretBase;
        private final World world;
        private int ammoRemaining = 480;
        private long livedTicks = 0L;
        private BukkitTask monitorTask;
        private LivingEntity currentTarget = null;
        private int idleCounter = 0;

        TurretController(ArmorStand turret, Player owner, Block turretBase) {
            this.turret = turret;
            this.owner = owner;
            this.turretBase = turretBase;
            this.world = turret.getWorld();
        }

        void begin() {
            this.runTaskTimer((Plugin)GatlingSentryStratagem.this.plugin, 20L, 4L);
            this.monitorTask = new BukkitRunnable(){

                public void run() {
                    if (!TurretController.this.turret.isValid()) {
                        TurretController.this.shutdown(false);
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)GatlingSentryStratagem.this.plugin, 40L, 20L);
            this.world.spawnParticle(Particle.CLOUD, this.turret.getLocation().add(0.0, 1.2, 0.0), 30, 0.4, 0.6, 0.4, 0.06);
        }

        public void run() {
            if (!this.turret.isValid()) {
                this.shutdown(false);
                this.cancel();
                return;
            }
            this.livedTicks += 4L;
            if (this.ammoRemaining <= 0 || this.livedTicks >= 2400L) {
                this.shutdown(true);
                this.cancel();
                return;
            }
            LivingEntity target = this.findPriorityTarget();
            if (target == null) {
                this.currentTarget = null;
                ++this.idleCounter;
                if (this.idleCounter % 60 == 0) {
                    this.world.playSound(this.turret.getLocation(), Sound.BLOCK_PISTON_CONTRACT, 0.3f, 1.8f);
                    float yaw = System.currentTimeMillis() / 100L % 360L;
                    this.turret.setRotation(yaw, 0.0f);
                }
                return;
            }
            if (this.currentTarget != target) {
                this.currentTarget = target;
                this.world.playSound(this.turret.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 0.8f, 1.5f);
                this.world.spawnParticle(Particle.DUST, target.getLocation().add(0.0, target.getHeight() / 2.0, 0.0), 3, 0.1, 0.1, 0.1, 0.0, (Object)new Particle.DustOptions(Color.RED, 1.0f));
            }
            this.idleCounter = 0;
            Vector aim = this.computeAimVector(target);
            if (aim == null) {
                return;
            }
            Location targetLoc = target.getLocation();
            Location turretLoc = this.turret.getLocation();
            Vector direction = targetLoc.toVector().subtract(turretLoc.toVector());
            float yaw = (float)Math.toDegrees(Math.atan2(-direction.getX(), direction.getZ()));
            float pitch = (float)Math.toDegrees(Math.atan2(-direction.getY(), Math.sqrt(direction.getX() * direction.getX() + direction.getZ() * direction.getZ())));
            this.turret.setRotation(yaw, pitch * 0.5f);
            this.shoot(aim);
        }

        private LivingEntity findPriorityTarget() {
            return this.world.getNearbyEntities(this.turret.getLocation(), 24.0, 24.0, 24.0).stream().filter(entity -> entity instanceof LivingEntity).map(entity -> (LivingEntity)entity).filter(living -> !living.equals((Object)this.owner)).filter(living -> !(living instanceof ArmorStand)).filter(this::isHostile).filter(living -> living.getLocation().getWorld() == this.world).filter(living -> living.isValid() && !living.isDead()).sorted(Comparator.comparingDouble(living -> living.getLocation().distanceSquared(this.turret.getLocation()))).findFirst().orElse(null);
        }

        private boolean isHostile(LivingEntity living) {
            Mob mob;
            Bee bee;
            Wolf wolf;
            if (living instanceof Monster || living instanceof Phantom || living instanceof Slime || living instanceof Shulker) {
                return true;
            }
            if (living instanceof Wolf && (wolf = (Wolf)living).isAngry()) {
                return true;
            }
            if (living instanceof Bee && (bee = (Bee)living).getAnger() > 0) {
                return true;
            }
            return living instanceof Mob && (mob = (Mob)living).getTarget() instanceof Player;
        }

        private Vector computeAimVector(LivingEntity target) {
            Location eye = target.getLocation().clone().add(0.0, target.getHeight() * 0.8, 0.0);
            Location muzzle = this.turret.getLocation().clone().add(0.0, 1.2, 0.0);
            if (!this.hasDirectLineOfSight(muzzle, eye)) {
                return null;
            }
            Vector direction = eye.toVector().subtract(muzzle.toVector()).normalize();
            if (Double.isNaN(direction.getX()) || Double.isNaN(direction.getY()) || Double.isNaN(direction.getZ())) {
                return null;
            }
            return direction;
        }

        private boolean hasDirectLineOfSight(Location from, Location to) {
            Vector direction = to.toVector().subtract(from.toVector());
            double distance = from.distance(to);
            Vector step = direction.normalize().multiply(0.5);
            Location current = from.clone();
            for (double d = 0.0; d < distance; d += 0.5) {
                Block block = current.getBlock();
                if (block.getType().isSolid() && block.getType() != Material.GLASS && block.getType() != Material.GLASS_PANE && !block.getType().name().contains("GLASS")) {
                    return false;
                }
                current.add(step);
            }
            return true;
        }

        private void shoot(Vector direction) {
            if (this.ammoRemaining <= 0) {
                return;
            }
            Location muzzle = this.turret.getLocation().clone().add(0.0, 1.2, 0.0);
            this.world.playSound(this.turret.getLocation(), Sound.ITEM_CROSSBOW_SHOOT, 0.8f, 1.4f);
            this.world.playSound(this.turret.getLocation(), Sound.ENTITY_BLAZE_SHOOT, 0.3f, 1.8f);
            this.world.playSound(this.turret.getLocation(), Sound.BLOCK_DISPENSER_DISPENSE, 0.4f, 2.0f);
            this.world.spawnParticle(Particle.CRIT, muzzle, 8, 0.1, 0.1, 0.1, 0.1);
            this.world.spawnParticle(Particle.SMALL_FLAME, muzzle, 5, 0.1, 0.1, 0.1, 0.02);
            this.world.spawnParticle(Particle.SMOKE, muzzle, 3, 0.05, 0.05, 0.05, 0.01);
            Location flashPoint = muzzle.clone().add(direction.clone().multiply(0.3));
            this.world.spawnParticle(Particle.FLASH, flashPoint, 1, 0.0, 0.0, 0.0, 0.0);
            Arrow projectile = this.world.spawnArrow(muzzle, direction, 2.7f, 0.05f);
            projectile.setDamage(3.0);
            projectile.setShooter((ProjectileSource)this.turret);
            projectile.setCritical(true);
            projectile.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
            projectile.setPierceLevel(0);
            projectile.setSilent(true);
            --this.ammoRemaining;
            if (this.ammoRemaining % 20 == 0 && this.owner != null && this.owner.isOnline()) {
                this.owner.sendActionBar((Component)Component.text((String)("\u25c9 Gatling Sentry: " + this.ammoRemaining + " rounds"), (TextColor)NamedTextColor.AQUA));
            }
            if (this.ammoRemaining == 60 && this.owner != null && this.owner.isOnline()) {
                this.owner.sendMessage((Component)Component.text((String)"\u26a0 Gatling Sentry low on ammo!", (TextColor)NamedTextColor.YELLOW));
                this.world.playSound(this.turret.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 1.0f, 0.8f);
            }
            if (this.ammoRemaining <= 0) {
                this.shutdown(true);
                this.cancel();
            }
        }

        private void shutdown(boolean outOfAmmo) {
            if (this.monitorTask != null) {
                this.monitorTask.cancel();
            }
            if (this.turret.isValid()) {
                this.world.spawnParticle(Particle.LARGE_SMOKE, this.turret.getLocation().add(0.0, 1.0, 0.0), 30, 0.6, 0.6, 0.6, 0.02);
                this.world.spawnParticle(Particle.EXPLOSION, this.turret.getLocation(), 3, 0.3, 0.3, 0.3, 0.0);
                this.world.playSound(this.turret.getLocation(), Sound.BLOCK_ANVIL_BREAK, 0.8f, 0.5f);
                this.world.playSound(this.turret.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 0.8f, 1.0f);
                if (outOfAmmo) {
                    this.world.playSound(this.turret.getLocation(), Sound.BLOCK_NOTE_BLOCK_SNARE, 1.0f, 0.8f);
                    if (this.owner != null && this.owner.isOnline()) {
                        this.owner.sendMessage((Component)Component.text((String)"\u25c9 Gatling Sentry ran out of ammunition and shut down.", (TextColor)NamedTextColor.GRAY));
                    }
                } else if (this.owner != null && this.owner.isOnline()) {
                    this.owner.sendMessage((Component)Component.text((String)"\u25c9 Gatling Sentry destroyed.", (TextColor)NamedTextColor.RED));
                }
                this.turret.remove();
            }
            if (this.turretBase != null) {
                GatlingSentryStratagem.removeLandingPad(this.turretBase);
            }
        }
    }

    private static final class LandingEffect {
        private LandingEffect() {
        }

        static void create(World world, Location location) {
            world.playSound(location, Sound.BLOCK_ANVIL_LAND, 1.5f, 0.6f);
            world.spawnParticle(Particle.CLOUD, location, 20, 0.6, 0.2, 0.6, 0.05);
            world.spawnParticle(Particle.CRIT, location, 12, 0.5, 0.3, 0.5, 0.01);
        }
    }
}

