/*
 * Decompiled with CFR 0.152.
 */
package com.procurer.stratagems;

import com.procurer.Main;
import com.procurer.enums.StratagemType;
import com.procurer.managers.BlockRegenerationManager;
import com.procurer.stratagems.AbstractStratagem;
import com.procurer.utils.ExplosionEffectsUtils;
import com.procurer.utils.StratagemUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class OrbitalPrecisionStrike
extends AbstractStratagem {
    private final BlockRegenerationManager blockRegenerationManager;
    private static final double EXPLOSION_POWER = 6.0;
    private static final double DAMAGE_MULTIPLIER = 5.0;
    private static final int BEAM_HEIGHT = 50;
    private static final int STRIKE_HEIGHT = 80;
    private static final Set<Location> itemDropPreventionAreas = Collections.synchronizedSet(new HashSet());

    public OrbitalPrecisionStrike(JavaPlugin plugin) {
        super(plugin, StratagemType.ORBITAL_PRECISION_STRIKE);
        this.blockRegenerationManager = ((Main)plugin).getBlockRegenerationManager();
    }

    @Override
    public void execute(final Location location, final Player player) {
        this.onActivation(location, player);
        new BukkitRunnable(this){
            final /* synthetic */ OrbitalPrecisionStrike this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.onImpact(location, player);
            }
        }.runTaskLater((Plugin)this.plugin, this.getDelayMillis() / 50L);
    }

    @Override
    protected void onActivation(Location location, Player player) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        this.createTargetingBeam(location);
        world.playSound(location, Sound.BLOCK_BEACON_ACTIVATE, 2.0f, 0.5f);
        this.showTargetingParticles(location);
        this.broadcastWarning(location, player);
    }

    private void startItemDropPrevention(final Location center, final Set<Block> destroyedBlocks) {
        Main mainPlugin = (Main)this.plugin;
        new BukkitRunnable(this){
            final /* synthetic */ OrbitalPrecisionStrike this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                for (Block block : destroyedBlocks) {
                    this.this$0.updatePhysicsAround(block.getLocation());
                }
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
        this.addToItemDropPrevention(center);
        new BukkitRunnable(this){
            final /* synthetic */ OrbitalPrecisionStrike this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.removeFromItemDropPrevention(center);
            }
        }.runTaskLater((Plugin)this.plugin, 60L);
    }

    private void updatePhysicsAround(Location location) {
        int[][] directions;
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        for (int[] dir : directions = new int[][]{{0, 1, 0}, {0, -1, 0}, {1, 0, 0}, {-1, 0, 0}, {0, 0, 1}, {0, 0, -1}}) {
            Block neighbor = world.getBlockAt(location.getBlockX() + dir[0], location.getBlockY() + dir[1], location.getBlockZ() + dir[2]);
            if (neighbor.getType() == Material.AIR) continue;
            Material originalType = neighbor.getType();
            BlockData originalData = neighbor.getBlockData();
            neighbor.setType(Material.AIR, false);
            neighbor.setType(originalType, true);
            neighbor.setBlockData(originalData, true);
        }
    }

    private void addToItemDropPrevention(Location center) {
        itemDropPreventionAreas.add(center.clone());
    }

    private void removeFromItemDropPrevention(Location center) {
        itemDropPreventionAreas.removeIf(loc -> loc.distance(center) < 12.0);
    }

    public static boolean shouldPreventItemDrop(Location itemLocation) {
        return itemDropPreventionAreas.stream().anyMatch(center -> center.getWorld().equals((Object)itemLocation.getWorld()) && center.distance(itemLocation) <= 12.0);
    }

    @Override
    protected void onImpact(final Location location, final Player player) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        this.createIncomingStrike(location);
        new BukkitRunnable(this){
            final /* synthetic */ OrbitalPrecisionStrike this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                Set<Block> affectedBlocks = StratagemUtils.getAffectedBlocks(location, 6.0);
                this.this$0.blockRegenerationManager.storeBlocksForRegeneration(affectedBlocks);
                this.this$0.createExplosion(location, player);
                this.this$0.playImpactSounds(location);
                this.this$0.createImpactParticles(location);
            }
        }.runTaskLater((Plugin)this.plugin, 10L);
    }

    private void createTargetingBeam(final Location location) {
        final World world = location.getWorld();
        if (world == null) {
            return;
        }
        new BukkitRunnable(this){
            int ticks = 0;
            final int maxTicks = (int)(this.this$0.getDelayMillis() / 50L);
            final /* synthetic */ OrbitalPrecisionStrike this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.ticks >= this.maxTicks) {
                    this.cancel();
                    return;
                }
                for (int y = 0; y < 50; ++y) {
                    Location particleLocation = location.clone().add(0.0, (double)y, 0.0);
                    world.spawnParticle(Particle.DUST, particleLocation, 3, 0.1, 0.1, 0.1, 0.0, (Object)new Particle.DustOptions(Color.RED, 1.5f));
                    if (y % 3 != 0) continue;
                    world.spawnParticle(Particle.FLAME, particleLocation, 1, 0.05, 0.05, 0.05, 0.0);
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 2L);
    }

    private void showTargetingParticles(final Location location) {
        final World world = location.getWorld();
        if (world == null) {
            return;
        }
        new BukkitRunnable(this){
            int ticks = 0;
            final int maxTicks = (int)(this.this$0.getDelayMillis() / 50L);
            final /* synthetic */ OrbitalPrecisionStrike this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.ticks >= this.maxTicks) {
                    this.cancel();
                    return;
                }
                double radius = 3.0 + (double)this.ticks * 0.1;
                for (int i = 0; i < 16; ++i) {
                    double angle = (double)i * Math.PI * 2.0 / 16.0;
                    double x = Math.cos(angle) * radius;
                    double z = Math.sin(angle) * radius;
                    Location particleLocation = location.clone().add(x, 0.5, z);
                    world.spawnParticle(Particle.DUST, particleLocation, 1, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.DustOptions(Color.ORANGE, 1.0f));
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 3L);
    }

    private void createIncomingStrike(final Location location) {
        final World world = location.getWorld();
        if (world == null) {
            return;
        }
        new BukkitRunnable(this){
            int progress = 0;
            final int maxProgress = 10;

            public void run() {
                double currentHeight;
                if (this.progress >= 10) {
                    this.cancel();
                    return;
                }
                for (double y = currentHeight = 80.0 - (double)this.progress * 8.0; y >= 0.0; y -= 2.0) {
                    Location particleLocation = location.clone().add(0.0, y, 0.0);
                    world.spawnParticle(Particle.FIREWORK, particleLocation, 5, 0.2, 0.2, 0.2, 0.1);
                    world.spawnParticle(Particle.FLASH, particleLocation, 1, 0.0, 0.0, 0.0, 0.0);
                    world.spawnParticle(Particle.END_ROD, particleLocation, 2, 0.1, 0.1, 0.1, 0.0);
                }
                float pitch = 0.5f + (float)this.progress * 0.1f;
                world.playSound(location, Sound.ENTITY_LIGHTNING_BOLT_THUNDER, 0.3f, pitch);
                ++this.progress;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void createExplosion(Location location, Player player) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        world.createExplosion(location.getX(), location.getY(), location.getZ(), 6.0f, false, false);
        Set<Block> affectedBlocks = StratagemUtils.getAffectedBlocks(location, 6.0);
        ExplosionEffectsUtils.createBlockBlastEffect(location, affectedBlocks, 6.0, this.plugin);
        this.startItemDropPrevention(location, affectedBlocks);
        for (Block block : affectedBlocks) {
            if (block.getType() == Material.AIR || block.getType() == Material.BEDROCK) continue;
            block.setType(Material.AIR, false);
        }
        location.getWorld().getNearbyEntities(location, 9.0, 9.0, 9.0).forEach(entity -> {
            if (!(entity instanceof Damageable)) {
                return;
            }
            if (entity instanceof Player) {
                Player targetPlayer = (Player)entity;
                double distance = entity.getLocation().distance(location);
                double maxDistance = 9.0;
                double damageRatio = Math.max(0.0, 1.0 - distance / maxDistance);
                double damage = 10.0 * damageRatio * 5.0;
                damage = Math.min(damage, targetPlayer.getHealth() * 0.8);
                targetPlayer.damage(damage, (Entity)player);
                Vector knockback = targetPlayer.getLocation().toVector().subtract(location.toVector()).normalize();
                knockback.multiply(2.0 * damageRatio);
                knockback.setY(Math.max(knockback.getY(), 0.5));
                targetPlayer.setVelocity(targetPlayer.getVelocity().add(knockback));
            } else {
                double distance = entity.getLocation().distance(location);
                double maxDistance = 9.0;
                double damageRatio = Math.max(0.0, 1.0 - distance / maxDistance);
                double damage = 20.0 * damageRatio * 5.0;
                ((Damageable)entity).damage(damage);
            }
        });
    }

    private void playImpactSounds(final Location location) {
        final World world = location.getWorld();
        if (world == null) {
            return;
        }
        world.playSound(location, Sound.ENTITY_GENERIC_EXPLODE, 2.0f, 0.5f);
        world.playSound(location, Sound.ENTITY_LIGHTNING_BOLT_THUNDER, 2.0f, 0.8f);
        world.playSound(location, Sound.ENTITY_DRAGON_FIREBALL_EXPLODE, 2.0f, 0.3f);
        world.playSound(location, Sound.BLOCK_ANVIL_LAND, 0.5f, 0.1f);
        new BukkitRunnable(this){

            public void run() {
                world.playSound(location, Sound.ENTITY_GENERIC_EXPLODE, 1.5f, 0.3f);
            }
        }.runTaskLater((Plugin)this.plugin, 5L);
    }

    private void createImpactParticles(final Location location) {
        final World world = location.getWorld();
        if (world == null) {
            return;
        }
        world.spawnParticle(Particle.EXPLOSION_EMITTER, location, 3, 1.0, 1.0, 1.0, 0.0);
        world.spawnParticle(Particle.FIREWORK, location, 50, 5.0, 5.0, 5.0, 0.3);
        world.spawnParticle(Particle.FLASH, location, 10, 2.0, 2.0, 2.0, 0.0);
        new BukkitRunnable(this){
            double radius = 0.0;
            final double maxRadius = 12.0;

            public void run() {
                if (this.radius > 12.0) {
                    this.cancel();
                    return;
                }
                for (int i = 0; i < 32; ++i) {
                    double angle = (double)i * Math.PI * 2.0 / 32.0;
                    double x = Math.cos(angle) * this.radius;
                    double z = Math.sin(angle) * this.radius;
                    Location particleLocation = location.clone().add(x, 0.5, z);
                    world.spawnParticle(Particle.DUST, particleLocation, 1, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.DustOptions(Color.WHITE, 2.0f));
                    world.spawnParticle(Particle.SMOKE, particleLocation, 2, 0.1, 0.1, 0.1, 0.1);
                }
                this.radius += 0.5;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
        new BukkitRunnable(this){
            int ticks = 0;

            public void run() {
                if (this.ticks > 100) {
                    this.cancel();
                    return;
                }
                for (int i = 0; i < 3; ++i) {
                    Location debrisLocation = location.clone().add((Math.random() - 0.5) * 6.0 * 2.0, Math.random() * 5.0, (Math.random() - 0.5) * 6.0 * 2.0);
                    world.spawnParticle(Particle.BLOCK, debrisLocation, 5, 0.5, 0.5, 0.5, 0.0, (Object)Material.STONE.createBlockData());
                    world.spawnParticle(Particle.LARGE_SMOKE, debrisLocation, 2, 0.2, 0.2, 0.2, 0.1);
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 10L, 2L);
    }

    private Set<Block> getAffectedBlocks(Location center, double radius) {
        HashSet<Block> blocks = new HashSet<Block>();
        World world = center.getWorld();
        if (world == null) {
            return blocks;
        }
        int centerX = center.getBlockX();
        int centerY = center.getBlockY();
        int centerZ = center.getBlockZ();
        int radiusInt = (int)Math.ceil(radius);
        for (int x = centerX - radiusInt; x <= centerX + radiusInt; ++x) {
            for (int y = centerY - radiusInt; y <= centerY + radiusInt; ++y) {
                for (int z = centerZ - radiusInt; z <= centerZ + radiusInt; ++z) {
                    Block block;
                    Location blockLocation = new Location(world, (double)x, (double)y, (double)z);
                    double distance = blockLocation.distance(center);
                    if (!(distance <= radius) || (block = world.getBlockAt(x, y, z)).getType() == Material.AIR || block.getType() == Material.BEDROCK || block.getType() == Material.VOID_AIR) continue;
                    blocks.add(block);
                }
            }
        }
        return blocks;
    }

    private void broadcastWarning(Location location, Player caller) {
        location.getWorld().getNearbyEntities(location, 50.0, 50.0, 50.0).forEach(entity -> {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.sendMessage(((TextComponent)Component.text((String)"\u26a0 ORBITAL STRIKE INCOMING! \u26a0").color((TextColor)NamedTextColor.RED)).decorate(TextDecoration.BOLD));
                if (!player.equals((Object)caller)) {
                    player.sendMessage(Component.text((String)("Called in by: " + caller.getName())).color((TextColor)NamedTextColor.YELLOW));
                }
            }
        });
    }
}

