/*
 * Decompiled with CFR 0.152.
 */
package com.procurer.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.FallingBlock;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ExplosionEffectsUtils {
    private static final Random random = new Random();

    public static void createBlockBlastEffect(Location center, Set<Block> destroyedBlocks, double explosionPower, JavaPlugin plugin) {
        World world = center.getWorld();
        if (world == null) {
            return;
        }
        int debrisCount = (int)(explosionPower * 8.0 + (double)random.nextInt((int)explosionPower * 4));
        debrisCount = Math.min(debrisCount, 100);
        List<Material> materialTypes = ExplosionEffectsUtils.getDebrisMaterials(destroyedBlocks);
        ArrayList<FallingBlock> debrisBlocks = new ArrayList<FallingBlock>();
        for (int i = 0; i < debrisCount; ++i) {
            double spawnRadius = explosionPower * 0.3;
            Vector randomOffset = ExplosionEffectsUtils.getRandomVector().multiply(spawnRadius * random.nextDouble());
            Location spawnLocation = center.clone().add(randomOffset);
            Material debrisMaterial = materialTypes.get(random.nextInt(materialTypes.size()));
            FallingBlock fallingBlock = world.spawnFallingBlock(spawnLocation, debrisMaterial.createBlockData());
            ExplosionEffectsUtils.configureFallingBlockForVisualEffect(fallingBlock);
            Vector velocity = ExplosionEffectsUtils.calculateDebrisVelocity(center, spawnLocation, explosionPower);
            fallingBlock.setVelocity(velocity);
            debrisBlocks.add(fallingBlock);
        }
        ExplosionEffectsUtils.scheduleDebrisCleanup(debrisBlocks, plugin);
        ExplosionEffectsUtils.createAdditionalDebrisParticles(center, explosionPower, world, plugin);
    }

    private static void configureFallingBlockForVisualEffect(FallingBlock fallingBlock) {
        fallingBlock.setDropItem(false);
        fallingBlock.setHurtEntities(false);
        fallingBlock.setCancelDrop(true);
        fallingBlock.setCustomName("\u00a77Debris");
        fallingBlock.setCustomNameVisible(false);
    }

    private static Vector calculateDebrisVelocity(Location center, Location spawnLocation, double explosionPower) {
        Vector direction = spawnLocation.toVector().subtract(center.toVector());
        direction = direction.lengthSquared() < 0.01 ? ExplosionEffectsUtils.getRandomVector() : direction.normalize();
        direction.add(ExplosionEffectsUtils.getRandomVector().multiply(0.3));
        direction = direction.normalize();
        double baseVelocity = 0.5 + explosionPower * 0.15;
        double velocityVariation = baseVelocity * (0.5 + random.nextDouble() * 0.5);
        direction.setY(Math.max(direction.getY(), 0.2));
        return direction.multiply(velocityVariation);
    }

    private static List<Material> getDebrisMaterials(Set<Block> destroyedBlocks) {
        ArrayList<Material> materials = new ArrayList<Material>();
        for (Block block : destroyedBlocks) {
            Material material = block.getType();
            if (!ExplosionEffectsUtils.isGoodDebrisMaterial(material)) continue;
            materials.add(material);
        }
        if (materials.size() < 3) {
            materials.add(Material.STONE);
            materials.add(Material.COBBLESTONE);
            materials.add(Material.DIRT);
            materials.add(Material.GRAVEL);
        }
        if (materials.isEmpty()) {
            materials.add(Material.STONE);
        }
        return materials;
    }

    private static boolean isGoodDebrisMaterial(Material material) {
        return material != Material.AIR && material != Material.VOID_AIR && material != Material.BEDROCK && material != Material.BARRIER && material != Material.WATER && material != Material.LAVA && material != Material.FIRE && !material.name().contains("SIGN") && !material.name().contains("BANNER") && !material.name().contains("SKULL") && !material.name().contains("HEAD");
    }

    private static Vector getRandomVector() {
        double x = (random.nextDouble() - 0.5) * 2.0;
        double y = (random.nextDouble() - 0.5) * 2.0;
        double z = (random.nextDouble() - 0.5) * 2.0;
        return new Vector(x, y, z).normalize();
    }

    private static void scheduleDebrisCleanup(List<FallingBlock> debrisBlocks, final JavaPlugin plugin) {
        final HashSet<FallingBlock> trackedDebris = new HashSet<FallingBlock>(debrisBlocks);
        new BukkitRunnable(){
            int checks = 0;
            final int maxChecks = 10;

            public void run() {
                if (this.checks >= 10) {
                    int finalCleanup = 0;
                    for (FallingBlock debris : trackedDebris) {
                        if (!debris.isValid() || debris.isDead()) continue;
                        debris.remove();
                        ++finalCleanup;
                    }
                    if (finalCleanup > 0) {
                        plugin.getLogger().info("Final cleanup removed " + finalCleanup + " remaining debris blocks");
                    }
                    this.cancel();
                    return;
                }
                int removedCount = 0;
                Iterator iterator = trackedDebris.iterator();
                while (iterator.hasNext()) {
                    FallingBlock debris = (FallingBlock)iterator.next();
                    if (debris.isValid() && !debris.isDead() && !debris.isOnGround()) continue;
                    if (debris.isValid() && !debris.isDead()) {
                        Location location = debris.getLocation();
                        if (location.getWorld() != null) {
                            location.getWorld().spawnParticle(Particle.SMOKE, location, 3, 0.1, 0.1, 0.1, 0.05);
                        }
                        debris.remove();
                    }
                    iterator.remove();
                    ++removedCount;
                }
                if (removedCount > 0) {
                    plugin.getLogger().info("Cleaned up " + removedCount + " explosion debris blocks (check " + (this.checks + 1) + ")");
                }
                ++this.checks;
            }
        }.runTaskTimer((Plugin)plugin, 40L, 40L);
    }

    private static void createAdditionalDebrisParticles(final Location center, final double explosionPower, final World world, JavaPlugin plugin) {
        new BukkitRunnable(){
            int ticks = 0;
            final int maxTicks = 40;

            public void run() {
                if (this.ticks >= 40) {
                    this.cancel();
                    return;
                }
                for (int i = 0; i < 5; ++i) {
                    Vector offset = ExplosionEffectsUtils.getRandomVector().multiply(explosionPower * random.nextDouble());
                    Location particleLocation = center.clone().add(offset);
                    world.spawnParticle(Particle.DUST, particleLocation, 3, 0.3, 0.3, 0.3, 0.0, (Object)new Particle.DustOptions(Color.GRAY, 1.5f));
                    world.spawnParticle(Particle.SMOKE, particleLocation, 2, 0.2, 0.2, 0.2, 0.1);
                }
                if (this.ticks % 5 == 0) {
                    Vector offset = ExplosionEffectsUtils.getRandomVector().multiply(explosionPower * 0.8);
                    Location particleLocation = center.clone().add(offset);
                    world.spawnParticle(Particle.BLOCK, particleLocation, 8, 0.5, 0.5, 0.5, 0.2, (Object)Material.STONE.createBlockData());
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)plugin, 5L, 2L);
    }

    public static void createIntenseBlockBlastEffect(final Location center, final Set<Block> destroyedBlocks, final double explosionPower, double intensityMultiplier, final JavaPlugin plugin) {
        ExplosionEffectsUtils.createBlockBlastEffect(center, destroyedBlocks, explosionPower * intensityMultiplier, plugin);
        if (intensityMultiplier > 1.5) {
            new BukkitRunnable(){

                public void run() {
                    ExplosionEffectsUtils.createBlockBlastEffect(center, destroyedBlocks, explosionPower * 0.7, plugin);
                }
            }.runTaskLater((Plugin)plugin, 10L);
            if (intensityMultiplier > 2.0) {
                new BukkitRunnable(){

                    public void run() {
                        ExplosionEffectsUtils.createBlockBlastEffect(center, destroyedBlocks, explosionPower * 0.5, plugin);
                    }
                }.runTaskLater((Plugin)plugin, 20L);
            }
        }
        ExplosionEffectsUtils.createIntenseDebrisParticles(center, explosionPower, intensityMultiplier, plugin);
    }

    private static void createIntenseDebrisParticles(final Location center, final double explosionPower, final double intensityMultiplier, JavaPlugin plugin) {
        final World world = center.getWorld();
        if (world == null) {
            return;
        }
        new BukkitRunnable(){
            int ticks = 0;
            final int maxTicks = (int)(60.0 * intensityMultiplier);

            public void run() {
                if (this.ticks >= this.maxTicks) {
                    this.cancel();
                    return;
                }
                int particleCount = (int)(8.0 * intensityMultiplier);
                for (int i = 0; i < particleCount; ++i) {
                    Vector offset = ExplosionEffectsUtils.getRandomVector().multiply(explosionPower * 1.5 * random.nextDouble());
                    Location particleLocation = center.clone().add(offset);
                    world.spawnParticle(Particle.DUST, particleLocation, 5, 0.5, 0.5, 0.5, 0.0, (Object)new Particle.DustOptions(Color.GRAY, 2.0f));
                    world.spawnParticle(Particle.LARGE_SMOKE, particleLocation, 3, 0.3, 0.3, 0.3, 0.15);
                    world.spawnParticle(Particle.BLOCK, particleLocation, 4, 0.4, 0.4, 0.4, 0.1, (Object)Material.STONE.createBlockData());
                }
                if (this.ticks % 3 == 0) {
                    double angle = (double)this.ticks * 0.3;
                    for (int ring = 1; ring <= 3; ++ring) {
                        double radius = (double)ring * explosionPower * 0.5;
                        double x = Math.cos(angle) * radius;
                        double z = Math.sin(angle) * radius;
                        double y = ring * 2;
                        Location spiralLocation = center.clone().add(x, y, z);
                        world.spawnParticle(Particle.DUST, spiralLocation, 2, 0.2, 0.2, 0.2, 0.0, (Object)new Particle.DustOptions(Color.fromRGB((int)139, (int)69, (int)19), 1.5f));
                    }
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)plugin, 10L, 2L);
    }
}

