/*
 * Decompiled with CFR 0.152.
 */
package com.procurer.utils;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class StratagemUtils {
    public static Set<Block> getAffectedBlocks(Location center, double radius) {
        HashSet<Block> blocks = new HashSet<Block>();
        World world = center.getWorld();
        if (world == null) {
            return blocks;
        }
        int centerX = center.getBlockX();
        int centerY = center.getBlockY();
        int centerZ = center.getBlockZ();
        int radiusInt = (int)Math.ceil(radius);
        for (int x = centerX - radiusInt; x <= centerX + radiusInt; ++x) {
            for (int y = centerY - radiusInt; y <= centerY + radiusInt; ++y) {
                for (int z = centerZ - radiusInt; z <= centerZ + radiusInt; ++z) {
                    Block otherHalf;
                    Block block;
                    Location blockLocation = new Location(world, (double)x, (double)y, (double)z);
                    double distance = blockLocation.distance(center);
                    if (!(distance <= radius) || (block = world.getBlockAt(x, y, z)).getType() == Material.AIR || block.getType() == Material.BEDROCK || block.getType() == Material.VOID_AIR) continue;
                    blocks.add(block);
                    if (!StratagemUtils.isDoubleChest(block) || (otherHalf = StratagemUtils.getDoubleChestOtherHalf(block)) == null) continue;
                    blocks.add(otherHalf);
                    System.out.println("[StratagemUtils] Double chest detected! Included both halves at " + String.valueOf(block.getLocation()) + " and " + String.valueOf(otherHalf.getLocation()));
                }
            }
        }
        return blocks;
    }

    private static boolean isDoubleChest(Block block) {
        Material type = block.getType();
        if (type != Material.CHEST && type != Material.TRAPPED_CHEST) {
            return false;
        }
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Chest) {
            Chest chestData = (Chest)blockData;
            return chestData.getType() != Chest.Type.SINGLE;
        }
        return false;
    }

    private static Block getDoubleChestOtherHalf(Block chestBlock) {
        Block otherBlock;
        if (!StratagemUtils.isDoubleChest(chestBlock)) {
            return null;
        }
        Chest chestData = (Chest)chestBlock.getBlockData();
        BlockFace facing = chestData.getFacing();
        Location otherLocation = null;
        if (chestData.getType() == Chest.Type.LEFT) {
            switch (facing) {
                case NORTH: {
                    otherLocation = chestBlock.getLocation().add(1.0, 0.0, 0.0);
                    break;
                }
                case SOUTH: {
                    otherLocation = chestBlock.getLocation().add(-1.0, 0.0, 0.0);
                    break;
                }
                case WEST: {
                    otherLocation = chestBlock.getLocation().add(0.0, 0.0, -1.0);
                    break;
                }
                case EAST: {
                    otherLocation = chestBlock.getLocation().add(0.0, 0.0, 1.0);
                }
            }
        } else if (chestData.getType() == Chest.Type.RIGHT) {
            switch (facing) {
                case NORTH: {
                    otherLocation = chestBlock.getLocation().add(-1.0, 0.0, 0.0);
                    break;
                }
                case SOUTH: {
                    otherLocation = chestBlock.getLocation().add(1.0, 0.0, 0.0);
                    break;
                }
                case WEST: {
                    otherLocation = chestBlock.getLocation().add(0.0, 0.0, 1.0);
                    break;
                }
                case EAST: {
                    otherLocation = chestBlock.getLocation().add(0.0, 0.0, -1.0);
                }
            }
        }
        if (otherLocation != null && (otherBlock = otherLocation.getBlock()).getType() == chestBlock.getType() && StratagemUtils.isDoubleChest(otherBlock)) {
            return otherBlock;
        }
        return null;
    }

    public static void damageEntitiesInRadius(Location center, double radius, double damage, Player excludePlayer) {
        World world = center.getWorld();
        if (world == null) {
            return;
        }
        for (Entity entity : world.getNearbyEntities(center, radius, radius, radius)) {
            double distance;
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity.equals((Object)excludePlayer) || !((distance = entity.getLocation().distance(center)) <= radius)) continue;
            double actualDamage = damage * (1.0 - distance / radius * 0.5);
            livingEntity.damage(actualDamage);
            Vector knockback = entity.getLocation().subtract(center).toVector().normalize();
            knockback.multiply(0.8);
            knockback.setY(Math.max(0.3, knockback.getY()));
            entity.setVelocity(knockback);
        }
    }

    public static void createExplosion(Location location, float power, boolean setFire, boolean breakBlocks) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        world.createExplosion(location, power, setFire, breakBlocks);
    }

    public static void playExplosionSounds(Location location, float volume, float pitch) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        world.playSound(location, Sound.ENTITY_GENERIC_EXPLODE, volume, pitch);
    }

    public static void createBasicExplosionParticles(Location location, int count) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        world.spawnParticle(Particle.EXPLOSION, location, count, 2.0, 2.0, 2.0, 0.0);
    }

    public static void updatePhysicsAround(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    Location updateLoc = location.clone().add((double)x, (double)y, (double)z);
                    Block block = updateLoc.getBlock();
                    if (block.getType() == Material.AIR) continue;
                    block.getState().update(true, true);
                }
            }
        }
    }

    public static boolean shouldPreserveBlock(Material material) {
        return material != Material.AIR && material != Material.BEDROCK && material != Material.VOID_AIR && material != Material.BARRIER;
    }

    public static void createParticleCircle(Location center, Particle particle, double radius, int points, Object data) {
        World world = center.getWorld();
        if (world == null) {
            return;
        }
        for (int i = 0; i < points; ++i) {
            double angle = (double)i * Math.PI * 2.0 / (double)points;
            double x = Math.cos(angle) * radius;
            double z = Math.sin(angle) * radius;
            Location particleLocation = center.clone().add(x, 0.5, z);
            if (data != null) {
                world.spawnParticle(particle, particleLocation, 1, 0.0, 0.0, 0.0, 0.0, data);
                continue;
            }
            world.spawnParticle(particle, particleLocation, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

