/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee;

import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_156;
import net.minecraft.class_173;
import net.minecraft.class_1860;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import snownee.lychee.Lychee;
import snownee.lychee.LycheeLootContextParamSets;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.recipes.AnvilCraftingRecipe;
import snownee.lychee.recipes.BlockClickingRecipe;
import snownee.lychee.recipes.BlockCrushingRecipe;
import snownee.lychee.recipes.BlockCrushingRecipeType;
import snownee.lychee.recipes.BlockExplodingRecipe;
import snownee.lychee.recipes.BlockInteractingRecipe;
import snownee.lychee.recipes.BlockInteractingRecipeType;
import snownee.lychee.recipes.DripstoneRecipe;
import snownee.lychee.recipes.DripstoneRecipeType;
import snownee.lychee.recipes.EntityTickingRecipe;
import snownee.lychee.recipes.EntityTickingRecipeType;
import snownee.lychee.recipes.ItemBurningRecipe;
import snownee.lychee.recipes.ItemExplodingRecipe;
import snownee.lychee.recipes.ItemInsideRecipe;
import snownee.lychee.recipes.ItemInsideRecipeType;
import snownee.lychee.recipes.LightningChannelingRecipe;
import snownee.lychee.recipes.RandomBlockTickingRecipe;
import snownee.lychee.recipes.RandomBlockTickingRecipeType;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.recipe.BlockKeyableRecipeType;
import snownee.lychee.util.recipe.ILycheeRecipe;
import snownee.lychee.util.recipe.ItemShapelessRecipeType;
import snownee.lychee.util.recipe.LycheeRecipeType;
import snownee.lychee.util.ui.BlankRecipe;
import snownee.lychee.util.ui.CategoryMetadata;
import snownee.lychee.util.ui.CategoryModifier;

public final class RecipeTypes {
    public static final Set<LycheeRecipeType<? extends ILycheeRecipe<LycheeContext>>> ALL;
    public static final class_3956<CategoryMetadata> CATEGORY_METADATA;
    public static final class_3956<CategoryModifier> CATEGORY_MODIFIER;
    public static final LycheeRecipeType<BlankRecipe> BLANK;
    public static final LycheeRecipeType<ItemBurningRecipe> ITEM_BURNING;
    public static final ItemInsideRecipeType ITEM_INSIDE;
    public static final BlockInteractingRecipeType<BlockInteractingRecipe> BLOCK_INTERACTING;
    public static final BlockInteractingRecipeType<BlockClickingRecipe> BLOCK_CLICKING;
    public static final LycheeRecipeType<AnvilCraftingRecipe> ANVIL_CRAFTING;
    public static final BlockCrushingRecipeType BLOCK_CRUSHING;
    public static final ItemShapelessRecipeType<LightningChannelingRecipe> LIGHTNING_CHANNELING;
    public static final ItemShapelessRecipeType<ItemExplodingRecipe> ITEM_EXPLODING;
    public static final BlockKeyableRecipeType<BlockExplodingRecipe> BLOCK_EXPLODING;
    public static final RandomBlockTickingRecipeType RANDOM_BLOCK_TICKING;
    public static final DripstoneRecipeType DRIPSTONE_DRIPPING;
    public static final EntityTickingRecipeType ENTITY_TICKING;

    public static <T extends LycheeRecipeType<? extends ILycheeRecipe<LycheeContext>>> T register(T recipeType) {
        ALL.add(recipeType);
        return (T)((LycheeRecipeType)class_2378.method_10230((class_2378)class_7923.field_41188, (class_2960)recipeType.id, recipeType));
    }

    public static void buildCache() {
        ALL.forEach(LycheeRecipeType::refreshCache);
        ALL.forEach(LycheeRecipeType::updateEmptyState);
    }

    public static <T extends class_3956<?>> T register(String name) {
        final class_2960 id = Lychee.id(name);
        return (T)((class_3956)class_2378.method_10230((class_2378)class_7923.field_41188, (class_2960)id, (Object)new class_3956<class_1860<?>>(){

            public String toString() {
                return id.toString();
            }
        }));
    }

    static {
        Objects.requireNonNull(LycheeLootContextParams.ALL);
        Objects.requireNonNull(LycheeLootContextParamSets.ALL);
        ALL = Sets.newLinkedHashSet();
        CATEGORY_METADATA = RecipeTypes.register("category_metadata");
        CATEGORY_MODIFIER = RecipeTypes.register("category_modifier");
        BLANK = RecipeTypes.register(new LycheeRecipeType<BlankRecipe>("blank", BlankRecipe.class, class_173.field_1175));
        ITEM_BURNING = RecipeTypes.register(new LycheeRecipeType<ItemBurningRecipe>("item_burning", ItemBurningRecipe.class, null));
        ITEM_INSIDE = RecipeTypes.register((ItemInsideRecipeType)class_156.method_654((Object)new ItemInsideRecipeType("item_inside", ItemInsideRecipe.class, null), it -> {
            it.canPreventConsumeInputs = true;
        }));
        BLOCK_INTERACTING = RecipeTypes.register((BlockInteractingRecipeType)class_156.method_654(new BlockInteractingRecipeType<BlockInteractingRecipe>("block_interacting", BlockInteractingRecipe.class, LycheeLootContextParamSets.BLOCK_INTERACTION), it -> {
            it.requiresClient = true;
            it.canPreventConsumeInputs = true;
        }));
        BLOCK_CLICKING = RecipeTypes.register((BlockInteractingRecipeType)class_156.method_654(new BlockInteractingRecipeType<BlockClickingRecipe>("block_clicking", BlockClickingRecipe.class, LycheeLootContextParamSets.BLOCK_INTERACTION), it -> {
            it.requiresClient = true;
            it.categoryId = RecipeTypes.BLOCK_INTERACTING.categoryId;
            it.canPreventConsumeInputs = true;
        }));
        ANVIL_CRAFTING = RecipeTypes.register(new LycheeRecipeType<AnvilCraftingRecipe>("anvil_crafting", AnvilCraftingRecipe.class, null));
        BLOCK_CRUSHING = RecipeTypes.register(new BlockCrushingRecipeType("block_crushing", BlockCrushingRecipe.class, null));
        LIGHTNING_CHANNELING = RecipeTypes.register((ItemShapelessRecipeType)class_156.method_654(new ItemShapelessRecipeType<LightningChannelingRecipe>("lightning_channeling", LightningChannelingRecipe.class, null), it -> {
            it.canPreventConsumeInputs = true;
        }));
        ITEM_EXPLODING = RecipeTypes.register((ItemShapelessRecipeType)class_156.method_654(new ItemShapelessRecipeType<ItemExplodingRecipe>("item_exploding", ItemExplodingRecipe.class, null), it -> {
            it.canPreventConsumeInputs = true;
        }));
        BLOCK_EXPLODING = RecipeTypes.register(new BlockKeyableRecipeType<BlockExplodingRecipe>("block_exploding", BlockExplodingRecipe.class, LycheeLootContextParamSets.BLOCK_ONLY));
        RANDOM_BLOCK_TICKING = RecipeTypes.register((RandomBlockTickingRecipeType)class_156.method_654((Object)new RandomBlockTickingRecipeType("random_block_ticking", RandomBlockTickingRecipe.class, LycheeLootContextParamSets.BLOCK_ONLY), it -> {
            it.extractChance = true;
        }));
        DRIPSTONE_DRIPPING = RecipeTypes.register((DripstoneRecipeType)class_156.method_654((Object)new DripstoneRecipeType("dripstone_dripping", DripstoneRecipe.class, LycheeLootContextParamSets.BLOCK_ONLY), it -> {
            it.extractChance = true;
            it.requiresClient = true;
        }));
        ENTITY_TICKING = RecipeTypes.register(new EntityTickingRecipeType("entity_ticking", EntityTickingRecipe.class, null));
    }
}

