/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.action;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4550;
import net.minecraft.class_5699;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.action.PostActionType;
import snownee.lychee.util.action.PostActionTypes;
import snownee.lychee.util.codec.LycheeCodecs;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record CycleStateProperty(PostActionCommonProperties commonProperties, class_4550 block, String propertyName, Supplier<class_2769<?>> propertySupplier, class_2338 offset, boolean reversed) implements PostAction
{
    public CycleStateProperty(PostActionCommonProperties commonProperties, class_4550 block, class_2338 offset, String propertyName, boolean reversed) {
        this(commonProperties, block, propertyName, (Supplier<class_2769<?>>)Suppliers.memoize(() -> CycleStateProperty.findProperty(block, propertyName)), offset, reversed);
    }

    public static class_2769<?> findProperty(class_4550 blockPredicate, String name) {
        class_2680 block = BlockPredicateExtensions.anyBlockState(blockPredicate);
        for (class_2769 property : block.method_28501()) {
            if (!name.equals(property.method_11899())) continue;
            return property;
        }
        throw new IllegalArgumentException("Unknown property name: " + name);
    }

    public PostActionType<CycleStateProperty> type() {
        return PostActionTypes.CYCLE_STATE_PROPERTY;
    }

    @Override
    public void apply(@Nullable ILycheeRecipe<?> recipe, LycheeContext context, int times) {
        class_2680 state;
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        class_2338 pos = lootParams.get(LycheeLootContextParams.BLOCK_POS).method_10081((class_2382)this.offset);
        class_1937 level = context.level();
        class_2680 oldState = level.method_8320(pos);
        class_2680 class_26802 = state = this.reversed ? CycleStateProperty.cycleReversed(oldState, this.property()) : (class_2680)oldState.method_28493(this.property());
        if (!level.method_8501(pos, state)) {
            return;
        }
        level.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43287((class_2680)state));
    }

    private static <T extends Comparable<T>> class_2680 cycleReversed(class_2680 oldState, class_2769<T> property) {
        Comparable value = oldState.method_11654(property);
        Collection values = property.method_11898();
        Comparable last = null;
        for (Comparable v : values) {
            if (last != null && v == value) {
                return (class_2680)oldState.method_11657(property, last);
            }
            last = v;
        }
        return last == null ? oldState : (class_2680)oldState.method_11657(property, last);
    }

    public class_2769<?> property() {
        return this.propertySupplier.get();
    }

    public static class Type
    implements PostActionType<CycleStateProperty> {
        public static final MapCodec<CycleStateProperty> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PostActionCommonProperties.MAP_CODEC.forGetter(CycleStateProperty::commonProperties), (App)BlockPredicateExtensions.CODEC.fieldOf("block").forGetter(CycleStateProperty::block), (App)LycheeCodecs.OFFSET.forGetter(CycleStateProperty::offset), (App)class_5699.field_41759.fieldOf("property").forGetter(CycleStateProperty::propertyName), (App)Codec.BOOL.optionalFieldOf("reversed", (Object)false).forGetter(CycleStateProperty::reversed)).apply((Applicative)instance, CycleStateProperty::new));
        public static final class_9139<class_9129, CycleStateProperty> STREAM_CODEC = class_9139.method_56906(PostActionCommonProperties.STREAM_CODEC, CycleStateProperty::commonProperties, (class_9139)class_4550.field_49181, CycleStateProperty::block, (class_9139)class_2338.field_48404, CycleStateProperty::offset, (class_9139)class_9135.field_48554, CycleStateProperty::propertyName, (class_9139)class_9135.field_48547, CycleStateProperty::reversed, CycleStateProperty::new);

        @Override
        public MapCodec<CycleStateProperty> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, CycleStateProperty> method_56104() {
            return STREAM_CODEC;
        }
    }
}

